/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.internal.slf4j;

import java.io.IOException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.sling.commons.log.internal.slf4j.LogConfigManager;
import org.apache.sling.commons.log.internal.slf4j.SlingLoggerLevel;
import org.apache.sling.commons.log.internal.slf4j.SlingLoggerWriter;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SlingLoggerConfig {
    private String configPid;
    private Set<String> categories;
    private SlingLoggerLevel level;
    private MessageFormat format;
    private SlingLoggerWriter writer;

    SlingLoggerConfig(String pid, String pattern, Set<String> categories, SlingLoggerLevel level, SlingLoggerWriter writer) {
        this.configPid = pid;
        this.configure(pattern, categories, level, writer);
    }

    void configure(String pattern, Set<String> categories, SlingLoggerLevel level, SlingLoggerWriter writer) {
        this.format = new MessageFormat(pattern);
        this.categories = new HashSet<String>(categories);
        this.level = level;
        this.writer = writer;
    }

    String getConfigPid() {
        return this.configPid;
    }

    boolean hasCategory(String category) {
        return this.categories.contains(category);
    }

    Set<String> getCategories() {
        return this.categories;
    }

    SlingLoggerWriter getLogWriter() {
        return this.writer;
    }

    void setLogWriter(SlingLoggerWriter writer) {
        this.writer = writer;
    }

    SlingLoggerLevel getLogLevel() {
        return this.level;
    }

    boolean isLevel(SlingLoggerLevel reference) {
        return this.level.compareTo(reference) <= 0;
    }

    void setLogLevel(SlingLoggerLevel level) {
        this.level = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void formatMessage(StringBuffer buffer, Marker marker, String name, SlingLoggerLevel level, String msg, String fqcn) {
        MessageFormat myFormat;
        MessageFormat messageFormat = myFormat = this.format;
        synchronized (messageFormat) {
            myFormat.format(new Object[]{new Date(), marker, Thread.currentThread().getName(), name, level.toString(), msg, fqcn}, buffer, new FieldPosition(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printMessage(String message, boolean needsEOL) {
        SlingLoggerWriter myOutput;
        SlingLoggerWriter slingLoggerWriter = myOutput = this.writer;
        synchronized (slingLoggerWriter) {
            try {
                myOutput.checkRotate();
                myOutput.write(message);
                if (needsEOL) {
                    myOutput.writeln();
                } else {
                    myOutput.flush();
                }
            }
            catch (IOException ioe) {
                LogConfigManager.internalFailure("Failed logging message: " + message, ioe);
            }
        }
    }
}

