/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.explorer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.util.TagUtils;
import org.weasis.core.api.explorer.DataExplorerView;
import org.weasis.core.api.media.data.MediaElement;
import org.weasis.core.api.media.data.MediaReader;
import org.weasis.core.api.media.data.MediaSeriesGroup;
import org.weasis.core.api.media.data.Series;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.ui.editor.SeriesViewerEvent;
import org.weasis.core.ui.editor.SeriesViewerListener;
import org.weasis.dicom.codec.DicomMediaIO;
import org.weasis.dicom.explorer.DicomExplorer;
import org.weasis.dicom.explorer.DicomModel;
import org.weasis.dicom.explorer.Messages;

public class DicomFieldsView
extends JTabbedPane
implements SeriesViewerListener {
    private final TagW[] PATIENT = new TagW[]{TagW.PatientName, TagW.PatientID, TagW.PatientSex, TagW.PatientBirthDate};
    private final TagW[] STATION = new TagW[]{TagW.Manufacturer, TagW.ManufacturerModelName, TagW.StationName};
    private final TagW[] STUDY = new TagW[]{TagW.StudyInstanceUID, TagW.StudyDate, TagW.StudyID, TagW.AccessionNumber, TagW.ReferringPhysicianName, TagW.StudyDescription};
    private final TagW[] SERIES = new TagW[]{TagW.SeriesInstanceUID, TagW.SeriesDate, TagW.SeriesNumber, TagW.Modality, TagW.ReferringPhysicianName, TagW.InstitutionName, TagW.InstitutionalDepartmentName, TagW.BodyPartExamined};
    private final TagW[] IMAGE = new TagW[]{TagW.SOPInstanceUID, TagW.ImageType, TagW.TransferSyntaxUID, TagW.InstanceNumber, TagW.PhotometricInterpretation, TagW.SamplesPerPixel, TagW.PixelRepresentation, TagW.Columns, TagW.Rows, TagW.ImageComments, TagW.ImageWidth, TagW.ImageHeight, TagW.ImageDepth, TagW.BitsAllocated, TagW.BitsStored};
    private final TagW[] IMAGE_PLANE = new TagW[]{TagW.PixelSpacing, TagW.SliceLocation, TagW.SliceThickness};
    private final TagW[] IMAGE_ACQ = new TagW[]{TagW.KVP, TagW.ContrastBolusAgent};
    private static final ThreadLocal<char[]> cbuf = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[96];
        }
    };
    private final JScrollPane allPane = new JScrollPane();
    private final JScrollPane limitedPane = new JScrollPane();
    private final JTextPane jTextPane1 = new JTextPane();
    private MediaElement currentMedia;
    private Series currentSeries;

    public DicomFieldsView() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addTab(Messages.getString("DicomFieldsView.limited"), null, panel, null);
        panel.add((Component)this.limitedPane, "Center");
        this.jTextPane1.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jTextPane1.setContentType("text/html");
        this.jTextPane1.setEditable(false);
        StyledDocument doc = this.jTextPane1.getStyledDocument();
        DicomFieldsView.addStylesToDocument(doc, UIManager.getColor("TextPane.foreground"));
        JPanel dump = new JPanel();
        dump.setLayout(new BorderLayout());
        dump.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addTab(Messages.getString("DicomFieldsView.all"), null, dump, null);
        dump.add((Component)this.allPane, "Center");
        this.setPreferredSize(new Dimension(1024, 1024));
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DicomFieldsView.this.changeDicomInfo(DicomFieldsView.this.currentSeries, DicomFieldsView.this.currentMedia);
            }
        };
        this.addChangeListener(changeListener);
    }

    public static void addStylesToDocument(StyledDocument doc, Color textColor) {
        SimpleAttributeSet def = new SimpleAttributeSet();
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = doc.addStyle("regular", style);
        StyleConstants.setFontFamily(def, "SansSerif");
        StyleConstants.setFontSize(def, 12);
        if (textColor == null) {
            textColor = UIManager.getColor("text");
        }
        StyleConstants.setForeground(def, textColor);
        Style s = doc.addStyle("title", regular);
        StyleConstants.setFontSize(s, 16);
        StyleConstants.setBold(s, true);
        s = doc.addStyle("bold", regular);
        StyleConstants.setBold(s, true);
        StyleConstants.setFontSize(s, 12);
        s = doc.addStyle("small", regular);
        StyleConstants.setFontSize(s, 10);
        s = doc.addStyle("large", regular);
        StyleConstants.setFontSize(s, 14);
        s = doc.addStyle("italic", regular);
        StyleConstants.setFontSize(s, 12);
        StyleConstants.setItalic(s, true);
    }

    public StringBuffer toStringBuffer(DicomElement element, DicomObject dcmObj) {
        StringBuffer sb = new StringBuffer();
        TagUtils.toStringBuffer((int)element.tag(), (StringBuffer)sb);
        sb.append(' ');
        sb.append(element.vr());
        sb.append(" #");
        sb.append(element.length());
        sb.append(" [");
        if (element.vr() == VR.SQ) {
            int size = element.countItems();
            if (size != 0) {
                if (size == 1) {
                    sb.append("1 item");
                } else {
                    sb.append(size).append(" items");
                }
            }
        } else {
            element.vr().promptValue(element.getBytes(), element.bigEndian(), null, cbuf.get(), 96, sb);
        }
        sb.append("] ");
        sb.append(dcmObj.nameOf(element.tag()));
        return sb;
    }

    public void addSequenceElement(DicomElement element, DefaultListModel listModel) {
        int n = element.countItems();
        for (int i = 0; i < n; ++i) {
            DicomObject dcmObj = element.getDicomObject(i);
            String[] val = dcmObj.toString().split("\n");
            for (int j = 0; j < val.length; ++j) {
                listModel.addElement(" >" + val[j]);
            }
        }
    }

    public void changingViewContentEvent(SeriesViewerEvent event) {
        if (event.getEventType().equals((Object)SeriesViewerEvent.EVENT.SELECT) || event.getEventType().equals((Object)SeriesViewerEvent.EVENT.LAYOUT)) {
            this.currentMedia = event.getMediaElement();
            this.currentSeries = event.getSeries();
            this.changeDicomInfo(this.currentSeries, this.currentMedia);
        }
    }

    private void changeDicomInfo(Series series, MediaElement media) {
        int index = this.getSelectedIndex();
        if (index == 0) {
            this.displayLimitedDicomInfo(series, media);
        } else {
            this.displayAllDicomInfo(series, media);
        }
    }

    private void displayAllDicomInfo(Series series, MediaElement media) {
        MediaReader loader;
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        if (media != null && (loader = media.getMediaReader()) instanceof DicomMediaIO) {
            DicomElement element;
            DicomObject dcmObj = ((DicomMediaIO)loader).getDicomObject();
            Iterator it = dcmObj.fileMetaInfoIterator();
            while (it.hasNext()) {
                element = (DicomElement)it.next();
                listModel.addElement(this.toStringBuffer(element, dcmObj).toString());
                if (element.vr() != VR.SQ) continue;
                this.addSequenceElement(element, listModel);
            }
            it = dcmObj.datasetIterator();
            while (it.hasNext()) {
                element = (DicomElement)it.next();
                listModel.addElement(this.toStringBuffer(element, dcmObj).toString());
                if (element.vr() != VR.SQ) continue;
                this.addSequenceElement(element, listModel);
            }
        }
        JList jListElement = new JList(listModel);
        jListElement.setLayoutOrientation(0);
        jListElement.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.allPane.setViewportView(jListElement);
    }

    private void displayLimitedDicomInfo(Series series, MediaElement media) {
        StyledDocument doc = this.jTextPane1.getStyledDocument();
        try {
            DataExplorerView dicomView;
            doc.remove(0, doc.getLength());
            if (media != null && (dicomView = org.weasis.core.ui.docking.UIManager.getExplorerplugin((String)DicomExplorer.NAME)) != null) {
                DicomModel model = (DicomModel)dicomView.getDataExplorerModel();
                MediaSeriesGroup study = model.getParent((MediaSeriesGroup)series, DicomModel.study);
                MediaReader loader = media.getMediaReader();
                if (loader instanceof DicomMediaIO) {
                    this.writeItems(Messages.getString("DicomFieldsView.pat"), this.PATIENT, model.getParent((MediaSeriesGroup)series, DicomModel.patient), doc);
                    this.writeItems(Messages.getString("DicomFieldsView.station"), this.STATION, (MediaSeriesGroup)series, doc);
                    this.writeItems(Messages.getString("DicomFieldsView.study"), this.STUDY, model.getParent((MediaSeriesGroup)series, DicomModel.study), doc);
                    this.writeItems(Messages.getString("DicomFieldsView.series"), this.SERIES, (MediaSeriesGroup)series, doc);
                    this.writeItems(Messages.getString("DicomFieldsView.object"), this.IMAGE, null, doc);
                    this.writeItems(Messages.getString("DicomFieldsView.plane"), this.IMAGE_PLANE, null, doc);
                    this.writeItems(Messages.getString("DicomFieldsView.acqu"), this.IMAGE_ACQ, null, doc);
                }
            }
        }
        catch (BadLocationException ble) {
            ble.getStackTrace();
        }
        this.limitedPane.setViewportView(this.jTextPane1);
    }

    private void writeItems(String title, TagW[] tags, MediaSeriesGroup group, StyledDocument doc) {
        Style regular = doc.getStyle("regular");
        Style italic = doc.getStyle("italic");
        int insertTitle = doc.getLength();
        boolean exist = false;
        for (TagW t : tags) {
            try {
                Object val;
                Object object = val = group == null ? this.currentMedia.getTagValue(t) : group.getTagValue(t);
                if (val == null) continue;
                exist = true;
                doc.insertString(doc.getLength(), t.toString(), italic);
                doc.insertString(doc.getLength(), ": " + TagW.getFormattedText((Object)val, (TagW.TagType)t.getType(), null) + "\n", regular);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        if (exist) {
            try {
                doc.insertString(insertTitle, title, doc.getStyle("title"));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }
}

