/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.base.ui.internal;

import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.weasis.base.ui.WeasisApp;
import org.weasis.base.ui.gui.WeasisWin;
import org.weasis.core.api.explorer.DataExplorerView;
import org.weasis.core.api.gui.util.GuiExecutor;
import org.weasis.core.api.gui.util.PageProps;
import org.weasis.core.ui.docking.DockableTool;
import org.weasis.core.ui.docking.UIManager;

public class Activator
implements BundleActivator,
ServiceListener {
    private static final String dataExplorerViewFilter = String.format("(%s=%s)", "objectClass", DataExplorerView.class.getName());
    private static ServiceTracker prefs_tracker = null;
    private BundleContext context = null;

    public void start(final BundleContext context) throws Exception {
        this.context = context;
        prefs_tracker = new ServiceTracker(context, PageProps.class.getName(), null);
        GuiExecutor.instance().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                WeasisWin app = WeasisWin.getInstance();
                try {
                    app.createMainPanel();
                    app.showWindow();
                }
                catch (Exception ex) {
                    System.err.println("Could not start GUI: " + ex);
                    ex.printStackTrace();
                    System.exit(-1);
                }
            }
        });
        Hashtable<String, Object> dict = new Hashtable<String, Object>();
        ((Dictionary)dict).put("osgi.command.scope", "weasis");
        ((Dictionary)dict).put("osgi.command.function", WeasisApp.functions);
        context.registerService(WeasisApp.class.getName(), (Object)WeasisApp.getInstance(), dict);
        GuiExecutor.instance().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    prefs_tracker.open();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ServiceTracker m_tracker = new ServiceTracker(context, DataExplorerView.class.getName(), null);
                m_tracker.open();
                Object[] services = m_tracker.getServices();
                for (int i = 0; services != null && i < services.length; ++i) {
                    List list = UIManager.EXPLORER_PLUGINS;
                    synchronized (list) {
                        if (!UIManager.EXPLORER_PLUGINS.contains(services[i]) && services[i] instanceof DataExplorerView) {
                            DataExplorerView explorer = (DataExplorerView)services[i];
                            UIManager.EXPLORER_PLUGINS.add(explorer);
                            if (explorer.getDataExplorerModel() != null) {
                                explorer.getDataExplorerModel().addPropertyChangeListener((PropertyChangeListener)WeasisWin.getInstance());
                            }
                            if (explorer instanceof DockableTool) {
                                DockableTool dockable = (DockableTool)explorer;
                                dockable.registerToolAsDockable();
                                dockable.showDockable();
                            }
                        }
                        continue;
                    }
                }
                try {
                    context.addServiceListener((ServiceListener)Activator.this, dataExplorerViewFilter);
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.context = null;
    }

    public synchronized void serviceChanged(final ServiceEvent event) {
        GuiExecutor.instance().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final ServiceReference m_ref = event.getServiceReference();
                Object service = Activator.this.context.getService(m_ref);
                if (service == null) {
                    return;
                }
                if (service instanceof DataExplorerView) {
                    final DataExplorerView explorer = (DataExplorerView)service;
                    List list = UIManager.EXPLORER_PLUGINS;
                    synchronized (list) {
                        if (event.getType() == 1) {
                            if (!UIManager.EXPLORER_PLUGINS.contains(explorer)) {
                                UIManager.EXPLORER_PLUGINS.add(explorer);
                                if (explorer.getDataExplorerModel() != null) {
                                    explorer.getDataExplorerModel().addPropertyChangeListener((PropertyChangeListener)WeasisWin.getInstance());
                                }
                                if (explorer instanceof DockableTool) {
                                    DockableTool dockable = (DockableTool)explorer;
                                    dockable.registerToolAsDockable();
                                    dockable.showDockable();
                                }
                            }
                        } else if (event.getType() == 4) {
                            GuiExecutor.instance().execute(new Runnable(){

                                @Override
                                public void run() {
                                    if (UIManager.EXPLORER_PLUGINS.contains(explorer)) {
                                        if (explorer.getDataExplorerModel() != null) {
                                            explorer.getDataExplorerModel().removePropertyChangeListener((PropertyChangeListener)WeasisWin.getInstance());
                                        }
                                        UIManager.EXPLORER_PLUGINS.remove(explorer);
                                        explorer.dispose();
                                        Activator.this.context.ungetService(m_ref);
                                    }
                                }
                            });
                        }
                    }
                }
            }
        });
    }

    public static Object[] getPreferencesPages() {
        return prefs_tracker == null ? null : prefs_tracker.getServices();
    }
}

