/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.PatternOpImage;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;

final class ConstantOpImage
extends PatternOpImage {
    private static Raster makePattern(SampleModel sampleModel, Number[] numberArray) {
        Object object;
        WritableRaster writableRaster = RasterFactory.createWritableRaster(sampleModel, new Point(0, 0));
        int n = sampleModel.getWidth();
        int n2 = sampleModel.getHeight();
        int n3 = sampleModel.getTransferType();
        int n4 = sampleModel.getNumBands();
        switch (n3) {
            case 0: {
                int n5;
                object = new int[n4];
                for (n5 = 0; n5 < n4; ++n5) {
                    object[n5] = numberArray[n5].intValue() & 0xFF;
                }
                for (n5 = 0; n5 < n; ++n5) {
                    writableRaster.setPixel(n5, 0, (int[])object);
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                int n6;
                int[] nArray = new int[n4];
                for (n6 = 0; n6 < n4; ++n6) {
                    nArray[n6] = numberArray[n6].intValue();
                }
                for (n6 = 0; n6 < n; ++n6) {
                    writableRaster.setPixel(n6, 0, nArray);
                }
                break;
            }
            case 4: {
                int n7;
                float[] fArray = new float[n4];
                for (n7 = 0; n7 < n4; ++n7) {
                    fArray[n7] = numberArray[n7].floatValue();
                }
                for (n7 = 0; n7 < n; ++n7) {
                    writableRaster.setPixel(n7, 0, fArray);
                }
                break;
            }
            case 5: {
                int n8;
                double[] dArray = new double[n4];
                for (n8 = 0; n8 < n4; ++n8) {
                    dArray[n8] = numberArray[n8].doubleValue();
                }
                for (n8 = 0; n8 < n; ++n8) {
                    writableRaster.setPixel(n8, 0, dArray);
                }
                break;
            }
        }
        object = writableRaster.getDataElements(0, 0, n, 1, null);
        for (int i = 1; i < n2; ++i) {
            writableRaster.setDataElements(0, i, n, 1, object);
        }
        return writableRaster;
    }

    private static SampleModel makeSampleModel(int n, int n2, Number[] numberArray) {
        int n3;
        int n4 = numberArray.length;
        if (numberArray instanceof Byte[]) {
            n3 = 0;
        } else if (numberArray instanceof Short[]) {
            n3 = 1;
            Short[] shortArray = (Short[])numberArray;
            for (int i = 0; i < n4; ++i) {
                if (shortArray[i] >= 0) continue;
                n3 = 2;
                break;
            }
        } else {
            n3 = numberArray instanceof Integer[] ? 3 : (numberArray instanceof Float[] ? 4 : (numberArray instanceof Double[] ? 5 : 32));
        }
        return RasterFactory.createPixelInterleavedSampleModel(n3, n, n2, n4);
    }

    private static Raster patternHelper(int n, int n2, Number[] numberArray) {
        SampleModel sampleModel = ConstantOpImage.makeSampleModel(n, n2, numberArray);
        return ConstantOpImage.makePattern(sampleModel, numberArray);
    }

    private static ColorModel colorModelHelper(Number[] numberArray) {
        SampleModel sampleModel = ConstantOpImage.makeSampleModel(1, 1, numberArray);
        return PlanarImage.createColorModel(sampleModel);
    }

    public ConstantOpImage(int n, int n2, int n3, int n4, int n5, int n6, Number[] numberArray) {
        super(ConstantOpImage.patternHelper(n5, n6, numberArray), ConstantOpImage.colorModelHelper(numberArray), n, n2, n3, n4);
    }
}

