/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class NotOpImage
extends ColormapOpImage {
    public NotOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout) {
        super(renderedImage, imageLayout, map, true);
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void transformColormap(byte[][] byArray) {
        for (int i = 0; i < 3; ++i) {
            byte[] byArray2 = byArray[i];
            int n = byArray2.length;
            for (int j = 0; j < n; ++j) {
                byArray2[j] = ~byArray2[j];
            }
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        if (rasterAccessor2.isBinary()) {
            byte[] byArray = rasterAccessor.getBinaryDataArray();
            byte[] byArray2 = rasterAccessor2.getBinaryDataArray();
            int n = byArray2.length;
            for (int i = 0; i < n; ++i) {
                byArray2[i] = ~byArray[i];
            }
            rasterAccessor2.copyBinaryDataToRaster();
            return;
        }
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(n3, n4, n5, n, n2, nArray, rasterAccessor.getByteDataArrays(), n6, n7, nArray2, rasterAccessor2.getByteDataArrays());
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(n3, n4, n5, n, n2, nArray, rasterAccessor.getShortDataArrays(), n6, n7, nArray2, rasterAccessor2.getShortDataArrays());
                break;
            }
            case 3: {
                this.intLoop(n3, n4, n5, n, n2, nArray, rasterAccessor.getIntDataArrays(), n6, n7, nArray2, rasterAccessor2.getIntDataArrays());
            }
        }
        rasterAccessor2.copyDataToRaster();
    }

    private void byteLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, byte[][] byArray, int n6, int n7, int[] nArray2, byte[][] byArray2) {
        for (int i = 0; i < n; ++i) {
            byte[] byArray3 = byArray[i];
            byte[] byArray4 = byArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            for (int j = 0; j < n3; ++j) {
                int n10 = n8;
                int n11 = n9;
                n8 += n4;
                n9 += n6;
                for (int k = 0; k < n2; ++k) {
                    byArray4[n11] = ~byArray3[n10];
                    n10 += n5;
                    n11 += n7;
                }
            }
        }
    }

    private void shortLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, short[][] sArray, int n6, int n7, int[] nArray2, short[][] sArray2) {
        for (int i = 0; i < n; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            for (int j = 0; j < n3; ++j) {
                int n10 = n8;
                int n11 = n9;
                n8 += n4;
                n9 += n6;
                for (int k = 0; k < n2; ++k) {
                    sArray4[n11] = ~sArray3[n10];
                    n10 += n5;
                    n11 += n7;
                }
            }
        }
    }

    private void intLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, int[][] nArray2, int n6, int n7, int[] nArray3, int[][] nArray4) {
        for (int i = 0; i < n; ++i) {
            int[] nArray5 = nArray2[i];
            int[] nArray6 = nArray4[i];
            int n8 = nArray[i];
            int n9 = nArray3[i];
            for (int j = 0; j < n3; ++j) {
                int n10 = n8;
                int n11 = n9;
                n8 += n4;
                n9 += n6;
                for (int k = 0; k < n2; ++k) {
                    nArray6[n11] = ~nArray5[n10];
                    n10 += n5;
                    n11 += n7;
                }
            }
        }
    }
}

