/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.Warp;
import javax.media.jai.WarpOpImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

final class WarpNearestOpImage
extends WarpOpImage {
    public WarpNearestOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, Warp warp, Interpolation interpolation, double[] dArray) {
        super(renderedImage, imageLayout, map, false, null, interpolation, warp, dArray);
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            this.sampleModel = renderedImage.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = colorModel;
        }
    }

    protected void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(planarImageArray[0], rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(planarImageArray[0], rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(planarImageArray[0], rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(planarImageArray[0], rasterAccessor);
            }
        }
        if (rasterAccessor.isDataCopy()) {
            rasterAccessor.clampDataArrays();
            rasterAccessor.copyDataToRaster();
        }
    }

    private void computeRectByte(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        int n;
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMaxX();
        int n4 = planarImage.getMinY();
        int n5 = planarImage.getMaxY();
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        float[] fArray = new float[2 * n6];
        int n11 = 0;
        byte[] byArray2 = new byte[n8];
        for (n = 0; n < n8; ++n) {
            byArray2[n] = (byte)this.backgroundValues[n];
        }
        for (n = 0; n < n7; ++n) {
            int n12 = n11;
            n11 += n9;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n, n6, 1, fArray);
            int n13 = 0;
            for (int i = 0; i < n6; ++i) {
                int n14;
                int n15 = WarpNearestOpImage.round(fArray[n13++]);
                int n16 = WarpNearestOpImage.round(fArray[n13++]);
                if (n15 < n2 || n15 >= n3 || n16 < n4 || n16 >= n5) {
                    if (this.setBackground) {
                        for (n14 = 0; n14 < n8; ++n14) {
                            byArray[n14][n12 + nArray[n14]] = byArray2[n14];
                        }
                    }
                } else {
                    for (n14 = 0; n14 < n8; ++n14) {
                        byArray[n14][n12 + nArray[n14]] = (byte)(randomIter.getSample(n15, n16, n14) & 0xFF);
                    }
                }
                n12 += n10;
            }
        }
    }

    private void computeRectUShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        int n;
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMaxX();
        int n4 = planarImage.getMinY();
        int n5 = planarImage.getMaxY();
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        float[] fArray = new float[2 * n6];
        int n11 = 0;
        short[] sArray2 = new short[n8];
        for (n = 0; n < n8; ++n) {
            sArray2[n] = (short)this.backgroundValues[n];
        }
        for (n = 0; n < n7; ++n) {
            int n12 = n11;
            n11 += n9;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n, n6, 1, fArray);
            int n13 = 0;
            for (int i = 0; i < n6; ++i) {
                int n14;
                int n15 = WarpNearestOpImage.round(fArray[n13++]);
                int n16 = WarpNearestOpImage.round(fArray[n13++]);
                if (n15 < n2 || n15 >= n3 || n16 < n4 || n16 >= n5) {
                    if (this.setBackground) {
                        for (n14 = 0; n14 < n8; ++n14) {
                            sArray[n14][n12 + nArray[n14]] = sArray2[n14];
                        }
                    }
                } else {
                    for (n14 = 0; n14 < n8; ++n14) {
                        sArray[n14][n12 + nArray[n14]] = (short)(randomIter.getSample(n15, n16, n14) & 0xFFFF);
                    }
                }
                n12 += n10;
            }
        }
    }

    private void computeRectShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        int n;
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMaxX();
        int n4 = planarImage.getMinY();
        int n5 = planarImage.getMaxY();
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        float[] fArray = new float[2 * n6];
        int n11 = 0;
        short[] sArray2 = new short[n8];
        for (n = 0; n < n8; ++n) {
            sArray2[n] = (short)this.backgroundValues[n];
        }
        for (n = 0; n < n7; ++n) {
            int n12 = n11;
            n11 += n9;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n, n6, 1, fArray);
            int n13 = 0;
            for (int i = 0; i < n6; ++i) {
                int n14;
                int n15 = WarpNearestOpImage.round(fArray[n13++]);
                int n16 = WarpNearestOpImage.round(fArray[n13++]);
                if (n15 < n2 || n15 >= n3 || n16 < n4 || n16 >= n5) {
                    if (this.setBackground) {
                        for (n14 = 0; n14 < n8; ++n14) {
                            sArray[n14][n12 + nArray[n14]] = sArray2[n14];
                        }
                    }
                } else {
                    for (n14 = 0; n14 < n8; ++n14) {
                        sArray[n14][n12 + nArray[n14]] = (short)randomIter.getSample(n15, n16, n14);
                    }
                }
                n12 += n10;
            }
        }
    }

    private void computeRectInt(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        int n;
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMaxX();
        int n4 = planarImage.getMinY();
        int n5 = planarImage.getMaxY();
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        float[] fArray = new float[2 * n6];
        int n11 = 0;
        int[] nArray3 = new int[n8];
        for (n = 0; n < n8; ++n) {
            nArray3[n] = (int)this.backgroundValues[n];
        }
        for (n = 0; n < n7; ++n) {
            int n12 = n11;
            n11 += n9;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n, n6, 1, fArray);
            int n13 = 0;
            for (int i = 0; i < n6; ++i) {
                int n14;
                int n15 = WarpNearestOpImage.round(fArray[n13++]);
                int n16 = WarpNearestOpImage.round(fArray[n13++]);
                if (n15 < n2 || n15 >= n3 || n16 < n4 || n16 >= n5) {
                    if (this.setBackground) {
                        for (n14 = 0; n14 < n8; ++n14) {
                            nArray2[n14][n12 + nArray[n14]] = nArray3[n14];
                        }
                    }
                } else {
                    for (n14 = 0; n14 < n8; ++n14) {
                        nArray2[n14][n12 + nArray[n14]] = randomIter.getSample(n15, n16, n14);
                    }
                }
                n12 += n10;
            }
        }
    }

    private void computeRectFloat(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        int n;
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMaxX();
        int n4 = planarImage.getMinY();
        int n5 = planarImage.getMaxY();
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        float[] fArray2 = new float[2 * n6];
        int n11 = 0;
        float[] fArray3 = new float[n8];
        for (n = 0; n < n8; ++n) {
            fArray3[n] = (float)this.backgroundValues[n];
        }
        for (n = 0; n < n7; ++n) {
            int n12 = n11;
            n11 += n9;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n, n6, 1, fArray2);
            int n13 = 0;
            for (int i = 0; i < n6; ++i) {
                int n14;
                int n15 = WarpNearestOpImage.round(fArray2[n13++]);
                int n16 = WarpNearestOpImage.round(fArray2[n13++]);
                if (n15 < n2 || n15 >= n3 || n16 < n4 || n16 >= n5) {
                    if (this.setBackground) {
                        for (n14 = 0; n14 < n8; ++n14) {
                            fArray[n14][n12 + nArray[n14]] = fArray3[n14];
                        }
                    }
                } else {
                    for (n14 = 0; n14 < n8; ++n14) {
                        fArray[n14][n12 + nArray[n14]] = randomIter.getSampleFloat(n15, n16, n14);
                    }
                }
                n12 += n10;
            }
        }
    }

    private void computeRectDouble(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX();
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY();
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        float[] fArray = new float[2 * n5];
        int n10 = 0;
        for (int i = 0; i < n6; ++i) {
            int n11 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + i, n5, 1, fArray);
            int n12 = 0;
            for (int j = 0; j < n5; ++j) {
                int n13;
                int n14 = WarpNearestOpImage.round(fArray[n12++]);
                int n15 = WarpNearestOpImage.round(fArray[n12++]);
                if (n14 < n || n14 >= n2 || n15 < n3 || n15 >= n4) {
                    if (this.setBackground) {
                        for (n13 = 0; n13 < n7; ++n13) {
                            dArray[n13][n11 + nArray[n13]] = this.backgroundValues[n13];
                        }
                    }
                } else {
                    for (n13 = 0; n13 < n7; ++n13) {
                        dArray[n13][n11 + nArray[n13]] = randomIter.getSampleDouble(n14, n15, n13);
                    }
                }
                n11 += n9;
            }
        }
    }

    private static final int round(float f) {
        return f >= 0.0f ? (int)(f + 0.5f) : (int)(f - 0.5f);
    }
}

