/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.DataBufferUtils;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.media.jai.JaiI18N;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;

public class LookupTableJAI
implements Serializable {
    transient DataBuffer data;
    private int[] tableOffsets;

    public LookupTableJAI(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.data = new DataBufferByte(byArray, byArray.length);
        this.initOffsets(1, 0);
    }

    public LookupTableJAI(byte[] byArray, int n) {
        if (byArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, n);
        this.data = new DataBufferByte(byArray, byArray.length);
    }

    public LookupTableJAI(byte[][] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(byArray.length, 0);
        this.data = new DataBufferByte(byArray, byArray[0].length);
    }

    public LookupTableJAI(byte[][] byArray, int n) {
        if (byArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(byArray.length, n);
        this.data = new DataBufferByte(byArray, byArray[0].length);
    }

    public LookupTableJAI(byte[][] byArray, int[] nArray) {
        if (byArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(byArray.length, nArray);
        this.data = new DataBufferByte(byArray, byArray[0].length);
    }

    public LookupTableJAI(short[] sArray, boolean bl) {
        if (sArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, 0);
        this.data = bl ? new DataBufferUShort(sArray, sArray.length) : new DataBufferShort(sArray, sArray.length);
    }

    public LookupTableJAI(short[] sArray, int n, boolean bl) {
        if (sArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, n);
        this.data = bl ? new DataBufferUShort(sArray, sArray.length) : new DataBufferShort(sArray, sArray.length);
    }

    public LookupTableJAI(short[][] sArray, boolean bl) {
        if (sArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(sArray.length, 0);
        this.data = bl ? new DataBufferUShort(sArray, sArray[0].length) : new DataBufferShort(sArray, sArray[0].length);
    }

    public LookupTableJAI(short[][] sArray, int n, boolean bl) {
        if (sArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(sArray.length, n);
        this.data = bl ? new DataBufferUShort(sArray, sArray[0].length) : new DataBufferShort(sArray, sArray[0].length);
    }

    public LookupTableJAI(short[][] sArray, int[] nArray, boolean bl) {
        if (sArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(sArray.length, nArray);
        this.data = bl ? new DataBufferUShort(sArray, sArray[0].length) : new DataBufferShort(sArray, sArray[0].length);
    }

    public LookupTableJAI(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, 0);
        this.data = new DataBufferInt(nArray, nArray.length);
    }

    public LookupTableJAI(int[] nArray, int n) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, n);
        this.data = new DataBufferInt(nArray, nArray.length);
    }

    public LookupTableJAI(int[][] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(nArray.length, 0);
        this.data = new DataBufferInt(nArray, nArray[0].length);
    }

    public LookupTableJAI(int[][] nArray, int n) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(nArray.length, n);
        this.data = new DataBufferInt(nArray, nArray[0].length);
    }

    public LookupTableJAI(int[][] nArray, int[] nArray2) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(nArray.length, nArray2);
        this.data = new DataBufferInt(nArray, nArray[0].length);
    }

    public LookupTableJAI(float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, 0);
        this.data = DataBufferUtils.createDataBufferFloat(fArray, fArray.length);
    }

    public LookupTableJAI(float[] fArray, int n) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, n);
        this.data = DataBufferUtils.createDataBufferFloat(fArray, fArray.length);
    }

    public LookupTableJAI(float[][] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(fArray.length, 0);
        this.data = DataBufferUtils.createDataBufferFloat(fArray, fArray[0].length);
    }

    public LookupTableJAI(float[][] fArray, int n) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(fArray.length, n);
        this.data = DataBufferUtils.createDataBufferFloat(fArray, fArray[0].length);
    }

    public LookupTableJAI(float[][] fArray, int[] nArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(fArray.length, nArray);
        this.data = DataBufferUtils.createDataBufferFloat(fArray, fArray[0].length);
    }

    public LookupTableJAI(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, 0);
        this.data = DataBufferUtils.createDataBufferDouble(dArray, dArray.length);
    }

    public LookupTableJAI(double[] dArray, int n) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, n);
        this.data = DataBufferUtils.createDataBufferDouble(dArray, dArray.length);
    }

    public LookupTableJAI(double[][] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(dArray.length, 0);
        this.data = DataBufferUtils.createDataBufferDouble(dArray, dArray[0].length);
    }

    public LookupTableJAI(double[][] dArray, int n) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(dArray.length, n);
        this.data = DataBufferUtils.createDataBufferDouble(dArray, dArray[0].length);
    }

    public LookupTableJAI(double[][] dArray, int[] nArray) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(dArray.length, nArray);
        this.data = DataBufferUtils.createDataBufferDouble(dArray, dArray[0].length);
    }

    public DataBuffer getData() {
        return this.data;
    }

    public byte[][] getByteData() {
        return this.data instanceof DataBufferByte ? ((DataBufferByte)this.data).getBankData() : (byte[][])null;
    }

    public byte[] getByteData(int n) {
        return this.data instanceof DataBufferByte ? ((DataBufferByte)this.data).getData(n) : null;
    }

    public short[][] getShortData() {
        if (this.data instanceof DataBufferUShort) {
            return ((DataBufferUShort)this.data).getBankData();
        }
        if (this.data instanceof DataBufferShort) {
            return ((DataBufferShort)this.data).getBankData();
        }
        return null;
    }

    public short[] getShortData(int n) {
        if (this.data instanceof DataBufferUShort) {
            return ((DataBufferUShort)this.data).getData(n);
        }
        if (this.data instanceof DataBufferShort) {
            return ((DataBufferShort)this.data).getData(n);
        }
        return null;
    }

    public int[][] getIntData() {
        return this.data instanceof DataBufferInt ? ((DataBufferInt)this.data).getBankData() : (int[][])null;
    }

    public int[] getIntData(int n) {
        return this.data instanceof DataBufferInt ? ((DataBufferInt)this.data).getData(n) : null;
    }

    public float[][] getFloatData() {
        return this.data.getDataType() == 4 ? DataBufferUtils.getBankDataFloat(this.data) : (float[][])null;
    }

    public float[] getFloatData(int n) {
        return this.data.getDataType() == 4 ? DataBufferUtils.getDataFloat(this.data, n) : null;
    }

    public double[][] getDoubleData() {
        return this.data.getDataType() == 5 ? DataBufferUtils.getBankDataDouble(this.data) : (double[][])null;
    }

    public double[] getDoubleData(int n) {
        return this.data.getDataType() == 5 ? DataBufferUtils.getDataDouble(this.data, n) : null;
    }

    public int[] getOffsets() {
        return this.tableOffsets;
    }

    public int getOffset() {
        return this.tableOffsets[0];
    }

    public int getOffset(int n) {
        return this.tableOffsets[n];
    }

    public int getNumBands() {
        return this.data.getNumBanks();
    }

    public int getNumEntries() {
        return this.data.getSize();
    }

    public int getDataType() {
        return this.data.getDataType();
    }

    public int getDestNumBands(int n) {
        int n2 = this.getNumBands();
        return n == 1 ? n2 : n;
    }

    public SampleModel getDestSampleModel(SampleModel sampleModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.getDestSampleModel(sampleModel, sampleModel.getWidth(), sampleModel.getHeight());
    }

    public SampleModel getDestSampleModel(SampleModel sampleModel, int n, int n2) {
        if (sampleModel == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!this.isIntegralDataType(sampleModel)) {
            return null;
        }
        return RasterFactory.createComponentSampleModel(sampleModel, this.getDataType(), n, n2, this.getDestNumBands(sampleModel.getNumBands()));
    }

    public boolean isIntegralDataType(SampleModel sampleModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.isIntegralDataType(sampleModel.getTransferType());
    }

    public boolean isIntegralDataType(int n) {
        return n == 0 || n == 1 || n == 2 || n == 3;
    }

    public int lookup(int n, int n2) {
        return this.data.getElem(n, n2 - this.tableOffsets[n]);
    }

    public float lookupFloat(int n, int n2) {
        return this.data.getElemFloat(n, n2 - this.tableOffsets[n]);
    }

    public double lookupDouble(int n, int n2) {
        return this.data.getElemDouble(n, n2 - this.tableOffsets[n]);
    }

    public WritableRaster lookup(WritableRaster writableRaster) {
        if (writableRaster == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.lookup(writableRaster, writableRaster, writableRaster.getBounds());
    }

    public WritableRaster lookup(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        int n;
        int n2;
        SampleModel sampleModel;
        if (raster == null) {
            throw new IllegalArgumentException(JaiI18N.getString("LookupTableJAI1"));
        }
        SampleModel sampleModel2 = raster.getSampleModel();
        if (!this.isIntegralDataType(sampleModel2)) {
            throw new IllegalArgumentException(JaiI18N.getString("LookupTableJAI2"));
        }
        rectangle = rectangle == null ? raster.getBounds() : rectangle.intersection(raster.getBounds());
        if (writableRaster != null) {
            rectangle = rectangle.intersection(writableRaster.getBounds());
        }
        if (writableRaster == null) {
            sampleModel = this.getDestSampleModel(sampleModel2, rectangle.width, rectangle.height);
            writableRaster = RasterFactory.createWritableRaster(sampleModel, new Point(rectangle.x, rectangle.y));
        } else {
            sampleModel = writableRaster.getSampleModel();
            if (sampleModel.getTransferType() != this.getDataType() || sampleModel.getNumBands() != this.getDestNumBands(sampleModel2.getNumBands())) {
                throw new IllegalArgumentException(JaiI18N.getString("LookupTableJAI3"));
            }
        }
        int n3 = RasterAccessor.findCompatibleTag(null, sampleModel2);
        int n4 = RasterAccessor.findCompatibleTag(null, sampleModel);
        RasterFormatTag rasterFormatTag = new RasterFormatTag(sampleModel2, n3);
        RasterFormatTag rasterFormatTag2 = new RasterFormatTag(sampleModel, n4);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle, rasterFormatTag, null);
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTag2, null);
        int n5 = rasterAccessor.getNumBands();
        int n6 = rasterAccessor.getDataType();
        int n7 = this.getNumBands();
        int n8 = this.getDataType();
        int n9 = rasterAccessor2.getWidth();
        int n10 = rasterAccessor2.getHeight();
        int n11 = rasterAccessor2.getNumBands();
        int n12 = rasterAccessor2.getDataType();
        int n13 = rasterAccessor.getScanlineStride();
        int n14 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        Object object = rasterAccessor.getByteDataArrays();
        Object object2 = rasterAccessor.getShortDataArrays();
        Object object3 = rasterAccessor.getIntDataArrays();
        if (n5 < n11) {
            int n15 = nArray[0];
            nArray = new int[n11];
            for (int i = 0; i < n11; ++i) {
                nArray[i] = n15;
            }
            switch (n6) {
                case 0: {
                    byte[] byArray = object[0];
                    object = new byte[n11][];
                    for (int i = 0; i < n11; ++i) {
                        object[i] = byArray;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    short[] sArray = object2[0];
                    object2 = new short[n11][];
                    for (int i = 0; i < n11; ++i) {
                        object2[i] = sArray;
                    }
                    break;
                }
                case 3: {
                    int[] nArray2 = object3[0];
                    object3 = new int[n11][];
                    for (int i = 0; i < n11; ++i) {
                        object3[i] = nArray2;
                    }
                    break;
                }
            }
        }
        int[] nArray3 = this.getOffsets();
        Object object4 = this.getByteData();
        Object object5 = this.getShortData();
        Object object6 = this.getIntData();
        Object object7 = this.getFloatData();
        Object object8 = this.getDoubleData();
        if (n7 < n11) {
            n2 = nArray3[0];
            nArray3 = new int[n11];
            for (n = 0; n < n11; ++n) {
                nArray3[n] = n2;
            }
            switch (n8) {
                case 0: {
                    byte[] byArray = object4[0];
                    object4 = new byte[n11][];
                    for (int i = 0; i < n11; ++i) {
                        object4[i] = byArray;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    short[] sArray = object5[0];
                    object5 = new short[n11][];
                    for (int i = 0; i < n11; ++i) {
                        object5[i] = sArray;
                    }
                    break;
                }
                case 3: {
                    int[] nArray4 = object6[0];
                    object6 = new int[n11][];
                    for (int i = 0; i < n11; ++i) {
                        object6[i] = nArray4;
                    }
                    break;
                }
                case 4: {
                    float[] fArray = object7[0];
                    object7 = new float[n11][];
                    for (int i = 0; i < n11; ++i) {
                        object7[i] = fArray;
                    }
                    break;
                }
                case 5: {
                    double[] dArray = object8[0];
                    object8 = new double[n11][];
                    for (int i = 0; i < n11; ++i) {
                        object8[i] = dArray;
                    }
                    break;
                }
            }
        }
        n2 = rasterAccessor2.getScanlineStride();
        n = rasterAccessor2.getPixelStride();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[][] nArray6 = rasterAccessor2.getIntDataArrays();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        block12 : switch (n12) {
            case 0: {
                switch (n6) {
                    case 0: {
                        this.lookup(n13, n14, nArray, (byte[][])object, n9, n10, n11, n2, n, nArray5, byArray, nArray3, (byte[][])object4);
                        break;
                    }
                    case 1: {
                        this.lookupU(n13, n14, nArray, (short[][])object2, n9, n10, n11, n2, n, nArray5, byArray, nArray3, (byte[][])object4);
                        break;
                    }
                    case 2: {
                        this.lookup(n13, n14, nArray, (short[][])object2, n9, n10, n11, n2, n, nArray5, byArray, nArray3, (byte[][])object4);
                        break;
                    }
                    case 3: {
                        this.lookup(n13, n14, nArray, (int[][])object3, n9, n10, n11, n2, n, nArray5, byArray, nArray3, (byte[][])object4);
                    }
                }
                break;
            }
            case 1: 
            case 2: {
                switch (n6) {
                    case 0: {
                        this.lookup(n13, n14, nArray, (byte[][])object, n9, n10, n11, n2, n, nArray5, sArray, nArray3, (short[][])object5);
                        break;
                    }
                    case 1: {
                        this.lookupU(n13, n14, nArray, (short[][])object2, n9, n10, n11, n2, n, nArray5, sArray, nArray3, (short[][])object5);
                        break;
                    }
                    case 2: {
                        this.lookup(n13, n14, nArray, (short[][])object2, n9, n10, n11, n2, n, nArray5, sArray, nArray3, (short[][])object5);
                        break;
                    }
                    case 3: {
                        this.lookup(n13, n14, nArray, (int[][])object3, n9, n10, n11, n2, n, nArray5, sArray, nArray3, (short[][])object5);
                    }
                }
                break;
            }
            case 3: {
                switch (n6) {
                    case 0: {
                        this.lookup(n13, n14, nArray, (byte[][])object, n9, n10, n11, n2, n, nArray5, nArray6, nArray3, (int[][])object6);
                        break;
                    }
                    case 1: {
                        this.lookupU(n13, n14, nArray, (short[][])object2, n9, n10, n11, n2, n, nArray5, nArray6, nArray3, (int[][])object6);
                        break;
                    }
                    case 2: {
                        this.lookup(n13, n14, nArray, (short[][])object2, n9, n10, n11, n2, n, nArray5, nArray6, nArray3, (int[][])object6);
                        break;
                    }
                    case 3: {
                        this.lookup(n13, n14, nArray, (int[][])object3, n9, n10, n11, n2, n, nArray5, nArray6, nArray3, (int[][])object6);
                    }
                }
                break;
            }
            case 4: {
                switch (n6) {
                    case 0: {
                        this.lookup(n13, n14, nArray, (byte[][])object, n9, n10, n11, n2, n, nArray5, fArray, nArray3, (float[][])object7);
                        break;
                    }
                    case 1: {
                        this.lookupU(n13, n14, nArray, (short[][])object2, n9, n10, n11, n2, n, nArray5, fArray, nArray3, (float[][])object7);
                        break;
                    }
                    case 2: {
                        this.lookup(n13, n14, nArray, (short[][])object2, n9, n10, n11, n2, n, nArray5, fArray, nArray3, (float[][])object7);
                        break;
                    }
                    case 3: {
                        this.lookup(n13, n14, nArray, (int[][])object3, n9, n10, n11, n2, n, nArray5, fArray, nArray3, (float[][])object7);
                    }
                }
                break;
            }
            case 5: {
                switch (n6) {
                    case 0: {
                        this.lookup(n13, n14, nArray, (byte[][])object, n9, n10, n11, n2, n, nArray5, dArray, nArray3, (double[][])object8);
                        break block12;
                    }
                    case 1: {
                        this.lookupU(n13, n14, nArray, (short[][])object2, n9, n10, n11, n2, n, nArray5, dArray, nArray3, (double[][])object8);
                        break block12;
                    }
                    case 2: {
                        this.lookup(n13, n14, nArray, (short[][])object2, n9, n10, n11, n2, n, nArray5, dArray, nArray3, (double[][])object8);
                        break block12;
                    }
                    case 3: {
                        this.lookup(n13, n14, nArray, (int[][])object3, n9, n10, n11, n2, n, nArray5, dArray, nArray3, (double[][])object8);
                    }
                }
            }
        }
        rasterAccessor2.copyDataToRaster();
        return writableRaster;
    }

    private void lookup(int n, int n2, int[] nArray, byte[][] byArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, byte[][] byArray2, int[] nArray3, byte[][] byArray3) {
        for (int i = 0; i < n5; ++i) {
            byte[] byArray4 = byArray[i];
            byte[] byArray5 = byArray2[i];
            byte[] byArray6 = byArray3[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            int n10 = nArray3[i];
            for (int j = 0; j < n4; ++j) {
                int n11 = n8;
                int n12 = n9;
                n8 += n;
                n9 += n6;
                for (int k = 0; k < n3; ++k) {
                    byArray5[n12] = byArray6[(byArray4[n11] & 0xFF) - n10];
                    n11 += n2;
                    n12 += n7;
                }
            }
        }
    }

    private void lookupU(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, byte[][] byArray, int[] nArray3, byte[][] byArray2) {
        for (int i = 0; i < n5; ++i) {
            short[] sArray2 = sArray[i];
            byte[] byArray3 = byArray[i];
            byte[] byArray4 = byArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            int n10 = nArray3[i];
            for (int j = 0; j < n4; ++j) {
                int n11 = n8;
                int n12 = n9;
                n8 += n;
                n9 += n6;
                for (int k = 0; k < n3; ++k) {
                    byArray3[n12] = byArray4[(sArray2[n11] & 0xFFFF) - n10];
                    n11 += n2;
                    n12 += n7;
                }
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, byte[][] byArray, int[] nArray3, byte[][] byArray2) {
        for (int i = 0; i < n5; ++i) {
            short[] sArray2 = sArray[i];
            byte[] byArray3 = byArray[i];
            byte[] byArray4 = byArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            int n10 = nArray3[i];
            for (int j = 0; j < n4; ++j) {
                int n11 = n8;
                int n12 = n9;
                n8 += n;
                n9 += n6;
                for (int k = 0; k < n3; ++k) {
                    byArray3[n12] = byArray4[sArray2[n11] - n10];
                    n11 += n2;
                    n12 += n7;
                }
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, int[][] nArray2, int n3, int n4, int n5, int n6, int n7, int[] nArray3, byte[][] byArray, int[] nArray4, byte[][] byArray2) {
        for (int i = 0; i < n5; ++i) {
            int[] nArray5 = nArray2[i];
            byte[] byArray3 = byArray[i];
            byte[] byArray4 = byArray2[i];
            int n8 = nArray[i];
            int n9 = nArray3[i];
            int n10 = nArray4[i];
            for (int j = 0; j < n4; ++j) {
                int n11 = n8;
                int n12 = n9;
                n8 += n;
                n9 += n6;
                for (int k = 0; k < n3; ++k) {
                    byArray3[n12] = byArray4[nArray5[n11] - n10];
                    n11 += n2;
                    n12 += n7;
                }
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, byte[][] byArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, short[][] sArray, int[] nArray3, short[][] sArray2) {
        for (int i = 0; i < n5; ++i) {
            byte[] byArray2 = byArray[i];
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            int n10 = nArray3[i];
            for (int j = 0; j < n4; ++j) {
                int n11 = n8;
                int n12 = n9;
                n8 += n;
                n9 += n6;
                for (int k = 0; k < n3; ++k) {
                    sArray3[n12] = sArray4[(byArray2[n11] & 0xFF) - n10];
                    n11 += n2;
                    n12 += n7;
                }
            }
        }
    }

    private void lookupU(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, short[][] sArray2, int[] nArray3, short[][] sArray3) {
        for (int i = 0; i < n5; ++i) {
            short[] sArray4 = sArray[i];
            short[] sArray5 = sArray2[i];
            short[] sArray6 = sArray3[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            int n10 = nArray3[i];
            for (int j = 0; j < n4; ++j) {
                int n11 = n8;
                int n12 = n9;
                n8 += n;
                n9 += n6;
                for (int k = 0; k < n3; ++k) {
                    sArray5[n12] = sArray6[(sArray4[n11] & 0xFFFF) - n10];
                    n11 += n2;
                    n12 += n7;
                }
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, short[][] sArray2, int[] nArray3, short[][] sArray3) {
        for (int i = 0; i < n5; ++i) {
            short[] sArray4 = sArray[i];
            short[] sArray5 = sArray2[i];
            short[] sArray6 = sArray3[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            int n10 = nArray3[i];
            for (int j = 0; j < n4; ++j) {
                int n11 = n8;
                int n12 = n9;
                n8 += n;
                n9 += n6;
                for (int k = 0; k < n3; ++k) {
                    sArray5[n12] = sArray6[sArray4[n11] - n10];
                    n11 += n2;
                    n12 += n7;
                }
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, int[][] nArray2, int n3, int n4, int n5, int n6, int n7, int[] nArray3, short[][] sArray, int[] nArray4, short[][] sArray2) {
        for (int i = 0; i < n5; ++i) {
            int[] nArray5 = nArray2[i];
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n8 = nArray[i];
            int n9 = nArray3[i];
            int n10 = nArray4[i];
            for (int j = 0; j < n4; ++j) {
                int n11 = n8;
                int n12 = n9;
                n8 += n;
                n9 += n6;
                for (int k = 0; k < n3; ++k) {
                    sArray3[n12] = sArray4[nArray5[n11] - n10];
                    n11 += n2;
                    n12 += n7;
                }
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, byte[][] byArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, int[][] nArray3, int[] nArray4, int[][] nArray5) {
        if (nArray5 == null) {
            for (int i = 0; i < n5; ++i) {
                byte[] byArray2 = byArray[i];
                int[] nArray6 = nArray3[i];
                int n8 = nArray[i];
                int n9 = nArray2[i];
                for (int j = 0; j < n4; ++j) {
                    int n10 = n8;
                    int n11 = n9;
                    n8 += n;
                    n9 += n6;
                    for (int k = 0; k < n3; ++k) {
                        nArray6[n11] = this.data.getElem(i, byArray2[n10] & 0xFF);
                        n10 += n2;
                        n11 += n7;
                    }
                }
            }
        } else {
            for (int i = 0; i < n5; ++i) {
                byte[] byArray3 = byArray[i];
                int[] nArray7 = nArray3[i];
                int[] nArray8 = nArray5[i];
                int n12 = nArray[i];
                int n13 = nArray2[i];
                int n14 = nArray4[i];
                for (int j = 0; j < n4; ++j) {
                    int n15 = n12;
                    int n16 = n13;
                    n12 += n;
                    n13 += n6;
                    for (int k = 0; k < n3; ++k) {
                        nArray7[n16] = nArray8[(byArray3[n15] & 0xFF) - n14];
                        n15 += n2;
                        n16 += n7;
                    }
                }
            }
        }
    }

    private void lookupU(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, int[][] nArray3, int[] nArray4, int[][] nArray5) {
        if (nArray5 == null) {
            for (int i = 0; i < n5; ++i) {
                short[] sArray2 = sArray[i];
                int[] nArray6 = nArray3[i];
                int n8 = nArray[i];
                int n9 = nArray2[i];
                for (int j = 0; j < n4; ++j) {
                    int n10 = n8;
                    int n11 = n9;
                    n8 += n;
                    n9 += n6;
                    for (int k = 0; k < n3; ++k) {
                        nArray6[n11] = this.data.getElem(i, sArray2[n10] & 0xFFFF);
                        n10 += n2;
                        n11 += n7;
                    }
                }
            }
        } else {
            for (int i = 0; i < n5; ++i) {
                short[] sArray3 = sArray[i];
                int[] nArray7 = nArray3[i];
                int[] nArray8 = nArray5[i];
                int n12 = nArray[i];
                int n13 = nArray2[i];
                int n14 = nArray4[i];
                for (int j = 0; j < n4; ++j) {
                    int n15 = n12;
                    int n16 = n13;
                    n12 += n;
                    n13 += n6;
                    for (int k = 0; k < n3; ++k) {
                        nArray7[n16] = nArray8[(sArray3[n15] & 0xFFFF) - n14];
                        n15 += n2;
                        n16 += n7;
                    }
                }
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, int[][] nArray3, int[] nArray4, int[][] nArray5) {
        if (nArray5 == null) {
            for (int i = 0; i < n5; ++i) {
                short[] sArray2 = sArray[i];
                int[] nArray6 = nArray3[i];
                int n8 = nArray[i];
                int n9 = nArray2[i];
                for (int j = 0; j < n4; ++j) {
                    int n10 = n8;
                    int n11 = n9;
                    n8 += n;
                    n9 += n6;
                    for (int k = 0; k < n3; ++k) {
                        nArray6[n11] = this.data.getElem(i, sArray2[n10]);
                        n10 += n2;
                        n11 += n7;
                    }
                }
            }
        } else {
            for (int i = 0; i < n5; ++i) {
                short[] sArray3 = sArray[i];
                int[] nArray7 = nArray3[i];
                int[] nArray8 = nArray5[i];
                int n12 = nArray[i];
                int n13 = nArray2[i];
                int n14 = nArray4[i];
                for (int j = 0; j < n4; ++j) {
                    int n15 = n12;
                    int n16 = n13;
                    n12 += n;
                    n13 += n6;
                    for (int k = 0; k < n3; ++k) {
                        nArray7[n16] = nArray8[sArray3[n15] - n14];
                        n15 += n2;
                        n16 += n7;
                    }
                }
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, int[][] nArray2, int n3, int n4, int n5, int n6, int n7, int[] nArray3, int[][] nArray4, int[] nArray5, int[][] nArray6) {
        if (nArray6 == null) {
            for (int i = 0; i < n5; ++i) {
                int[] nArray7 = nArray2[i];
                int[] nArray8 = nArray4[i];
                int n8 = nArray[i];
                int n9 = nArray3[i];
                for (int j = 0; j < n4; ++j) {
                    int n10 = n8;
                    int n11 = n9;
                    n8 += n;
                    n9 += n6;
                    for (int k = 0; k < n3; ++k) {
                        nArray8[n11] = this.data.getElem(i, nArray7[n10]);
                        n10 += n2;
                        n11 += n7;
                    }
                }
            }
        } else {
            for (int i = 0; i < n5; ++i) {
                int[] nArray9 = nArray2[i];
                int[] nArray10 = nArray4[i];
                int[] nArray11 = nArray6[i];
                int n12 = nArray[i];
                int n13 = nArray3[i];
                int n14 = nArray5[i];
                for (int j = 0; j < n4; ++j) {
                    int n15 = n12;
                    int n16 = n13;
                    n12 += n;
                    n13 += n6;
                    for (int k = 0; k < n3; ++k) {
                        nArray10[n16] = nArray11[nArray9[n15] - n14];
                        n15 += n2;
                        n16 += n7;
                    }
                }
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, byte[][] byArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, float[][] fArray, int[] nArray3, float[][] fArray2) {
        for (int i = 0; i < n5; ++i) {
            byte[] byArray2 = byArray[i];
            float[] fArray3 = fArray[i];
            float[] fArray4 = fArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            int n10 = nArray3[i];
            for (int j = 0; j < n4; ++j) {
                int n11 = n8;
                int n12 = n9;
                n8 += n;
                n9 += n6;
                for (int k = 0; k < n3; ++k) {
                    fArray3[n12] = fArray4[(byArray2[n11] & 0xFF) - n10];
                    n11 += n2;
                    n12 += n7;
                }
            }
        }
    }

    private void lookupU(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, float[][] fArray, int[] nArray3, float[][] fArray2) {
        for (int i = 0; i < n5; ++i) {
            short[] sArray2 = sArray[i];
            float[] fArray3 = fArray[i];
            float[] fArray4 = fArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            int n10 = nArray3[i];
            for (int j = 0; j < n4; ++j) {
                int n11 = n8;
                int n12 = n9;
                n8 += n;
                n9 += n6;
                for (int k = 0; k < n3; ++k) {
                    fArray3[n12] = fArray4[(sArray2[n11] & 0xFFFF) - n10];
                    n11 += n2;
                    n12 += n7;
                }
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, float[][] fArray, int[] nArray3, float[][] fArray2) {
        for (int i = 0; i < n5; ++i) {
            short[] sArray2 = sArray[i];
            float[] fArray3 = fArray[i];
            float[] fArray4 = fArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            int n10 = nArray3[i];
            for (int j = 0; j < n4; ++j) {
                int n11 = n8;
                int n12 = n9;
                n8 += n;
                n9 += n6;
                for (int k = 0; k < n3; ++k) {
                    fArray3[n12] = fArray4[sArray2[n11] - n10];
                    n11 += n2;
                    n12 += n7;
                }
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, int[][] nArray2, int n3, int n4, int n5, int n6, int n7, int[] nArray3, float[][] fArray, int[] nArray4, float[][] fArray2) {
        for (int i = 0; i < n5; ++i) {
            int[] nArray5 = nArray2[i];
            float[] fArray3 = fArray[i];
            float[] fArray4 = fArray2[i];
            int n8 = nArray[i];
            int n9 = nArray3[i];
            int n10 = nArray4[i];
            for (int j = 0; j < n4; ++j) {
                int n11 = n8;
                int n12 = n9;
                n8 += n;
                n9 += n6;
                for (int k = 0; k < n3; ++k) {
                    fArray3[n12] = fArray4[nArray5[n11] - n10];
                    n11 += n2;
                    n12 += n7;
                }
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, byte[][] byArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, double[][] dArray, int[] nArray3, double[][] dArray2) {
        for (int i = 0; i < n5; ++i) {
            byte[] byArray2 = byArray[i];
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            int n10 = nArray3[i];
            for (int j = 0; j < n4; ++j) {
                int n11 = n8;
                int n12 = n9;
                n8 += n;
                n9 += n6;
                for (int k = 0; k < n3; ++k) {
                    dArray3[n12] = dArray4[(byArray2[n11] & 0xFF) - n10];
                    n11 += n2;
                    n12 += n7;
                }
            }
        }
    }

    private void lookupU(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, double[][] dArray, int[] nArray3, double[][] dArray2) {
        for (int i = 0; i < n5; ++i) {
            short[] sArray2 = sArray[i];
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            int n10 = nArray3[i];
            for (int j = 0; j < n4; ++j) {
                int n11 = n8;
                int n12 = n9;
                n8 += n;
                n9 += n6;
                for (int k = 0; k < n3; ++k) {
                    dArray3[n12] = dArray4[(sArray2[n11] & 0xFFFF) - n10];
                    n11 += n2;
                    n12 += n7;
                }
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, double[][] dArray, int[] nArray3, double[][] dArray2) {
        for (int i = 0; i < n5; ++i) {
            short[] sArray2 = sArray[i];
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            int n10 = nArray3[i];
            for (int j = 0; j < n4; ++j) {
                int n11 = n8;
                int n12 = n9;
                n8 += n;
                n9 += n6;
                for (int k = 0; k < n3; ++k) {
                    dArray3[n12] = dArray4[sArray2[n11] - n10];
                    n11 += n2;
                    n12 += n7;
                }
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, int[][] nArray2, int n3, int n4, int n5, int n6, int n7, int[] nArray3, double[][] dArray, int[] nArray4, double[][] dArray2) {
        for (int i = 0; i < n5; ++i) {
            int[] nArray5 = nArray2[i];
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            int n8 = nArray[i];
            int n9 = nArray3[i];
            int n10 = nArray4[i];
            for (int j = 0; j < n4; ++j) {
                int n11 = n8;
                int n12 = n9;
                n8 += n;
                n9 += n6;
                for (int k = 0; k < n3; ++k) {
                    dArray3[n12] = dArray4[nArray5[n11] - n10];
                    n11 += n2;
                    n12 += n7;
                }
            }
        }
    }

    public int findNearestEntry(float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n = this.data.getDataType();
        int n2 = this.getNumBands();
        int n3 = this.getNumEntries();
        int n4 = -1;
        if (n == 0) {
            float f;
            int n5;
            byte[][] byArray = this.getByteData();
            float f2 = 0.0f;
            n4 = 0;
            for (n5 = 0; n5 < n2; ++n5) {
                f = fArray[n5] - (float)(byArray[n5][0] & 0xFF);
                f2 += f * f;
            }
            for (n5 = 1; n5 < n3; ++n5) {
                f = 0.0f;
                for (int i = 0; i < n2; ++i) {
                    float f3 = fArray[i] - (float)(byArray[i][n5] & 0xFF);
                    f += f3 * f3;
                }
                if (!(f < f2)) continue;
                f2 = f;
                n4 = n5;
            }
        } else if (n == 2) {
            float f;
            int n6;
            short[][] sArray = this.getShortData();
            float f4 = 0.0f;
            n4 = 0;
            for (n6 = 0; n6 < n2; ++n6) {
                f = fArray[n6] - (float)sArray[n6][0];
                f4 += f * f;
            }
            for (n6 = 1; n6 < n3; ++n6) {
                f = 0.0f;
                for (int i = 0; i < n2; ++i) {
                    float f5 = fArray[i] - (float)sArray[i][n6];
                    f += f5 * f5;
                }
                if (!(f < f4)) continue;
                f4 = f;
                n4 = n6;
            }
        } else if (n == 1) {
            float f;
            int n7;
            short[][] sArray = this.getShortData();
            float f6 = 0.0f;
            n4 = 0;
            for (n7 = 0; n7 < n2; ++n7) {
                f = fArray[n7] - (float)(sArray[n7][0] & 0xFFFF);
                f6 += f * f;
            }
            for (n7 = 1; n7 < n3; ++n7) {
                f = 0.0f;
                for (int i = 0; i < n2; ++i) {
                    float f7 = fArray[i] - (float)(sArray[i][n7] & 0xFFFF);
                    f += f7 * f7;
                }
                if (!(f < f6)) continue;
                f6 = f;
                n4 = n7;
            }
        } else if (n == 3) {
            float f;
            int n8;
            int[][] nArray = this.getIntData();
            float f8 = 0.0f;
            n4 = 0;
            for (n8 = 0; n8 < n2; ++n8) {
                f = fArray[n8] - (float)nArray[n8][0];
                f8 += f * f;
            }
            for (n8 = 1; n8 < n3; ++n8) {
                f = 0.0f;
                for (int i = 0; i < n2; ++i) {
                    float f9 = fArray[i] - (float)nArray[i][n8];
                    f += f9 * f9;
                }
                if (!(f < f8)) continue;
                f8 = f;
                n4 = n8;
            }
        } else if (n == 4) {
            float f;
            int n9;
            float[][] fArray2 = this.getFloatData();
            float f10 = 0.0f;
            n4 = 0;
            for (n9 = 0; n9 < n2; ++n9) {
                f = fArray[n9] - fArray2[n9][0];
                f10 += f * f;
            }
            for (n9 = 1; n9 < n3; ++n9) {
                f = 0.0f;
                for (int i = 0; i < n2; ++i) {
                    float f11 = fArray[i] - fArray2[i][n9];
                    f += f11 * f11;
                }
                if (!(f < f10)) continue;
                f10 = f;
                n4 = n9;
            }
        } else if (n == 5) {
            double d;
            int n10;
            double[][] dArray = this.getDoubleData();
            double d2 = 0.0;
            n4 = 0;
            for (n10 = 0; n10 < n2; ++n10) {
                d = (double)fArray[n10] - dArray[n10][0];
                d2 += d * d;
            }
            for (n10 = 1; n10 < n3; ++n10) {
                d = 0.0;
                for (int i = 0; i < n2; ++i) {
                    double d3 = (double)fArray[i] - dArray[i][n10];
                    d += d3 * d3;
                }
                if (!(d < d2)) continue;
                d2 = d;
                n4 = n10;
            }
        } else {
            throw new RuntimeException(JaiI18N.getString("LookupTableJAI0"));
        }
        return n4 == -1 ? n4 : n4 + this.getOffset();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(SerializerFactory.getState(this.data));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        SerializableState serializableState = (SerializableState)object;
        this.data = (DataBuffer)serializableState.getObject();
    }

    private void initOffsets(int n, int n2) {
        this.tableOffsets = new int[n];
        for (int i = 0; i < n; ++i) {
            this.tableOffsets[i] = n2;
        }
    }

    private void initOffsets(int n, int[] nArray) {
        this.tableOffsets = new int[n];
        for (int i = 0; i < n; ++i) {
            this.tableOffsets[i] = nArray[i];
        }
    }
}

