/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.startlevel.StartLevel;
import org.weasis.launcher.Messages;
import org.weasis.launcher.WeasisLauncher;
import org.weasis.launcher.WebStartLoader;

public class AutoProcessor {
    public static final String AUTO_DEPLOY_DIR_PROPERY = "felix.auto.deploy.dir";
    public static final String AUTO_DEPLOY_DIR_VALUE = "bundle";
    public static final String AUTO_DEPLOY_ACTION_PROPERY = "felix.auto.deploy.action";
    public static final String AUTO_DEPLOY_STARTLEVEL_PROPERY = "felix.auto.deploy.startlevel";
    public static final String AUTO_DEPLOY_INSTALL_VALUE = "install";
    public static final String AUTO_DEPLOY_START_VALUE = "start";
    public static final String AUTO_DEPLOY_UPDATE_VALUE = "update";
    public static final String AUTO_DEPLOY_UNINSTALL_VALUE = "uninstall";
    public static final String AUTO_INSTALL_PROP = "felix.auto.install";
    public static final String AUTO_START_PROP = "felix.auto.start";

    public static void process(Map configMap, BundleContext context, WebStartLoader webStartLoader) {
        configMap = configMap == null ? new HashMap() : configMap;
        AutoProcessor.processAutoDeploy(configMap, context, webStartLoader);
        AutoProcessor.processAutoProperties(configMap, context, webStartLoader);
    }

    private static void processAutoDeploy(Map configMap, BundleContext context, WebStartLoader webStartLoader) {
        String action = (String)configMap.get(AUTO_DEPLOY_ACTION_PROPERY);
        action = action == null ? "" : action;
        ArrayList<String> actionList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(action, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim().toLowerCase();
            if (!s.equals(AUTO_DEPLOY_INSTALL_VALUE) && !s.equals(AUTO_DEPLOY_START_VALUE) && !s.equals(AUTO_DEPLOY_UPDATE_VALUE) && !s.equals(AUTO_DEPLOY_UNINSTALL_VALUE)) continue;
            actionList.add(s);
        }
        if (actionList.size() > 0) {
            Bundle b;
            int i;
            StartLevel sl = (StartLevel)context.getService(context.getServiceReference(StartLevel.class.getName()));
            int startLevel = sl.getInitialBundleStartLevel();
            if (configMap.get(AUTO_DEPLOY_STARTLEVEL_PROPERY) != null) {
                try {
                    startLevel = Integer.parseInt(configMap.get(AUTO_DEPLOY_STARTLEVEL_PROPERY).toString());
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            HashMap<String, Bundle> installedBundleMap = new HashMap<String, Bundle>();
            Bundle[] bundles = context.getBundles();
            for (int i2 = 0; i2 < bundles.length; ++i2) {
                installedBundleMap.put(bundles[i2].getLocation(), bundles[i2]);
            }
            String autoDir = (String)configMap.get(AUTO_DEPLOY_DIR_PROPERY);
            autoDir = autoDir == null ? AUTO_DEPLOY_DIR_VALUE : autoDir;
            Object[] files = new File(autoDir).listFiles();
            ArrayList<Object> jarList = new ArrayList<Object>();
            if (files != null) {
                Arrays.sort(files);
                for (int i3 = 0; i3 < files.length; ++i3) {
                    if (!((File)files[i3]).getName().endsWith(".jar")) continue;
                    jarList.add(files[i3]);
                }
            }
            webStartLoader.setMax(jarList.size());
            ArrayList<Bundle> startBundleList = new ArrayList<Bundle>();
            for (i = 0; i < jarList.size(); ++i) {
                File jar = (File)jarList.get(i);
                b = (Bundle)installedBundleMap.remove(jar.toURI().toString());
                try {
                    webStartLoader.writeLabel(WebStartLoader.LBL_DOWNLOADING + " " + jar.getName());
                    if (b == null && actionList.contains(AUTO_DEPLOY_INSTALL_VALUE)) {
                        b = context.installBundle(((File)jarList.get(i)).toURI().toString());
                    } else if (b != null && actionList.contains(AUTO_DEPLOY_UPDATE_VALUE)) {
                        b.update();
                    }
                    if (b == null) continue;
                    webStartLoader.setValue(i + 1);
                    if (AutoProcessor.isFragment(b)) continue;
                    startBundleList.add(b);
                    sl.setBundleStartLevel(b, startLevel);
                    continue;
                }
                catch (BundleException ex) {
                    System.err.println("Auto-deploy install: " + (Object)((Object)ex) + (ex.getCause() != null ? " - " + ex.getCause() : ""));
                }
            }
            if (actionList.contains(AUTO_DEPLOY_UNINSTALL_VALUE)) {
                for (Map.Entry entry : installedBundleMap.entrySet()) {
                    b = (Bundle)entry.getValue();
                    if (b.getBundleId() == 0L) continue;
                    try {
                        b.uninstall();
                    }
                    catch (BundleException ex) {
                        System.err.println("Auto-deploy uninstall: " + (Object)((Object)ex) + (ex.getCause() != null ? " - " + ex.getCause() : ""));
                    }
                }
            }
            if (actionList.contains(AUTO_DEPLOY_START_VALUE)) {
                for (i = 0; i < startBundleList.size(); ++i) {
                    try {
                        ((Bundle)startBundleList.get(i)).start();
                        continue;
                    }
                    catch (BundleException ex) {
                        System.err.println("Auto-deploy start: " + (Object)((Object)ex) + (ex.getCause() != null ? " - " + ex.getCause() : ""));
                    }
                }
            }
        }
    }

    private static void processAutoProperties(Map configMap, BundleContext context, WebStartLoader webStartLoader) {
        String key;
        StartLevel sl = (StartLevel)context.getService(context.getServiceReference(StartLevel.class.getName()));
        int nbBundles = 0;
        Set set = configMap.keySet();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            String key2 = ((String)i.next()).toLowerCase();
            if (!key2.startsWith(AUTO_INSTALL_PROP) && !key2.startsWith(AUTO_START_PROP)) continue;
            StringTokenizer st = new StringTokenizer((String)configMap.get(key2), "\" ", true);
            String location = AutoProcessor.nextLocation(st);
            while (location != null) {
                ++nbBundles;
                location = AutoProcessor.nextLocation(st);
            }
        }
        webStartLoader.setMax(nbBundles);
        int bundleIter = 0;
        Iterator i2 = set.iterator();
        while (i2.hasNext()) {
            key = ((String)i2.next()).toLowerCase();
            if (!key.startsWith(AUTO_INSTALL_PROP) && !key.startsWith(AUTO_START_PROP)) continue;
            int startLevel = sl.getInitialBundleStartLevel();
            if (!key.equals(AUTO_INSTALL_PROP) && !key.equals(AUTO_START_PROP)) {
                try {
                    startLevel = Integer.parseInt(key.substring(key.lastIndexOf(46) + 1));
                }
                catch (NumberFormatException ex) {
                    System.err.println("Invalid property: " + key);
                }
            }
            StringTokenizer st = new StringTokenizer((String)configMap.get(key), "\" ", true);
            String location = AutoProcessor.nextLocation(st);
            while (location != null) {
                block18: {
                    String bundleName = location.substring(location.lastIndexOf("/") + 1, location.length());
                    try {
                        webStartLoader.writeLabel(WebStartLoader.LBL_DOWNLOADING + " " + bundleName);
                        Bundle b = context.installBundle(location, null);
                        webStartLoader.setValue(++bundleIter);
                        sl.setBundleStartLevel(b, startLevel);
                        if (WeasisLauncher.modulesi18n != null) {
                            StringBuffer p = new StringBuffer(b.getSymbolicName());
                            p.append("-i18n-");
                            p.append("1.1.0");
                            p.append(".jar");
                            String prop = p.toString();
                            String value = WeasisLauncher.modulesi18n.getProperty(prop);
                            if (value != null) {
                                String translation_modules = System.getProperty("weasis.i18n", "");
                                translation_modules = translation_modules + (translation_modules.endsWith("/") ? prop : "/" + prop);
                                Bundle b2 = context.installBundle(translation_modules, null);
                                sl.setBundleStartLevel(b2, startLevel);
                                if (!value.equals(b2.getVersion().getQualifier())) {
                                    b2.update();
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        String arch = System.getProperty("native.library.spec");
                        if (bundleName.contains(arch)) {
                            System.err.println("Cannot install native plug-in: " + bundleName);
                        }
                        System.err.println("Auto-properties install: " + location + " (" + ex + (ex.getCause() != null ? " - " + ex.getCause() : "") + ")");
                        if (ex.getCause() == null) break block18;
                        ex.printStackTrace();
                    }
                }
                location = AutoProcessor.nextLocation(st);
            }
        }
        webStartLoader.writeLabel(Messages.getString("AutoProcessor.start"));
        i2 = configMap.keySet().iterator();
        while (i2.hasNext()) {
            key = ((String)i2.next()).toLowerCase();
            if (!key.startsWith(AUTO_START_PROP)) continue;
            StringTokenizer st = new StringTokenizer((String)configMap.get(key), "\" ", true);
            String location = AutoProcessor.nextLocation(st);
            while (location != null) {
                try {
                    Bundle b = context.installBundle(location, null);
                    if (b != null) {
                        b.start();
                    }
                }
                catch (Exception ex) {
                    System.err.println("Auto-properties start: " + location + " (" + ex + (ex.getCause() != null ? " - " + ex.getCause() : "") + ")");
                }
                location = AutoProcessor.nextLocation(st);
            }
        }
    }

    private static String nextLocation(StringTokenizer st) {
        String retVal = null;
        if (st.countTokens() > 0) {
            String tokenList = "\" ";
            StringBuffer tokBuf = new StringBuffer(10);
            String tok = null;
            boolean inQuote = false;
            boolean tokStarted = false;
            boolean exit = false;
            while (st.hasMoreTokens() && !exit) {
                tok = st.nextToken(tokenList);
                if (tok.equals("\"")) {
                    boolean bl = inQuote = !inQuote;
                    if (inQuote) {
                        tokenList = "\"";
                        continue;
                    }
                    tokenList = "\" ";
                    continue;
                }
                if (tok.equals(" ")) {
                    if (!tokStarted) continue;
                    retVal = tokBuf.toString();
                    tokStarted = false;
                    tokBuf = new StringBuffer(10);
                    exit = true;
                    continue;
                }
                tokStarted = true;
                tokBuf.append(tok.trim());
            }
            if (!exit && tokStarted) {
                retVal = tokBuf.toString();
            }
        }
        return retVal;
    }

    private static boolean isFragment(Bundle bundle) {
        return bundle.getHeaders().get("Fragment-Host") != null;
    }
}

