/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.launcher;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.util.Util;
import org.osgi.framework.Bundle;
import org.osgi.util.tracker.ServiceTracker;
import org.weasis.launcher.FileUtil;
import org.weasis.launcher.HostActivator;
import org.weasis.launcher.LookAndFeels;
import org.weasis.launcher.Messages;
import org.weasis.launcher.WebStartLoader;

public class WeasisLauncher {
    public static final String BUNDLE_DIR_SWITCH = "-b";
    public static final String SHUTDOWN_HOOK_PROP = "felix.shutdown.hook";
    public static final String SYSTEM_PROPERTIES_PROP = "felix.system.properties";
    public static final String SYSTEM_PROPERTIES_FILE_VALUE = "system.properties";
    public static final String CONFIG_PROPERTIES_PROP = "felix.config.properties";
    public static final String CONFIG_PROPERTIES_FILE_VALUE = "config.properties";
    public static final String CONFIG_DIRECTORY = "conf";
    private static HostActivator m_activator = null;
    private static Felix m_felix = null;
    protected static ServiceTracker m_tracker = null;
    private static String APP_PROPERTY_FILE = "weasis.properties";
    public static final String P_WEASIS_VERSION = "weasis.version";
    public static final String P_WEASIS_PATH = "weasis.path";
    static Properties modulesi18n = null;
    private static String look = null;

    public static void main(String[] argv) throws Exception {
        WeasisLauncher.launch(argv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void launch(String[] argv) throws Exception {
        Properties configProps;
        WeasisLauncher.setSystemSpecification();
        final List<StringBuffer> commandList = WeasisLauncher.splitCommand(argv);
        String bundleDir = null;
        String cacheDir = null;
        for (StringBuffer c : commandList) {
            String command = c.toString();
            if (!command.startsWith("felix")) continue;
            String[] params = command.split(" ");
            if (params.length < 3 || params.length > 4) {
                System.err.println("Usage: [$felix -b <bundle-deploy-dir>] [<bundle-cache-dir>]");
            } else {
                bundleDir = params[2];
                if (params.length > 3) {
                    cacheDir = params[3];
                }
            }
            commandList.remove(c);
            break;
        }
        WeasisLauncher.loadSystemProperties();
        String portable = System.getProperty("weasis.portable.dir");
        if (portable != null) {
            File basePortableDir = new File(portable);
            String baseURL = "";
            try {
                baseURL = basePortableDir.toURI().toURL().toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.setProperty("weasis.codebase.url", baseURL + "weasis");
            System.setProperty(CONFIG_PROPERTIES_PROP, baseURL + "weasis/conf/config.properties");
        }
        if ((configProps = WeasisLauncher.loadConfigProperties()) == null) {
            System.err.println("No config.properties found.");
            configProps = new Properties();
        }
        WeasisLauncher.copySystemProperties(configProps);
        if (bundleDir != null) {
            configProps.setProperty("felix.auto.deploy.dir", bundleDir);
        }
        if (cacheDir != null) {
            configProps.setProperty("org.osgi.framework.storage", cacheDir);
        }
        WebStartLoader loader = WeasisLauncher.loadProperties(configProps);
        Runtime.getRuntime().addShutdownHook(new Thread("Felix Shutdown Hook"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int exitStatus = 0;
                try {
                    if (m_felix != null) {
                        m_felix.stop();
                        m_felix.waitForStop(25000L);
                    }
                }
                catch (Exception ex) {
                    exitStatus = -1;
                    System.err.println("Error stopping framework: " + ex);
                }
                finally {
                    FileUtil.deleteDirectoryContents(FileUtil.getApplicationTempDir());
                    Runtime.getRuntime().halt(exitStatus);
                }
            }
        });
        System.out.println("\nWeasis Starting...");
        System.out.println("========================\n");
        int exitStatus = 0;
        m_activator = new HostActivator();
        ArrayList<HostActivator> list = new ArrayList<HostActivator>();
        list.add(m_activator);
        configProps.put("felix.systembundle.activators", list);
        try {
            m_felix = new Felix((Map)configProps);
            m_felix.init();
            loader.setFelix(configProps, m_activator.getBundleContext());
            loader.writeLabel("Starting... Weasis");
            m_tracker = new ServiceTracker(m_activator.getBundleContext(), "org.apache.felix.service.command.CommandProcessor", null);
            m_tracker.open();
            m_felix.start();
            loader.close();
            loader = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object commandSession = WeasisLauncher.getCommandSession(m_tracker.getService());
                    if (commandSession != null) {
                        for (StringBuffer command : commandList) {
                            WeasisLauncher.commandSession_execute(commandSession, command);
                        }
                        WeasisLauncher.commandSession_close(commandSession);
                    }
                    m_tracker.close();
                }
            });
            boolean uiStarted = false;
            for (Bundle b : m_felix.getBundleContext().getBundles()) {
                if (!b.getSymbolicName().equals("weasis-base-ui")) continue;
                uiStarted = true;
                break;
            }
            if (!uiStarted) {
                throw new Exception("Main User Interface bundle cannot be started");
            }
            m_felix.waitForStop(0L);
            System.exit(0);
        }
        catch (Exception ex) {
            exitStatus = -1;
            System.err.println("Could not create framework: " + ex);
            ex.printStackTrace();
        }
        finally {
            Runtime.getRuntime().halt(exitStatus);
        }
    }

    public Bundle[] getInstalledBundles() {
        return m_activator.getBundles();
    }

    public static List<StringBuffer> splitCommand(String[] args) {
        int length = args.length;
        ArrayList<StringBuffer> list = new ArrayList<StringBuffer>(5);
        for (int i = 0; i < length; ++i) {
            if (!args[i].startsWith("$") || args[i].length() <= 1) continue;
            StringBuffer command = new StringBuffer(args[i].substring(1));
            while (i + 1 < length && !args[i + 1].startsWith("$")) {
                command.append(" ");
                if (args[++i].indexOf(" ") != -1) {
                    command.append("\"");
                    command.append(args[i]);
                    command.append("\"");
                    continue;
                }
                command.append(args[i]);
            }
            list.add(command);
        }
        return list;
    }

    public static Object getCommandSession(Object commandProcessor) {
        if (commandProcessor == null) {
            return null;
        }
        Class[] parameterTypes = new Class[]{InputStream.class, PrintStream.class, PrintStream.class};
        Object[] arguments = new Object[]{System.in, System.out, System.err};
        try {
            Method nameMethod = commandProcessor.getClass().getMethod("createSession", parameterTypes);
            Object commandSession = nameMethod.invoke(commandProcessor, arguments);
            return commandSession;
        }
        catch (Exception ex) {
            System.err.println(ex);
            return null;
        }
    }

    public static boolean commandSession_close(Object commandSession) {
        if (commandSession == null) {
            return false;
        }
        try {
            Method nameMethod = commandSession.getClass().getMethod("close", null);
            nameMethod.invoke(commandSession, null);
            return true;
        }
        catch (Exception ex) {
            System.err.println(ex);
            return false;
        }
    }

    public static boolean commandSession_execute(Object commandSession, CharSequence charSequence) {
        if (commandSession == null) {
            return false;
        }
        Class[] parameterTypes = new Class[]{CharSequence.class};
        Object[] arguments = new Object[]{charSequence};
        try {
            Method nameMethod = commandSession.getClass().getMethod("execute", parameterTypes);
            nameMethod.invoke(commandSession, arguments);
            return true;
        }
        catch (Exception ex) {
            System.err.println(ex);
            ex.printStackTrace();
            return false;
        }
    }

    public static void loadSystemProperties() {
        int start;
        URL propURL = null;
        String custom = System.getProperty(SYSTEM_PROPERTIES_PROP);
        if (custom != null) {
            try {
                propURL = new URL(custom);
            }
            catch (MalformedURLException ex) {
                System.err.print("Main: " + ex);
                return;
            }
        }
        File confDir = null;
        String classpath = System.getProperty("java.class.path");
        int index = classpath.toLowerCase().indexOf("felix.jar");
        if (index >= (start = classpath.lastIndexOf(File.pathSeparator, index) + 1)) {
            String jarLocation = classpath.substring(start, index);
            confDir = new File(new File(new File(jarLocation).getAbsolutePath()).getParent(), CONFIG_DIRECTORY);
        } else {
            confDir = new File(System.getProperty("user.dir"), CONFIG_DIRECTORY);
        }
        try {
            propURL = new File(confDir, SYSTEM_PROPERTIES_FILE_VALUE).toURL();
        }
        catch (MalformedURLException ex) {
            System.err.print("Main: " + ex);
            return;
        }
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = propURL.openConnection().getInputStream();
            props.load(is);
            is.close();
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex) {
            System.err.println("Main: Error loading system properties from " + propURL);
            System.err.println("Main: " + ex);
            FileUtil.safeClose(is);
            return;
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            System.setProperty(name, Util.substVars((String)props.getProperty(name), (String)name, null, null));
        }
    }

    public static Properties loadConfigProperties() {
        int start;
        URL propURL = null;
        String custom = System.getProperty(CONFIG_PROPERTIES_PROP);
        if (custom != null) {
            try {
                propURL = new URL(custom);
            }
            catch (MalformedURLException ex) {
                System.err.print("Main: " + ex);
                return null;
            }
        }
        File confDir = null;
        String classpath = System.getProperty("java.class.path");
        int index = classpath.toLowerCase().indexOf("felix.jar");
        if (index >= (start = classpath.lastIndexOf(File.pathSeparator, index) + 1)) {
            String jarLocation = classpath.substring(start, index);
            confDir = new File(new File(new File(jarLocation).getAbsolutePath()).getParent(), CONFIG_DIRECTORY);
        } else {
            confDir = new File(System.getProperty("user.dir"), CONFIG_DIRECTORY);
        }
        try {
            propURL = new File(confDir, CONFIG_PROPERTIES_FILE_VALUE).toURL();
        }
        catch (MalformedURLException ex) {
            System.err.print("Main: " + ex);
            return null;
        }
        Properties props = WeasisLauncher.readProperties(propURL);
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                props.setProperty(name, Util.substVars((String)props.getProperty(name), (String)name, null, (Properties)props));
            }
        }
        return props;
    }

    public static Properties readProperties(URL propURL) {
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = propURL.openConnection().getInputStream();
            props.load(is);
            is.close();
        }
        catch (Exception ex) {
            FileUtil.safeClose(is);
            return null;
        }
        return props;
    }

    public static void copySystemProperties(Properties configProps) {
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("felix.") && !key.startsWith("org.osgi.framework.")) continue;
            configProps.setProperty(key, System.getProperty(key));
        }
    }

    public static void setSystemSpecification() {
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        if (osName != null && !osName.trim().equals("") && osArch != null && !osArch.trim().equals("")) {
            osName = osName.startsWith("Win") ? "windows" : (osName.equals("Mac OS X") ? "macosx" : (osName.equals("SymbianOS") ? "epoc32" : (osName.equals("hp-ux") ? "hpux" : (osName.equals("Mac OS") ? "macos" : (osName.equals("OS/2") ? "os2" : (osName.equals("procnto") ? "qnx" : osName.toLowerCase()))))));
            osArch = osArch.equals("pentium") || osArch.equals("i386") || osArch.equals("i486") || osArch.equals("i586") || osArch.equals("i686") ? "x86" : (osArch.equals("amd64") || osArch.equals("em64t") || osArch.equals("x86_64") ? "x86-64" : (osArch.equals("power ppc") ? "powerpc" : (osArch.equals("psc1k") ? "ignite" : osArch.toLowerCase())));
            System.setProperty("native.library.spec", osName + "-" + osArch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static WebStartLoader loadProperties(Properties config) {
        boolean cleanCache;
        Properties common_prop;
        String translation_modules;
        File basdir;
        String user;
        String dir = new File(config.getProperty("org.osgi.framework.storage")).getParent();
        System.setProperty(P_WEASIS_PATH, dir);
        String portable = System.getProperty("weasis.portable.dir");
        if (portable != null) {
            System.setProperty("weasis.portable.dicom.directory", config.getProperty("weasis.portable.dicom.directory"));
        }
        if ((user = System.getProperty("weasis.user", null)) == null) {
            basdir = new File(dir);
        } else {
            basdir = new File(dir + File.separator + "preferences" + File.separator + user);
            try {
                basdir.mkdirs();
            }
            catch (Exception e) {
                basdir = new File(dir);
                e.printStackTrace();
            }
        }
        File common_file = new File(basdir, APP_PROPERTY_FILE);
        Properties s_prop = WeasisLauncher.readProperties(common_file);
        String lang = System.getProperty("weasis.language", "en");
        String country = System.getProperty("weasis.country", "US");
        String variant = System.getProperty("weasis.variant", "");
        lang = s_prop.getProperty("locale.language", lang);
        if (!lang.equals("en") && (translation_modules = System.getProperty("weasis.i18n", null)) != null) {
            try {
                translation_modules = translation_modules + (translation_modules.endsWith("/") ? "buildNumber.properties" : "/buildNumber.properties");
                modulesi18n = WeasisLauncher.readProperties(new URL(translation_modules));
            }
            catch (MalformedURLException ex) {
                System.err.print("Cannot find translation modules: " + ex);
            }
        }
        country = s_prop.getProperty("locale.country", country);
        variant = s_prop.getProperty("locale.variant", variant);
        Locale.setDefault(new Locale(lang, country, variant));
        boolean update = false;
        boolean forceLook = false;
        look = System.getProperty("swing.defaultlaf", null);
        if (look == null) {
            look = s_prop.getProperty("weasis.look", null);
        } else {
            forceLook = true;
        }
        String sys_spec = System.getProperty("native.library.spec", "unknown");
        int index = sys_spec.indexOf("-");
        if (index > 0) {
            String sys = sys_spec.substring(0, index);
            String weasisNativeLaf = config.getProperty("weasis.look." + sys, null);
            if (weasisNativeLaf != null) {
                forceLook = true;
            }
            if (look == null) {
                look = weasisNativeLaf;
            }
        }
        if (look == null) {
            look = UIManager.getSystemLookAndFeelClassName();
        }
        if (basdir.getPath().equals(dir)) {
            common_prop = s_prop;
        } else {
            common_file = new File(dir, APP_PROPERTY_FILE);
            common_prop = WeasisLauncher.readProperties(common_file);
        }
        String versionOld = common_prop.getProperty(P_WEASIS_VERSION);
        String versionNew = config.getProperty(P_WEASIS_VERSION);
        if (LookAndFeels.installSubstanceLookAndFeels() && !forceLook && versionNew != null && !versionNew.equals(versionOld)) {
            look = "org.pushingpixels.substance.api.skin.SubstanceTwilightLookAndFeel";
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (look.startsWith("org.pushingpixels")) {
                    JFrame.setDefaultLookAndFeelDecorated(true);
                    JDialog.setDefaultLookAndFeelDecorated(true);
                }
                look = WeasisLauncher.setLookAndFeel(look);
            }
        });
        final WebStartLoader loader = new WebStartLoader();
        loader.open();
        if (versionNew != null) {
            System.setProperty(P_WEASIS_VERSION, versionNew);
            common_prop.put(P_WEASIS_VERSION, versionNew);
            if (versionOld == null || !versionOld.equals(versionNew)) {
                update = true;
            }
        }
        if (update) {
            common_prop.put("weasis.look", look);
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(common_file);
                common_prop.store(fout, null);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                FileUtil.safeClose(fout);
            }
            catch (IOException e2) {
                e2.printStackTrace();
                {
                    catch (Throwable throwable) {
                        FileUtil.safeClose(fout);
                        throw throwable;
                    }
                }
                FileUtil.safeClose(fout);
            }
            FileUtil.safeClose(fout);
        }
        if ((cleanCache = Boolean.parseBoolean(config.getProperty("weasis.clean.previous.version"))) && versionNew != null && !versionNew.equals(versionOld)) {
            System.out.printf("Clean previous Weasis version: %s \n", versionOld);
            config.setProperty("org.osgi.framework.storage.clean", "onFirstInit");
        }
        final File file = common_file;
        if (versionOld == null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object[] options = new Object[]{Messages.getString("WeasisLauncher.ok"), Messages.getString("WeasisLauncher.no")};
                    int response = JOptionPane.showOptionDialog(loader.getWindow(), Messages.getString("WeasisLauncher.msg"), Messages.getString("WeasisLauncher.first"), 0, 2, null, options, null);
                    if (response == 1) {
                        file.delete();
                        System.err.println("Refusing the disclaimer");
                        System.exit(-1);
                    }
                }
            });
        } else if (versionNew != null && !versionNew.equals(versionOld)) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JTextPane jTextPane1 = new JTextPane();
                    jTextPane1.setContentType("text/html");
                    jTextPane1.setEditable(false);
                    jTextPane1.addHyperlinkListener(new HyperlinkListener(){

                        @Override
                        public void hyperlinkUpdate(HyperlinkEvent e) {
                            JTextPane pane = (JTextPane)e.getSource();
                            if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                                pane.setToolTipText(e.getDescription());
                            } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                                pane.setToolTipText(null);
                            } else if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                Desktop desktop;
                                if (System.getProperty("os.name", "unknown").toLowerCase().startsWith("linux")) {
                                    try {
                                        String cmd = String.format("xdg-open %s", e.getURL());
                                        Runtime.getRuntime().exec(cmd);
                                    }
                                    catch (IOException e1) {
                                        e1.printStackTrace();
                                    }
                                } else if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                                    try {
                                        desktop.browse(e.getURL().toURI());
                                    }
                                    catch (IOException ex) {
                                        ex.printStackTrace();
                                    }
                                    catch (URISyntaxException ex2) {
                                        ex2.printStackTrace();
                                    }
                                }
                            }
                        }
                    });
                    jTextPane1.setBackground(Color.WHITE);
                    StyleSheet ss = ((HTMLEditorKit)jTextPane1.getEditorKit()).getStyleSheet();
                    ss.addRule("p {font-size:12}");
                    try {
                        jTextPane1.setPage(WeasisLauncher.class.getResource("/news.html"));
                        jTextPane1.setPreferredSize(new Dimension(630, 375));
                        JScrollPane sp = new JScrollPane(jTextPane1);
                        JOptionPane.showMessageDialog(loader.getWindow(), sp, Messages.getString("WeasisLauncher.News"), -1);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties readProperties(File propsFile) {
        Properties properties = new Properties();
        if (propsFile.canRead()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propsFile);
                properties.load(fis);
            }
            catch (Throwable t) {
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {}
            }
        } else {
            File appFoler = new File(System.getProperty(P_WEASIS_PATH, ""));
            appFoler.mkdirs();
        }
        return properties;
    }

    public static String setLookAndFeel(String look) {
        int i;
        int n;
        UIManager.LookAndFeelInfo[] lafs;
        block9: {
            UIManager.put("swing.boldMetal", Boolean.FALSE);
            UIManager.put("Slider.paintValue", Boolean.FALSE);
            lafs = UIManager.getInstalledLookAndFeels();
            if (look != null) {
                n = lafs.length;
                for (i = 0; i < n; ++i) {
                    if (!lafs[i].getClassName().equals(look)) {
                        continue;
                    }
                    break block9;
                }
                look = null;
            }
        }
        if (look == null) {
            n = lafs.length;
            for (i = 0; i < n; ++i) {
                if (!lafs[i].getName().equals("Nimbus")) continue;
                look = lafs[i].getClassName();
                break;
            }
            if (look == null) {
                look = UIManager.getSystemLookAndFeelClassName();
            }
        }
        if (look != null) {
            try {
                UIManager.setLookAndFeel(look);
            }
            catch (Exception e) {
                System.err.println("WARNING : Unable to set the Look&Feel");
                e.printStackTrace();
            }
        }
        return look;
    }
}

