/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.config;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.config.AbstractComponentHolder;
import org.apache.felix.scr.impl.manager.ImmediateComponentManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;

public class ConfiguredComponentHolder
extends AbstractComponentHolder {
    private final Map m_components = new HashMap();
    private ImmediateComponentManager m_singleComponent = this.createComponentManager();
    private boolean m_enabled = false;

    ConfiguredComponentHolder(BundleComponentActivator activator, ComponentMetadata metadata) {
        super(activator, metadata);
    }

    public void configurationDeleted(String pid) {
        if (this.m_singleComponent == null) {
            return;
        }
        if (pid.equals(this.getComponentName())) {
            this.m_singleComponent.reconfigure(null);
        } else {
            ImmediateComponentManager icm = this.removeComponentManager(pid);
            if (icm != null) {
                if (this.m_singleComponent == icm) {
                    if (this.m_components.isEmpty()) {
                        icm.reconfigure(null);
                        icm = null;
                    } else {
                        this.m_singleComponent = (ImmediateComponentManager)this.m_components.values().iterator().next();
                    }
                }
                if (icm != null) {
                    icm.dispose(4);
                }
            }
        }
    }

    public void configurationUpdated(String pid, Dictionary props) {
        if (this.m_singleComponent == null) {
            return;
        }
        if (pid.equals(this.getComponentName())) {
            this.m_singleComponent.reconfigure(props);
        } else {
            ImmediateComponentManager icm = this.getComponentManager(pid);
            if (icm != null) {
                icm.reconfigure(props);
            } else {
                ImmediateComponentManager newIcm = !this.m_singleComponent.hasConfiguration() ? this.m_singleComponent : this.createComponentManager();
                newIcm.reconfigure(props);
                if (this.m_enabled && this.getComponentMetadata().isEnabled()) {
                    newIcm.enable();
                }
                this.putComponentManager(pid, newIcm);
            }
        }
    }

    public Component[] getComponents() {
        Component[] componentArray;
        Component[] components = this.getComponentManagers(false);
        if (components != null) {
            componentArray = components;
        } else {
            Component[] componentArray2 = new Component[1];
            componentArray = componentArray2;
            componentArray2[0] = this.m_singleComponent;
        }
        return componentArray;
    }

    public void enableComponents() {
        ImmediateComponentManager[] cms = this.getComponentManagers(false);
        if (cms == null) {
            this.m_singleComponent.enable();
        } else {
            for (int i = 0; i < cms.length; ++i) {
                cms[i].enable();
            }
        }
        this.m_enabled = true;
    }

    public void disableComponents() {
        this.m_enabled = false;
        ImmediateComponentManager[] cms = this.getComponentManagers(false);
        if (cms == null) {
            this.m_singleComponent.disable();
        } else {
            for (int i = 0; i < cms.length; ++i) {
                cms[i].disable();
            }
        }
    }

    public void disposeComponents(int reason) {
        ImmediateComponentManager singleComponent = this.m_singleComponent;
        this.m_singleComponent = null;
        ImmediateComponentManager[] cms = this.getComponentManagers(true);
        if (cms == null) {
            singleComponent.dispose(reason);
        } else {
            for (int i = 0; i < cms.length; ++i) {
                cms[i].dispose(reason);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposed(ImmediateComponentManager component) {
        Map map = this.m_components;
        synchronized (map) {
            if (!this.m_components.isEmpty()) {
                Iterator vi = this.m_components.values().iterator();
                while (vi.hasNext()) {
                    if (component != vi.next()) continue;
                    vi.remove();
                    break;
                }
            }
        }
        if (component == this.m_singleComponent) {
            map = this.m_components;
            synchronized (map) {
                this.m_singleComponent = this.m_components.isEmpty() ? this.createComponentManager() : (ImmediateComponentManager)this.m_components.values().iterator().next();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImmediateComponentManager getComponentManager(String pid) {
        Map map = this.m_components;
        synchronized (map) {
            return (ImmediateComponentManager)this.m_components.get(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImmediateComponentManager removeComponentManager(String pid) {
        Map map = this.m_components;
        synchronized (map) {
            return (ImmediateComponentManager)this.m_components.remove(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putComponentManager(String pid, ImmediateComponentManager componentManager) {
        Map map = this.m_components;
        synchronized (map) {
            this.m_components.put(pid, componentManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImmediateComponentManager[] getComponentManagers(boolean clear) {
        Map map = this.m_components;
        synchronized (map) {
            if (this.m_components.isEmpty()) {
                return null;
            }
            ImmediateComponentManager[] cm = new ImmediateComponentManager[this.m_components.size()];
            this.m_components.values().toArray(cm);
            if (clear) {
                this.m_components.clear();
            }
            return cm;
        }
    }
}

