/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.helper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.felix.scr.impl.helper.BaseMethod;
import org.apache.felix.scr.impl.helper.SuitableMethodNotAccessibleException;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.osgi.service.component.ComponentContext;

public class ActivateMethod
extends BaseMethod {
    Class[] ACTIVATE_TYPES_DS11 = new Class[]{COMPONENT_CONTEXT_CLASS, BUNDLE_CONTEXT_CLASS, MAP_CLASS};
    Class[] ACTIVATE_TYPES_DS10 = new Class[]{COMPONENT_CONTEXT_CLASS};

    public ActivateMethod(AbstractComponentManager componentManager, String methodName, boolean methodRequired, Class componentClass) {
        super(componentManager, methodName, methodRequired, componentClass);
    }

    protected Method doFindMethod(Class targetClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        boolean suitableMethodNotAccessible = false;
        try {
            Method method = this.getSingleParameterMethod(targetClass, acceptPrivate, acceptPackage);
            if (method != null) {
                return method;
            }
        }
        catch (SuitableMethodNotAccessibleException smnae) {
            suitableMethodNotAccessible = true;
        }
        if (this.isDS11()) {
            Method[] methods = targetClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(this.getMethodName()) || !this.isSuitable(methods[i])) continue;
                if (ActivateMethod.accept(methods[i], acceptPrivate, acceptPackage)) {
                    return methods[i];
                }
                suitableMethodNotAccessible = true;
            }
            if (this.acceptEmpty()) {
                try {
                    return this.getMethod(targetClass, this.getMethodName(), null, acceptPrivate, acceptPackage);
                }
                catch (SuitableMethodNotAccessibleException smnae) {
                    suitableMethodNotAccessible = true;
                }
            }
        }
        if (suitableMethodNotAccessible) {
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    protected Object[] getParameters(Method method, Object rawParameter) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        ActivatorParameter ap = (ActivatorParameter)rawParameter;
        Object[] param = new Object[parameterTypes.length];
        for (int i = 0; i < param.length; ++i) {
            if (parameterTypes[i] == COMPONENT_CONTEXT_CLASS) {
                param[i] = ap.getComponentContext();
                continue;
            }
            if (parameterTypes[i] == BUNDLE_CONTEXT_CLASS) {
                param[i] = ap.getComponentContext().getBundleContext();
                continue;
            }
            if (parameterTypes[i] == MAP_CLASS) {
                param[i] = ap.getComponentContext().getProperties();
                continue;
            }
            if (parameterTypes[i] != INTEGER_CLASS && parameterTypes[i] != Integer.TYPE) continue;
            param[i] = new Integer(ap.getReason());
        }
        return param;
    }

    protected String getMethodNamePrefix() {
        return "activate";
    }

    public boolean invoke(Object componentInstance, Object rawParameter, boolean methodCallFailureResult) {
        return this.methodExists() && super.invoke(componentInstance, rawParameter, methodCallFailureResult);
    }

    private Method getSingleParameterMethod(Class targetClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        SuitableMethodNotAccessibleException ex = null;
        Method singleParameterMethod = null;
        Class[] acceptedTypes = this.getAcceptedParameterTypes();
        for (int i = 0; singleParameterMethod == null && i < acceptedTypes.length; ++i) {
            try {
                singleParameterMethod = this.getMethod(targetClass, this.getMethodName(), new Class[]{acceptedTypes[i]}, acceptPrivate, acceptPackage);
                continue;
            }
            catch (SuitableMethodNotAccessibleException thrown) {
                this.getComponentManager().log(4, "SuitableMethodNotAccessible", thrown);
                ex = thrown;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return singleParameterMethod;
    }

    private boolean isSuitable(Method method) {
        Class<?>[] types = method.getParameterTypes();
        if (types.length < 2) {
            return false;
        }
        Class[] acceptedTypes = this.getAcceptedParameterTypes();
        block0: for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            for (int j = 0; j < acceptedTypes.length; ++j) {
                if (type == acceptedTypes[j]) continue block0;
            }
            return false;
        }
        return true;
    }

    protected Class[] getAcceptedParameterTypes() {
        return this.isDS11() ? this.ACTIVATE_TYPES_DS11 : this.ACTIVATE_TYPES_DS10;
    }

    protected boolean acceptEmpty() {
        return this.isDS11();
    }

    public static final class ActivatorParameter {
        private final ComponentContext m_componentContext;
        private final int m_reason;

        public ActivatorParameter(ComponentContext componentContext, int reason) {
            this.m_componentContext = componentContext;
            this.m_reason = reason;
        }

        public ComponentContext getComponentContext() {
            return this.m_componentContext;
        }

        public int getReason() {
            return this.m_reason;
        }
    }
}

