/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.Reference;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.helper.BindMethod;
import org.apache.felix.scr.impl.helper.UnbindMethod;
import org.apache.felix.scr.impl.helper.UpdatedMethod;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;

public class DependencyManager
implements ServiceListener,
Reference {
    private static final int STATE_MASK = 124;
    private static final Object BOUND_SERVICE_SENTINEL = new Object();
    private final AbstractComponentManager m_componentManager;
    private final ReferenceMetadata m_dependencyMetadata;
    private final Map m_bound;
    private int m_size;
    private transient Object m_componentInstance;
    private BindMethod m_bind;
    private UpdatedMethod m_updated;
    private UnbindMethod m_unbind;
    private String m_target;
    private Filter m_targetFilter;

    DependencyManager(AbstractComponentManager componentManager, ReferenceMetadata dependency) {
        this.m_componentManager = componentManager;
        this.m_dependencyMetadata = dependency;
        this.m_bound = Collections.synchronizedMap(new HashMap());
        this.setTargetFilter(this.m_dependencyMetadata.getTarget());
        if (this.m_componentManager.isLogEnabled(4)) {
            this.m_componentManager.log(4, "Dependency Manager {0} created: interface={1}, filter={2}, policy={3}, cardinality={4}, bind={5}, unbind={6}", new Object[]{this.getName(), dependency.getInterface(), dependency.getTarget(), dependency.getPolicy(), dependency.getCardinality(), dependency.getBind(), dependency.getUnbind()}, null);
        }
    }

    private void initBindingMethods() {
        this.m_bind = new BindMethod(this.m_componentManager, this.m_dependencyMetadata.getBind(), this.m_componentInstance.getClass(), this.m_dependencyMetadata.getName(), this.m_dependencyMetadata.getInterface());
        this.m_updated = new UpdatedMethod(this.m_componentManager, this.m_dependencyMetadata.getUpdated(), this.m_componentInstance.getClass(), this.m_dependencyMetadata.getName(), this.m_dependencyMetadata.getInterface());
        this.m_unbind = new UnbindMethod(this.m_componentManager, this.m_dependencyMetadata.getUnbind(), this.m_componentInstance.getClass(), this.m_dependencyMetadata.getName(), this.m_dependencyMetadata.getInterface());
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference ref = event.getServiceReference();
        String serviceString = "Service " + this.m_dependencyMetadata.getInterface() + "/" + ref.getProperty("service.id");
        switch (event.getType()) {
            case 1: {
                this.m_componentManager.log(4, "Dependency Manager: Adding {0}", new Object[]{serviceString}, null);
                if (this.targetFilterMatch(ref)) {
                    ++this.m_size;
                    this.serviceAdded(ref);
                    break;
                }
                this.m_componentManager.log(4, "Dependency Manager: Ignoring added Service for {0} : does not match target filter {1}", new Object[]{this.m_dependencyMetadata.getName(), this.getTarget()}, null);
                break;
            }
            case 2: {
                this.m_componentManager.log(4, "Dependency Manager: Updating {0}", new Object[]{serviceString}, null);
                if (this.getBoundService(ref) == null) {
                    if (!this.targetFilterMatch(ref)) break;
                    ++this.m_size;
                    if (this.isStatic()) {
                        if (this.m_componentManager.getState() != 4) break;
                        this.m_componentManager.log(3, "Dependency Manager: Service {0} registered, activate component", new Object[]{this.m_dependencyMetadata.getName()}, null);
                        this.m_componentManager.activateInternal();
                        break;
                    }
                    if (!this.isMultiple()) break;
                    this.serviceAdded(ref);
                    break;
                }
                if (!this.targetFilterMatch(ref)) {
                    --this.m_size;
                    this.serviceRemoved(ref);
                    break;
                }
                this.update(ref);
                break;
            }
            case 4: {
                this.m_componentManager.log(4, "Dependency Manager: Removing {0}", new Object[]{serviceString}, null);
                if (this.targetFilterMatch(ref)) {
                    --this.m_size;
                } else {
                    this.m_componentManager.log(4, "Dependency Manager: Not counting Service for {0} : Service {1} does not match target filter {2}", new Object[]{this.m_dependencyMetadata.getName(), ref.getProperty("service.id"), this.getTarget()}, null);
                }
                this.serviceRemoved(ref);
            }
        }
    }

    private void serviceAdded(ServiceReference reference) {
        if (this.m_componentManager.getState() == 4) {
            this.m_componentManager.log(3, "Dependency Manager: Service {0} registered, activate component", new Object[]{this.m_dependencyMetadata.getName()}, null);
            this.m_componentManager.activateInternal();
        } else if (this.handleServiceEvent()) {
            if (this.m_dependencyMetadata.isStatic()) {
                this.m_componentManager.log(4, "Dependency Manager: Added service {0} is ignored for static reference", new Object[]{this.m_dependencyMetadata.getName()}, null);
            } else if (this.m_dependencyMetadata.getBind() != null && (this.m_dependencyMetadata.isMultiple() || !this.isBound())) {
                this.invokeBindMethod(reference);
            }
        } else {
            this.m_componentManager.log(4, "Dependency Manager: Ignoring service addition, wrong state {0}", new Object[]{this.m_componentManager.state()}, null);
        }
    }

    private void serviceRemoved(ServiceReference reference) {
        if (!this.isSatisfied()) {
            this.m_componentManager.log(4, "Dependency Manager: Deactivating component due to mandatory dependency on {0}/{1} not satisfied", new Object[]{this.m_dependencyMetadata.getName(), this.m_dependencyMetadata.getInterface()}, null);
            this.m_componentManager.deactivateInternal(2);
        }
        if (this.getBoundService(reference) == null) {
            this.m_componentManager.log(4, "Dependency Manager: Ignoring removed Service for {0} : Service {1} not bound", new Object[]{this.m_dependencyMetadata.getName(), reference.getProperty("service.id")}, null);
        } else if (this.handleServiceEvent()) {
            if (this.m_dependencyMetadata.isStatic()) {
                try {
                    this.m_componentManager.log(4, "Dependency Manager: Static dependency on {0}/{1} is broken", new Object[]{this.m_dependencyMetadata.getName(), this.m_dependencyMetadata.getInterface()}, null);
                    this.m_componentManager.deactivateInternal(2);
                    this.m_componentManager.activateInternal();
                }
                catch (Exception ex) {
                    this.m_componentManager.log(1, "Exception while recreating dependency ", ex);
                }
            } else {
                if (!this.m_dependencyMetadata.isMultiple() && !this.bind()) {
                    this.m_componentManager.log(4, "Dependency Manager: Deactivating component due to mandatory dependency on {0}/{1} not satisfied", new Object[]{this.m_dependencyMetadata.getName(), this.m_dependencyMetadata.getInterface()}, null);
                    this.m_componentManager.deactivateInternal(2);
                }
                if (this.m_dependencyMetadata.getUnbind() != null) {
                    this.invokeUnbindMethod(reference);
                }
                this.ungetService(reference);
            }
        } else {
            this.m_componentManager.log(4, "Dependency Manager: Ignoring service removal, wrong state {0}", new Object[]{this.m_componentManager.state()}, null);
        }
    }

    private boolean handleServiceEvent() {
        return (this.m_componentManager.getState() & 0x7C) != 0;
    }

    public String getServiceName() {
        return this.m_dependencyMetadata.getInterface();
    }

    public ServiceReference[] getServiceReferences() {
        return this.getBoundServiceReferences();
    }

    public boolean isOptional() {
        return this.m_dependencyMetadata.isOptional();
    }

    public boolean isMultiple() {
        return this.m_dependencyMetadata.isMultiple();
    }

    public boolean isStatic() {
        return this.m_dependencyMetadata.isStatic();
    }

    public String getBindMethodName() {
        return this.m_dependencyMetadata.getBind();
    }

    public String getUnbindMethodName() {
        return this.m_dependencyMetadata.getUnbind();
    }

    public String getUpdatedMethodName() {
        return this.m_dependencyMetadata.getUpdated();
    }

    void enable() throws InvalidSyntaxException {
        if (this.hasGetPermission()) {
            ServiceReference[] refs = this.getFrameworkServiceReferences();
            this.m_size = refs == null ? 0 : refs.length;
            String filterString = "(objectClass=" + this.m_dependencyMetadata.getInterface() + ")";
            this.m_componentManager.getActivator().getBundleContext().addServiceListener((ServiceListener)this, filterString);
            this.m_componentManager.log(4, "Registered for service events, currently {0} service(s) match the filter", new Object[]{new Integer(this.m_size)}, null);
        } else {
            this.m_size = 0;
            this.m_componentManager.log(4, "Not registered for service events since the bundle has no permission to get service {0}", new Object[]{this.m_dependencyMetadata.getInterface()}, null);
        }
    }

    void disable() {
        BundleContext context = this.m_componentManager.getActivator().getBundleContext();
        context.removeServiceListener((ServiceListener)this);
        this.m_size = 0;
        ServiceReference[] boundRefs = this.getBoundServiceReferences();
        if (boundRefs != null) {
            for (int i = 0; i < boundRefs.length; ++i) {
                this.ungetService(boundRefs[i]);
            }
        }
        this.setTargetFilter(this.m_dependencyMetadata.getTarget());
    }

    int size() {
        return this.m_size;
    }

    ServiceReference[] getFrameworkServiceReferences() {
        return this.getFrameworkServiceReferences(this.getTarget());
    }

    private ServiceReference[] getFrameworkServiceReferences(String targetFilter) {
        if (this.hasGetPermission()) {
            BundleComponentActivator bca = this.m_componentManager.getActivator();
            if (bca == null) {
                return null;
            }
            BundleContext bc = bca.getBundleContext();
            if (bc == null) {
                return null;
            }
            try {
                return bc.getServiceReferences(this.m_dependencyMetadata.getInterface(), targetFilter);
            }
            catch (IllegalStateException ise) {
            }
            catch (InvalidSyntaxException ise) {
                this.m_componentManager.log(1, "Unexpected problem with filter ''{0}''", new Object[]{targetFilter}, ise);
                return null;
            }
        }
        this.m_componentManager.log(4, "No permission to access the services", null);
        return null;
    }

    ServiceReference getFrameworkServiceReference() {
        ServiceReference[] refs = this.getFrameworkServiceReferences();
        if (refs == null) {
            return null;
        }
        if (refs.length == 1) {
            return refs[0];
        }
        ServiceReference selectedRef = refs[0];
        for (int i = 1; i < refs.length; ++i) {
            ServiceReference ref = refs[i];
            if (ref.compareTo((Object)selectedRef) <= 0) continue;
            selectedRef = ref;
        }
        return selectedRef;
    }

    Object getService() {
        ServiceReference sr = this.getFrameworkServiceReference();
        return sr != null ? this.getService(sr) : null;
    }

    Object[] getServices() {
        ServiceReference[] sr = this.getFrameworkServiceReferences();
        if (sr == null || sr.length == 0) {
            return null;
        }
        ArrayList<Object> services = new ArrayList<Object>();
        for (int i = 0; i < sr.length; ++i) {
            Object service = this.getService(sr[i]);
            if (service == null) continue;
            services.add(service);
        }
        return services.size() > 0 ? services.toArray() : null;
    }

    private ServiceReference[] getBoundServiceReferences() {
        if (this.m_bound.isEmpty()) {
            return null;
        }
        return this.m_bound.keySet().toArray(new ServiceReference[this.m_bound.size()]);
    }

    private boolean isBound() {
        return !this.m_bound.isEmpty();
    }

    private void bindService(ServiceReference serviceReference) {
        this.m_bound.put(serviceReference, BOUND_SERVICE_SENTINEL);
    }

    private Object getBoundService(ServiceReference serviceReference) {
        return this.m_bound.get(serviceReference);
    }

    Object getService(ServiceReference serviceReference) {
        Object service = this.getBoundService(serviceReference);
        if (service != null && service != BOUND_SERVICE_SENTINEL) {
            return service;
        }
        try {
            service = this.m_componentManager.getActivator().getBundleContext().getService(serviceReference);
        }
        catch (IllegalStateException ise) {
            this.m_componentManager.log(1, "Failed getting service {0} ({1}/{2,number,#})", new Object[]{this.m_dependencyMetadata.getName(), this.m_dependencyMetadata.getInterface(), serviceReference.getProperty("service.id")}, ise);
            service = null;
        }
        if (service != null) {
            this.m_bound.put(serviceReference, service);
        }
        return service;
    }

    void ungetService(ServiceReference serviceReference) {
        Object service = this.m_bound.remove(serviceReference);
        if (service != null && service != BOUND_SERVICE_SENTINEL) {
            this.m_componentManager.getActivator().getBundleContext().ungetService(serviceReference);
        }
    }

    public String getName() {
        return this.m_dependencyMetadata.getName();
    }

    public boolean isSatisfied() {
        return this.size() > 0 || this.m_dependencyMetadata.isOptional();
    }

    public boolean hasGetPermission() {
        if (System.getSecurityManager() != null) {
            ServicePermission perm = new ServicePermission(this.getServiceName(), "get");
            return this.m_componentManager.getBundle().hasPermission((Object)perm);
        }
        return true;
    }

    boolean open(Object instance) {
        this.m_componentInstance = instance;
        this.initBindingMethods();
        return this.bind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        try {
            this.unbind(this.getBoundServiceReferences());
        }
        finally {
            this.m_componentInstance = null;
            this.m_bind = null;
            this.m_unbind = null;
            this.m_bound.clear();
        }
    }

    private boolean bind() {
        if (!this.isSatisfied()) {
            return false;
        }
        if (this.m_componentInstance == null || this.m_dependencyMetadata.getBind() == null) {
            return true;
        }
        boolean success = this.m_dependencyMetadata.isOptional();
        if (this.m_dependencyMetadata.isMultiple()) {
            ServiceReference[] refs = this.getFrameworkServiceReferences();
            if (refs != null) {
                for (int index = 0; index < refs.length; ++index) {
                    if (!this.invokeBindMethod(refs[index])) continue;
                    success = true;
                }
            }
        } else {
            ServiceReference ref = this.getFrameworkServiceReference();
            if (ref != null && this.invokeBindMethod(ref)) {
                success = true;
            }
        }
        return success;
    }

    private void update(ServiceReference ref) {
        if (this.m_dependencyMetadata.getUpdated() != null) {
            this.invokeUpdatedMethod(ref);
        }
    }

    private void unbind(ServiceReference[] boundRefs) {
        if (boundRefs != null) {
            boolean doUnbind = this.m_componentInstance != null && this.m_dependencyMetadata.getUnbind() != null;
            for (int i = 0; i < boundRefs.length; ++i) {
                if (doUnbind) {
                    this.invokeUnbindMethod(boundRefs[i]);
                }
                this.ungetService(boundRefs[i]);
            }
        }
    }

    private boolean invokeBindMethod(final ServiceReference ref) {
        if (this.m_componentInstance != null) {
            return this.m_bind.invoke(this.m_componentInstance, new BindMethod.Service(){

                public ServiceReference getReference() {
                    DependencyManager.this.bindService(ref);
                    return ref;
                }

                public Object getInstance() {
                    return DependencyManager.this.getService(ref);
                }
            }, true);
        }
        if (!this.m_componentManager.getComponentMetadata().isImmediate()) {
            this.m_componentManager.log(4, "DependencyManager : Delayed component not yet created, assuming bind method call succeeded", null);
            return true;
        }
        if (this.m_componentManager.getState() == 8) {
            this.m_componentManager.log(4, "DependencyManager : Not yet open for activating component", null);
            return true;
        }
        this.m_componentManager.log(1, "DependencyManager : Immediate component not yet created, bind method cannot be called", null);
        return false;
    }

    private void invokeUpdatedMethod(final ServiceReference ref) {
        if (this.m_componentInstance != null) {
            this.m_updated.invoke(this.m_componentInstance, new BindMethod.Service(){

                public ServiceReference getReference() {
                    return ref;
                }

                public Object getInstance() {
                    return DependencyManager.this.getService(ref);
                }
            }, true);
        } else {
            this.m_componentManager.log(4, "DependencyManager : Component not set, no need to call updated method", null);
        }
    }

    private void invokeUnbindMethod(final ServiceReference ref) {
        if (this.m_componentInstance != null) {
            this.m_unbind.invoke(this.m_componentInstance, new BindMethod.Service(){

                public ServiceReference getReference() {
                    return ref;
                }

                public Object getInstance() {
                    return DependencyManager.this.getService(ref);
                }
            }, true);
        } else {
            this.m_componentManager.log(4, "DependencyManager : Component not set, no need to call unbind method", null);
        }
    }

    boolean canUpdateDynamically(Dictionary properties) {
        String newTarget = (String)properties.get(this.m_dependencyMetadata.getTargetPropertyName());
        String currentTarget = this.getTarget();
        if (currentTarget == null && newTarget == null || currentTarget != null && currentTarget.equals(newTarget)) {
            return true;
        }
        if (this.m_dependencyMetadata.isStatic()) {
            return false;
        }
        ServiceReference[] refs = this.getFrameworkServiceReferences(newTarget);
        if (refs != null && refs.length > 0) {
            return true;
        }
        return this.m_dependencyMetadata.isOptional();
    }

    void setTargetFilter(Dictionary properties) {
        this.setTargetFilter((String)properties.get(this.m_dependencyMetadata.getTargetPropertyName()));
    }

    private void setTargetFilter(String target) {
        int i;
        ServiceReference[] refs;
        if (this.m_target == null && target == null || this.m_target != null && this.m_target.equals(target)) {
            return;
        }
        this.m_target = target;
        if (target != null) {
            try {
                this.m_targetFilter = this.m_componentManager.getActivator().getBundleContext().createFilter(target);
            }
            catch (InvalidSyntaxException ise) {
                this.m_targetFilter = null;
            }
        } else {
            this.m_targetFilter = null;
        }
        if (this.m_targetFilter != null && (refs = this.getBoundServiceReferences()) != null) {
            for (i = 0; i < refs.length; ++i) {
                if (this.m_targetFilter.match(refs[i])) continue;
                this.serviceRemoved(refs[i]);
            }
        }
        if ((refs = this.getFrameworkServiceReferences()) != null) {
            for (i = 0; i < refs.length; ++i) {
                if (this.getBoundService(refs[i]) != null) continue;
                this.serviceAdded(refs[i]);
            }
            this.m_size = refs.length;
        } else {
            this.m_size = 0;
        }
    }

    public String getTarget() {
        return this.m_target;
    }

    private boolean targetFilterMatch(ServiceReference ref) {
        return this.m_targetFilter == null || this.m_targetFilter.match(ref);
    }
}

