/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JDialog;
import org.noos.xing.mydoggy.AggregationPosition;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentManager;
import org.noos.xing.mydoggy.ContentUI;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.ui.cmp.ContentWindow;
import org.noos.xing.mydoggy.plaf.ui.cmp.ContentWindowMultiSplitContainer;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitDockableContainer;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.ToFrontWindowFocusListener;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.WindowTransparencyListener;
import org.noos.xing.mydoggy.plaf.ui.cmp.multisplit.MultiSplitLayout;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentDialog
extends JDialog
implements ContentWindow {
    protected Content content;
    protected ContentUI contentUI;
    protected MultiSplitDockableContainer<Content> multiSplitDockableContainer;

    public ContentDialog(Content content, ContentUI contentUI, Frame parentFrame, Rectangle inBounds) throws HeadlessException {
        super(contentUI.isAlwaysOnTop() ? parentFrame : null, false);
        this.setAlwaysOnTop(contentUI.isAlwaysOnTop());
        this.content = content;
        this.contentUI = contentUI;
        this.installComponents();
        this.installListeners(parentFrame);
        Rectangle detachedBounds = SwingUtil.validateBounds(contentUI.getDetachedBounds());
        if (detachedBounds != null) {
            this.setBounds(detachedBounds);
        } else if (inBounds != null) {
            this.setBounds(inBounds);
        } else if (parentFrame != null) {
            Point location = parentFrame.getLocation();
            location.translate(5, 5);
            this.setLocation(location);
        } else {
            SwingUtil.centrePositionOnScreen(this);
        }
    }

    @Override
    public void addDockable(Content content, Component contentComponent) {
        this.addDockable(content, contentComponent, (Content)null, AggregationPosition.DEFAULT);
    }

    @Override
    public void addDockable(Content content, Component componentContent, Content aggregationOnContent, AggregationPosition aggregationPosition) {
        this.multiSplitDockableContainer.addDockable(content, componentContent, aggregationOnContent, -1, aggregationPosition);
    }

    @Override
    public void removeDockable(Content content) {
        this.multiSplitDockableContainer.removeDockable(content);
    }

    @Override
    public int getDockableCount() {
        return this.multiSplitDockableContainer.getDockableCount();
    }

    @Override
    public Content getDockable() {
        return (Content)this.multiSplitDockableContainer.getDockable();
    }

    @Override
    public List<Content> getDockables() {
        return this.multiSplitDockableContainer.getDockables();
    }

    @Override
    public boolean containsDockable(Content content) {
        return this.multiSplitDockableContainer.containsDockable(content);
    }

    @Override
    public Object getMultiSplitLayout() {
        return this.multiSplitDockableContainer.getMultiSplitLayout();
    }

    @Override
    public void setMultiSplitLayout(Object model) {
        this.multiSplitDockableContainer.setMultiSplitLayout((MultiSplitLayout.Node)model);
    }

    @Override
    public boolean setComponent(Content content, Component component) {
        return this.multiSplitDockableContainer.setComponent(content, component);
    }

    @Override
    public boolean isDisposed() {
        return this.multiSplitDockableContainer == null;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.content = null;
        this.contentUI = null;
        this.multiSplitDockableContainer = null;
    }

    protected void installComponents() {
        this.setTitle(this.content.getTitle());
        Component component = this.content.getComponent();
        component.setPreferredSize(component.getSize());
        this.multiSplitDockableContainer = new ContentWindowMultiSplitContainer((MyDoggyToolWindowManager)((ContentManager)this.content.getDockableManager()).getToolWindowManager());
        this.multiSplitDockableContainer.addDockable(this.content, component, null);
        this.setLayout(new ExtendedTableLayout(new double[][]{{0.0, -1.0, 0.0}, {0.0, -1.0, 0.0}}));
        this.add(this.multiSplitDockableContainer, "1,1,FULL,FULL");
    }

    protected void installListeners(Frame parentFrame) {
        this.addWindowListener(new ContentWindowAdapter());
        if (parentFrame == null) {
            this.addWindowFocusListener(new ToFrontWindowFocusListener(this));
        }
        this.addComponentListener(new ContentWindowComponentAdapter());
        this.addWindowListener(new ContentWindowAdapter());
        if (SwingUtil.getTransparencyManager().isServiceAvailable()) {
            WindowTransparencyListener windowTransparencyListener = new WindowTransparencyListener(SwingUtil.getTransparencyManager(), this.contentUI, this);
            this.addWindowListener(windowTransparencyListener);
            this.addWindowFocusListener(windowTransparencyListener);
        }
    }

    public class ContentWindowAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            if (ContentDialog.this.multiSplitDockableContainer != null) {
                for (Content content : ContentDialog.this.multiSplitDockableContainer.getDockables()) {
                    content.setDetached(false);
                }
            }
            ContentDialog.this.content = null;
            ContentDialog.this.contentUI = null;
            ContentDialog.this.multiSplitDockableContainer = null;
            super.windowClosing(e);
        }
    }

    public class ContentWindowComponentAdapter
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            this.update();
        }

        public void componentMoved(ComponentEvent e) {
            this.update();
        }

        protected void update() {
            if (ContentDialog.this.isActive() && ContentDialog.this.isVisible() && ContentDialog.this.multiSplitDockableContainer != null) {
                Rectangle bounds = ContentDialog.this.getBounds();
                for (Content content : ContentDialog.this.multiSplitDockableContainer.getDockables()) {
                    content.getContentUI().setDetachedBounds(bounds);
                }
            }
        }
    }
}

