/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;

public class TextIcon
implements Icon,
PropertyChangeListener {
    public static final int ROTATE_DEFAULT = 0;
    public static final int ROTATE_NONE = 1;
    public static final int ROTATE_LEFT = 2;
    public static final int ROTATE_RIGHT = 3;
    static final double NINETY_DEGREES = Math.toRadians(90.0);
    static final int kBufferSpace = 5;
    protected Color foreground;
    protected Component component;
    protected String text;
    protected int rotation;
    protected int underlinedIndex;
    protected int fWidth;
    protected int fHeight;
    protected int fDescent;

    public TextIcon(Component component, String text) {
        this(component, text, 0, -1);
    }

    public TextIcon(Component component, String text, int rotateHint) {
        this(component, text, rotateHint, -1);
    }

    public TextIcon(Component component, String text, int rotateHint, int underlinedIndex) {
        this.component = component;
        this.text = text;
        this.underlinedIndex = underlinedIndex;
        this.rotation = rotateHint;
        this.calcDimensions();
        this.component.addPropertyChangeListener(this);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(this.foreground != null ? this.foreground : c.getForeground());
        g.setFont(c.getFont());
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        switch (this.rotation) {
            case 1: {
                g.drawString(this.text, x + 5, y + this.fHeight - this.fDescent);
                if (this.underlinedIndex < 0 || this.underlinedIndex >= this.text.length()) break;
                FontMetrics fm = g.getFontMetrics();
                int underlineRectX = x + 5 + fm.stringWidth(this.text.substring(0, this.underlinedIndex));
                int underlineRectY = y + this.fHeight - 2;
                int underlineRectWidth = fm.charWidth(this.text.charAt(this.underlinedIndex));
                int underlineRectHeight = 1;
                g.fillRect(underlineRectX, underlineRectY + 1, underlineRectWidth, underlineRectHeight);
                break;
            }
            case 2: {
                g2D.translate(x + this.fWidth, y + this.fHeight);
                g2D.rotate(-NINETY_DEGREES);
                g2D.drawString(this.text, 5, -this.fDescent);
                g2D.rotate(NINETY_DEGREES);
                g2D.translate(-(x + this.fWidth), -(y + this.fHeight));
                break;
            }
            case 3: {
                g2D.translate(x, y);
                g2D.rotate(NINETY_DEGREES);
                g2D.drawString(this.text, 5, -this.fDescent);
                g2D.rotate(-NINETY_DEGREES);
                g2D.translate(-x, -y);
            }
        }
    }

    public int getIconWidth() {
        return this.fWidth;
    }

    public int getIconHeight() {
        return this.fHeight;
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if ("font".equals(prop)) {
            this.recalcDimensions();
        }
    }

    protected void finalize() throws Throwable {
        this.component.removePropertyChangeListener(this);
        super.finalize();
    }

    public void setText(String text) {
        this.text = text;
        this.recalcDimensions();
    }

    public String getText() {
        return this.text;
    }

    public Component getComponent() {
        return this.component;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public void setUnderlinedIndex(int underlinedIndex) {
        this.underlinedIndex = underlinedIndex;
    }

    protected void recalcDimensions() {
        int wOld = this.getIconWidth();
        int hOld = this.getIconHeight();
        this.calcDimensions();
        if (wOld != this.getIconWidth() || hOld != this.getIconHeight()) {
            this.component.invalidate();
        }
    }

    protected void calcDimensions() {
        FontMetrics fm = this.component.getFontMetrics(this.component.getFont());
        int fCharHeight = fm.getAscent() + fm.getDescent();
        this.fDescent = fm.getDescent();
        if (this.rotation == 1) {
            this.fHeight = fCharHeight;
            this.fWidth = fm.stringWidth(this.text) + 10;
        } else {
            this.fWidth = fCharHeight;
            this.fHeight = fm.stringWidth(this.text) + 10;
        }
    }
}

