/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.look;

import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.noos.common.context.Context;
import org.noos.common.object.ObjectCreator;
import org.noos.common.object.ObjectCustomizer;
import org.noos.xing.mydoggy.plaf.PropertyChangeEventSource;
import org.noos.xing.mydoggy.plaf.ui.ResourceManager;
import org.noos.xing.mydoggy.plaf.ui.transparency.TransparencyManager;
import org.noos.xing.mydoggy.plaf.ui.transparency.WindowTransparencyManager;
import org.noos.xing.mydoggy.plaf.ui.util.DummyResourceBundle;
import org.noos.xing.mydoggy.plaf.ui.util.FindFocusableQuestion;
import org.noos.xing.mydoggy.plaf.ui.util.ParentOfQuestion;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyDoggyResourceManager
extends PropertyChangeEventSource
implements ResourceManager {
    private static final String resourceName = "resources.properties";
    protected ClassLoader classLoader;
    protected Properties resources;
    protected Map<String, ObjectCreator<Component>> cmpCreators;
    protected Map<String, ObjectCreator<ComponentUI>> cmpUiCreators;
    protected Map<String, ObjectCustomizer<Component>> cmpCustomizers;
    protected Map<Class, ObjectCreator> instanceCreators;
    protected String bundlePath;
    protected ResourceBundle resourceBundle;
    protected ResourceBundle userResourceBundle;
    protected TransparencyManager<Window> transparencyManager;

    @Override
    public void setClassloader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.loadResources();
        this.initComponentCreators();
        this.initTransparencyManager();
        UIManager.put(ResourceManager.class, this);
    }

    @Override
    public <T> T createInstance(Class<T> clazz, Context context) {
        return (T)this.instanceCreators.get(clazz).create(context);
    }

    @Override
    public <T extends Component> T createComponent(String key, Context context) {
        return (T)this.applyCustomization(key, this.cmpCreators.get(key).create(context), context);
    }

    @Override
    public ComponentUI createComponentUI(String key, Context context) {
        return this.cmpUiCreators.get(key).create(context);
    }

    @Override
    public <T extends Component> T applyCustomization(String key, T component, Context context) {
        if (this.cmpCustomizers.containsKey(key)) {
            this.cmpCustomizers.get(key).customize(component, context);
        }
        return component;
    }

    @Override
    public Icon getIcon(String id) {
        return UIManager.getIcon(id);
    }

    @Override
    public Icon putIcon(String id, Icon icon) {
        Icon oldIcon = (Icon)UIManager.put(id, icon);
        ArrayList<String> icons = (ArrayList<String>)UIManager.get("mydoggy.icons");
        if (icons == null) {
            icons = new ArrayList<String>();
            UIManager.put("mydoggy.icons", icons);
        }
        icons.add(id);
        return oldIcon;
    }

    @Override
    public Color getColor(String id) {
        return UIManager.getColor(id);
    }

    @Override
    public Color putColor(String id, Color color) {
        Color oldColor = (Color)UIManager.put(id, color);
        ArrayList<String> colors = (ArrayList<String>)UIManager.get("mydoggy.colors");
        if (colors == null) {
            colors = new ArrayList<String>();
            UIManager.put("mydoggy.colors", colors);
        }
        colors.add(id);
        return oldColor;
    }

    public void putImage(String name, BufferedImage bufferedImage) {
        UIManager.put(name, bufferedImage);
    }

    @Override
    public BufferedImage getImage(String id) {
        return (BufferedImage)UIManager.get(id);
    }

    @Override
    public TransparencyManager<Window> getTransparencyManager() {
        return this.transparencyManager;
    }

    @Override
    public void setTransparencyManager(TransparencyManager<Window> transparencyManager) {
        this.transparencyManager = transparencyManager;
        UIManager.put(TransparencyManager.class, transparencyManager);
    }

    @Override
    public void setLocale(Locale locale) {
        if (UIManager.get("mydoggy.resourceBundle") != null) {
            this.resourceBundle = (ResourceBundle)UIManager.get("mydoggy.resourceBundle");
            this.bundlePath = (String)UIManager.get("mydoggy.bundlePath");
        } else {
            this.resourceBundle = this.loadResourceBundle(locale, this.bundlePath);
            UIManager.put("mydoggy.resourceBundle", this.resourceBundle);
            UIManager.put("mydoggy.bundlePath", this.bundlePath);
        }
    }

    @Override
    public void setUserBundle(Locale locale, String bundle, ClassLoader classLoader) {
        this.userResourceBundle = this.loadResourceBundle(locale, bundle, classLoader);
        UIManager.put("mydoggy.resourceBundle.user", this.resourceBundle);
    }

    @Override
    public void setUserBundle(ResourceBundle userBundle) {
        this.userResourceBundle = userBundle == null ? new DummyResourceBundle() : userBundle;
        UIManager.put("mydoggy.resourceBundle.user", this.userResourceBundle);
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    @Override
    public ResourceBundle getUserResourceBundle() {
        return this.userResourceBundle;
    }

    @Override
    public String getString(String key) {
        try {
            return this.resourceBundle.getString(key);
        }
        catch (Exception e) {
            return key;
        }
    }

    @Override
    public String getUserString(String key) {
        try {
            return this.userResourceBundle != null ? this.userResourceBundle.getString(key) : key;
        }
        catch (Exception e) {
            return key;
        }
    }

    @Override
    public List<String> getColors() {
        return (List)UIManager.get("mydoggy.colors");
    }

    @Override
    public List<String> getIcons() {
        return (List)UIManager.get("mydoggy.icons");
    }

    @Override
    public String getProperty(String name) {
        return UIManager.getString(name);
    }

    @Override
    public void putProperty(String name, String value) {
        UIManager.put(name, value);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        return SwingUtil.getBoolean(name, defaultValue);
    }

    @Override
    public void putBoolean(String name, boolean value) {
        UIManager.put(name, value);
    }

    @Override
    public float getFloat(String name, float defaultValue) {
        return SwingUtil.getFloat(name, defaultValue);
    }

    @Override
    public void putFloat(String name, float value) {
        UIManager.put(name, Float.valueOf(value));
    }

    @Override
    public int getInt(String name, int defaultValue) {
        return SwingUtil.getInt(name, defaultValue);
    }

    @Override
    public void putInt(String name, int value) {
        UIManager.put(name, value);
    }

    @Override
    public void putObject(Object key, Object value) {
        UIManager.put(key, value);
    }

    @Override
    public <T> T getObject(Class<T> clazz, T defaultValue) {
        Object value = UIManager.get(clazz);
        if (clazz.isInstance(value)) {
            return (T)value;
        }
        return defaultValue;
    }

    public void putInstanceCreator(Class aClass, ObjectCreator instanceCreator) {
        this.instanceCreators.put(aClass, instanceCreator);
    }

    public void putComponentCreator(String key, ObjectCreator<Component> componentCreator) {
        this.cmpCreators.put(key, componentCreator);
    }

    public void putComponentCustomizer(String key, ObjectCustomizer<Component> componentCustomizer) {
        this.cmpCustomizers.put(key, componentCustomizer);
    }

    public void putComponentUICreator(String key, ObjectCreator<ComponentUI> componentUICreator) {
        this.cmpUiCreators.put(key, componentUICreator);
    }

    protected void loadResources() {
        if (this.isAlreadyLoaded()) {
            return;
        }
        this.resources = SwingUtil.loadPropertiesFile(resourceName, this.classLoader);
        for (Object key : this.resources.keySet()) {
            String strKey = key.toString();
            int pointIndex = strKey.indexOf(46);
            if (pointIndex == -1) continue;
            String prefix = strKey.substring(0, pointIndex);
            String propertyName = strKey.substring(prefix.length() + 1);
            if (UIManager.getDefaults().containsKey(propertyName)) continue;
            this.loadResource(prefix, propertyName, this.resources.getProperty(strKey));
        }
        this.loadObjects();
    }

    protected void loadResource(String prefix, String name, String value) {
        if ("Icon".equals(prefix)) {
            this.loadIcon(name, value);
        } else if ("Color".equals(prefix)) {
            this.loadColor(name, value);
        } else if ("Image".equals(prefix)) {
            this.loadImage(name, value);
        } else if ("ResourceBundle".equals(prefix)) {
            this.loadResourceBundles(value);
        } else if ("Int".equals(prefix)) {
            this.loadInt(name, value);
        } else if ("Float".equals(prefix)) {
            this.loadFloat(name, value);
        } else if ("String".equals(prefix)) {
            this.loadString(name, value);
        } else if ("Boolean".equals(prefix)) {
            this.loadBoolean(name, value);
        }
    }

    protected void loadIcon(String name, String url) {
        this.putIcon(name, new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getUrl(url))));
    }

    protected void loadImage(String name, String url) {
        try {
            this.putImage(name, ImageIO.read(this.getUrl(url)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void loadColor(String name, String colorDef) {
        Color color;
        if ("black".equals(colorDef = colorDef.toLowerCase())) {
            color = Color.BLACK;
        } else if ("blue".equals(colorDef)) {
            color = Color.BLUE;
        } else if ("cyan".equals(colorDef)) {
            color = Color.CYAN;
        } else if ("dark_grey".equals(colorDef)) {
            color = Color.DARK_GRAY;
        } else if ("gray".equals(colorDef)) {
            color = Color.GRAY;
        } else if ("green".equals(colorDef)) {
            color = Color.GREEN;
        } else if ("magenta".equals(colorDef)) {
            color = Color.MAGENTA;
        } else if ("orange".equals(colorDef)) {
            color = Color.ORANGE;
        } else if ("pink".equals(colorDef)) {
            color = Color.PINK;
        } else if ("red".equals(colorDef)) {
            color = Color.RED;
        } else if ("white".equals(colorDef)) {
            color = Color.WHITE;
        } else if ("yellow".equals(colorDef)) {
            color = Color.YELLOW;
        } else {
            String[] elms = colorDef.split(",");
            color = new Color(Integer.parseInt(elms[0].trim()), Integer.parseInt(elms[1].trim()), Integer.parseInt(elms[2].trim()));
        }
        this.putColor(name, color);
    }

    protected void loadInt(String name, String value) {
        try {
            this.putInt(name, Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    protected void loadFloat(String name, String value) {
        try {
            this.putFloat(name, Float.parseFloat(value));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    protected void loadString(String name, String value) {
        this.putProperty(name, value);
    }

    protected void loadResourceBundles(String bundlePath) {
        this.bundlePath = bundlePath;
    }

    protected void loadObjects() {
        this.putObject(FindFocusableQuestion.class, new FindFocusableQuestion());
    }

    protected void loadBoolean(String name, String value) {
        try {
            this.putBoolean(name, Boolean.parseBoolean(value));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    protected boolean isAlreadyLoaded() {
        return UIManager.get(ResourceManager.class) != null;
    }

    protected URL getUrl(String url) {
        URL result = null;
        if (this.classLoader != null) {
            result = this.classLoader.getResource(url);
        }
        if (result == null) {
            result = this.getClass().getClassLoader().getResource(url);
        }
        if (result == null) {
            result = Thread.currentThread().getContextClassLoader().getResource(url);
        }
        if (result == null) {
            result = ClassLoader.getSystemClassLoader().getResource(url);
        }
        return result;
    }

    protected void initComponentCreators() {
        this.cmpCreators = new Hashtable<String, ObjectCreator<Component>>();
        this.cmpUiCreators = new Hashtable<String, ObjectCreator<ComponentUI>>();
        this.cmpCustomizers = new Hashtable<String, ObjectCustomizer<Component>>();
        this.instanceCreators = new Hashtable<Class, ObjectCreator>();
        this.instanceCreators.put(ParentOfQuestion.class, new ParentOfQuestionInstanceCreator());
    }

    protected ResourceBundle loadResourceBundle(Locale locale, String bundle) {
        ResourceBundle result = this.loadResourceBundle(locale, bundle, this.classLoader);
        if (result instanceof DummyResourceBundle) {
            result = this.loadResourceBundle(locale, bundle, this.getClass().getClassLoader());
        }
        if (result instanceof DummyResourceBundle) {
            result = this.loadResourceBundle(locale, bundle, Thread.currentThread().getContextClassLoader());
        }
        if (result instanceof DummyResourceBundle) {
            result = this.loadResourceBundle(locale, bundle, ClassLoader.getSystemClassLoader());
        }
        return result;
    }

    protected ResourceBundle loadResourceBundle(Locale locale, String bundle, ClassLoader classLoader) {
        ResourceBundle result;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            result = classLoader == null ? ResourceBundle.getBundle(bundle, locale) : ResourceBundle.getBundle(bundle, locale, classLoader);
        }
        catch (Throwable e) {
            e.printStackTrace();
            result = new DummyResourceBundle();
        }
        return result;
    }

    protected void initTransparencyManager() {
        if (this.isAlreadyLoaded()) {
            return;
        }
        this.setTransparencyManager(new WindowTransparencyManager());
    }

    public static class ParentOfQuestionInstanceCreator
    implements ObjectCreator {
        public Object create(Context context) {
            return new ParentOfQuestion(context.get(Component.class));
        }
    }
}

