/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.viewer2d;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.media.jai.PlanarImage;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import org.weasis.core.api.explorer.DataExplorerView;
import org.weasis.core.api.explorer.model.DataExplorerModel;
import org.weasis.core.api.gui.util.ActionState;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.gui.util.ComboItemListener;
import org.weasis.core.api.gui.util.MouseActionAdapter;
import org.weasis.core.api.gui.util.SliderChangeListener;
import org.weasis.core.api.gui.util.ToggleButtonListener;
import org.weasis.core.api.image.FilterOperation;
import org.weasis.core.api.image.FlipOperation;
import org.weasis.core.api.image.ImageOperationAction;
import org.weasis.core.api.image.OperationsManager;
import org.weasis.core.api.image.PseudoColorOperation;
import org.weasis.core.api.image.RotationOperation;
import org.weasis.core.api.image.WindowLevelOperation;
import org.weasis.core.api.image.ZoomOperation;
import org.weasis.core.api.image.util.ImageLayer;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.api.media.data.MediaSeries;
import org.weasis.core.api.media.data.MediaSeriesGroup;
import org.weasis.core.api.media.data.Series;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.api.media.data.Thumbnail;
import org.weasis.core.ui.docking.UIManager;
import org.weasis.core.ui.editor.SeriesViewer;
import org.weasis.core.ui.editor.SeriesViewerFactory;
import org.weasis.core.ui.editor.image.CalibrationView;
import org.weasis.core.ui.editor.image.DefaultView2d;
import org.weasis.core.ui.editor.image.ImageViewerEventManager;
import org.weasis.core.ui.editor.image.ImageViewerPlugin;
import org.weasis.core.ui.editor.image.MouseActions;
import org.weasis.core.ui.editor.image.PannerListener;
import org.weasis.core.ui.editor.image.SynchView;
import org.weasis.core.ui.editor.image.ViewerPlugin;
import org.weasis.core.ui.editor.image.ViewerToolBar;
import org.weasis.core.ui.graphic.DragLayer;
import org.weasis.core.ui.graphic.Graphic;
import org.weasis.core.ui.graphic.LineGraphic;
import org.weasis.core.ui.graphic.PolygonGraphic;
import org.weasis.core.ui.graphic.RenderedImageLayer;
import org.weasis.core.ui.graphic.TempLayer;
import org.weasis.core.ui.graphic.model.AbstractLayer;
import org.weasis.core.ui.graphic.model.AbstractLayerModel;
import org.weasis.core.ui.graphic.model.LayerModel;
import org.weasis.core.ui.graphic.model.Tools;
import org.weasis.core.ui.util.UriListFlavor;
import org.weasis.dicom.codec.DicomEncapDocSeries;
import org.weasis.dicom.codec.DicomImageElement;
import org.weasis.dicom.codec.DicomSeries;
import org.weasis.dicom.codec.DicomVideoSeries;
import org.weasis.dicom.codec.SortSeriesStack;
import org.weasis.dicom.codec.display.Modality;
import org.weasis.dicom.codec.display.OverlayOperation;
import org.weasis.dicom.codec.display.PresetWindowLevel;
import org.weasis.dicom.codec.geometry.GeometryOfSlice;
import org.weasis.dicom.codec.geometry.IntersectSlice;
import org.weasis.dicom.codec.geometry.LocalizerPoster;
import org.weasis.dicom.explorer.DicomExplorer;
import org.weasis.dicom.explorer.DicomModel;
import org.weasis.dicom.explorer.LoadLocalDicom;
import org.weasis.dicom.explorer.MimeSystemAppFactory;
import org.weasis.dicom.explorer.wado.LoadSeries;
import org.weasis.dicom.viewer2d.EventManager;
import org.weasis.dicom.viewer2d.InfoLayer;
import org.weasis.dicom.viewer2d.Messages;
import org.weasis.dicom.viewer2d.ResetTools;
import org.weasis.dicom.viewer2d.View2dContainer;

public class View2d
extends DefaultView2d<DicomImageElement> {
    private final Dimension oldSize;
    private final ContextMenuHandler contextMenuHandler = new ContextMenuHandler();

    public View2d(ImageViewerEventManager<DicomImageElement> eventManager) {
        super(eventManager);
        OperationsManager manager = this.imageLayer.getOperationsManager();
        manager.addImageOperationAction((ImageOperationAction)new WindowLevelOperation());
        manager.addImageOperationAction((ImageOperationAction)new OverlayOperation());
        manager.addImageOperationAction((ImageOperationAction)new FlipOperation());
        manager.addImageOperationAction((ImageOperationAction)new FilterOperation());
        manager.addImageOperationAction((ImageOperationAction)new PseudoColorOperation());
        manager.addImageOperationAction((ImageOperationAction)new ZoomOperation());
        manager.addImageOperationAction((ImageOperationAction)new RotationOperation());
        this.infoLayer = new InfoLayer(this);
        DragLayer layer = new DragLayer((LayerModel)this.getLayerModel(), Tools.MEASURE.getId());
        this.getLayerModel().addLayer((AbstractLayer)layer);
        layer = new DragLayer((LayerModel)this.getLayerModel(), Tools.CROSSLINES.getId());
        this.getLayerModel().addLayer((AbstractLayer)layer);
        TempLayer layerTmp = new TempLayer((LayerModel)this.getLayerModel());
        this.getLayerModel().addLayer((AbstractLayer)layerTmp);
        this.oldSize = new Dimension(0, 0);
    }

    public void registerDefaultListeners() {
        super.registerDefaultListeners();
        this.setTransferHandler(new SequenceHandler());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Double currentZoom = (Double)View2d.this.actionsInView.get(ActionW.ZOOM.cmd());
                if (currentZoom <= 0.0) {
                    View2d.this.zoom(0.0);
                }
                View2d.this.center();
                if (View2d.this.lens != null) {
                    View2d.this.lens.updateZoom();
                    int w = View2d.this.getWidth();
                    int h = View2d.this.getHeight();
                    if (w != 0 && h != 0) {
                        Rectangle bound = View2d.this.lens.getBounds();
                        if (((View2d)View2d.this).oldSize.width != 0 && ((View2d)View2d.this).oldSize.height != 0) {
                            int centerx = bound.width / 2;
                            int centery = bound.height / 2;
                            bound.x = (bound.x + centerx) * w / ((View2d)View2d.this).oldSize.width - centerx;
                            bound.y = (bound.y + centery) * h / ((View2d)View2d.this).oldSize.height - centery;
                            View2d.this.lens.setLocation(bound.x, bound.y);
                        }
                        ((View2d)View2d.this).oldSize.width = w;
                        ((View2d)View2d.this).oldSize.height = h;
                    }
                }
            }
        });
    }

    protected void initActionWState() {
        super.initActionWState();
        this.actionsInView.put(ActionW.PRESET.cmd(), PresetWindowLevel.DEFAULT);
        this.actionsInView.put(ActionW.SORTSTACK.cmd(), SortSeriesStack.instanceNumber);
        this.actionsInView.put(ActionW.IMAGE_OVERLAY.cmd(), true);
        this.actionsInView.put(ActionW.VIEWINGPROTOCOL.cmd(), Modality.ImageModality);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (this.series == null) {
            return;
        }
        if (evt.getPropertyName().equals(ActionW.PRESET.cmd())) {
            this.actionsInView.put(ActionW.PRESET.cmd(), evt.getNewValue());
        } else if (evt.getPropertyName().equals(ActionW.IMAGE_OVERLAY.cmd())) {
            this.actionsInView.put(ActionW.IMAGE_OVERLAY.cmd(), evt.getNewValue());
            this.imageLayer.updateImageOperation(OverlayOperation.name);
        } else if (evt.getPropertyName().equals(ActionW.SORTSTACK.cmd())) {
            this.actionsInView.put(ActionW.SORTSTACK.cmd(), evt.getNewValue());
            this.sortStack();
        } else if (evt.getPropertyName().equals(ActionW.VIEWINGPROTOCOL.cmd())) {
            this.actionsInView.put(ActionW.VIEWINGPROTOCOL.cmd(), evt.getNewValue());
            this.repaint();
        } else if (evt.getPropertyName().equals(ActionW.INVERSESTACK.cmd())) {
            this.actionsInView.put(ActionW.INVERSESTACK.cmd(), evt.getNewValue());
            this.sortStack();
        }
    }

    public void setSeries(MediaSeries<DicomImageElement> series, int defaultIndex) {
        MediaSeries oldsequence = this.series;
        this.series = series;
        if (oldsequence != null && oldsequence != series) {
            this.closingSeries(oldsequence);
        }
        if (series == null) {
            this.imageLayer.setImage(null);
            this.getLayerModel().deleteAllGraphics();
            this.closeLens();
        } else {
            defaultIndex = defaultIndex < 0 || defaultIndex >= series.size() ? 0 : defaultIndex;
            this.frameIndex = defaultIndex + this.tileOffset;
            this.actionsInView.put(ActionW.PRESET.cmd(), PresetWindowLevel.DEFAULT);
            this.setImage((ImageElement)series.getMedia(this.frameIndex), true);
            Double val = (Double)this.actionsInView.get(ActionW.ZOOM.cmd());
            this.zoom(val == null ? 1.0 : val);
            this.center();
        }
        this.eventManager.updateComponentsListener((DefaultView2d)this);
        if (series != null && oldsequence != series) {
            series.setOpen(true);
        }
    }

    protected void setWindowLevel(DicomImageElement img) {
        if (PresetWindowLevel.DEFAULT.equals(this.actionsInView.get(ActionW.PRESET.cmd()))) {
            this.actionsInView.put(ActionW.WINDOW.cmd(), Float.valueOf(img.getDefaultWindow()));
            this.actionsInView.put(ActionW.LEVEL.cmd(), Float.valueOf(img.getDefaultLevel()));
        } else if (PresetWindowLevel.AUTO.equals(this.actionsInView.get(ActionW.PRESET.cmd()))) {
            float min = img.getMinValue();
            float max = img.getMaxValue();
            this.actionsInView.put(ActionW.WINDOW.cmd(), Float.valueOf(max - min));
            this.actionsInView.put(ActionW.LEVEL.cmd(), Float.valueOf((max - min) / 2.0f + min));
        }
    }

    protected void sortStack() {
        Comparator sortComparator = (Comparator)this.actionsInView.get(ActionW.SORTSTACK.cmd());
        if (sortComparator != null) {
            this.series.sort((Boolean)this.actionsInView.get(ActionW.INVERSESTACK.cmd()) != false ? Collections.reverseOrder(sortComparator) : sortComparator);
            Double val = (Double)this.actionsInView.get(ActionW.ZOOM.cmd());
            boolean rescaleView = val == null || val <= 0.0;
            this.setImage((ImageElement)this.series.getMedia(this.frameIndex), rescaleView);
            if (rescaleView) {
                val = (Double)this.actionsInView.get(ActionW.ZOOM.cmd());
                this.zoom(val == null ? 1.0 : val);
                this.center();
            }
        }
    }

    protected void computeCrosslines(double location) {
        MediaSeries selSeries;
        DefaultView2d view2DPane = this.eventManager.getSelectedViewPane();
        MediaSeries mediaSeries = selSeries = view2DPane == null ? null : view2DPane.getSeries();
        if (selSeries != null) {
            GeometryOfSlice sliceGeometry;
            DicomImageElement image;
            DicomImageElement selImage = (DicomImageElement)selSeries.getMedia(selSeries.getNearestIndex(location));
            ArrayList list = new ArrayList(selSeries.getMedias());
            DicomImageElement firstImage = null;
            DicomImageElement lastImage = null;
            if (list.size() > 2) {
                double min = Double.MAX_VALUE;
                double max = -1.7976931348623157E308;
                for (DicomImageElement dcm : list) {
                    double[] loc = (double[])dcm.getTagValue(TagW.SlicePosition);
                    if (loc == null) continue;
                    double position = loc[0] + loc[1] + loc[2];
                    if (min > position) {
                        min = position;
                        firstImage = dcm;
                    }
                    if (!(max < position)) continue;
                    max = position;
                    lastImage = dcm;
                }
                if (firstImage == null) {
                    firstImage = (DicomImageElement)list.get(0);
                    lastImage = (DicomImageElement)list.get(list.size() - 1);
                }
            }
            if ((image = (DicomImageElement)this.getImage()) != null && (sliceGeometry = image.getSliceGeometry()) != null) {
                IntersectSlice slice = new IntersectSlice(sliceGeometry);
                if (firstImage != null) {
                    this.addCrossline(firstImage, (LocalizerPoster)slice, false);
                }
                if (lastImage != null) {
                    this.addCrossline(lastImage, (LocalizerPoster)slice, false);
                }
                if (selImage != null) {
                    this.addCrossline(selImage, (LocalizerPoster)slice, true);
                }
                this.repaint();
            }
        }
    }

    private void addCrossline(DicomImageElement selImage, LocalizerPoster localizer, boolean fill) {
        float[] xyCoord;
        GeometryOfSlice sliceGeometry = selImage.getSliceGeometry();
        if (sliceGeometry != null && (xyCoord = localizer.getOutlineOnLocalizerForThisGeometry(sliceGeometry)) != null) {
            Color color = fill ? Color.blue : Color.cyan;
            PolygonGraphic graphic = new PolygonGraphic(xyCoord, 1.0f, color, fill, true);
            AbstractLayer layer = this.getLayerModel().getLayer(Tools.CROSSLINES.getId());
            if (layer != null) {
                layer.addGraphic((Graphic)graphic);
            }
        }
    }

    public synchronized void enableMouseAndKeyListener(MouseActions actions) {
        MouseActionAdapter adapter;
        this.disableMouseAndKeyListener();
        this.iniDefaultMouseListener();
        this.iniDefaultKeyListener();
        this.resetMouseAdapter();
        this.setCursor(AbstractLayerModel.DEFAULT_CURSOR);
        this.addMouseAdapter(actions.getLeft(), 1024);
        if (actions.getMiddle().equals(actions.getLeft())) {
            adapter = this.getMouseAdapter(actions.getMiddle());
            adapter.setButtonMaskEx(adapter.getButtonMaskEx() | 0x800);
        } else {
            this.addMouseAdapter(actions.getMiddle(), 2048);
        }
        if (actions.getRight().equals(actions.getLeft()) || actions.getRight().equals(actions.getMiddle())) {
            adapter = this.getMouseAdapter(actions.getRight());
            adapter.setButtonMaskEx(adapter.getButtonMaskEx() | 0x1000);
        } else {
            this.addMouseAdapter(actions.getRight(), 4096);
        }
        this.addMouseWheelListener((MouseWheelListener)this.getMouseAdapter(actions.getWheel()));
        if (this.lens != null) {
            this.lens.enableMouseListener();
        }
    }

    private void addMouseAdapter(String actionName, int buttonMask) {
        MouseActionAdapter adapter = this.getMouseAdapter(actionName);
        if (adapter == null) {
            return;
        }
        adapter.setButtonMaskEx(adapter.getButtonMaskEx() | buttonMask);
        if (adapter == this.mouseClickHandler) {
            this.addKeyListener((KeyListener)this.drawingsKeyListeners);
        } else if (adapter instanceof PannerListener) {
            ((PannerListener)adapter).reset();
            this.addKeyListener((KeyListener)((PannerListener)adapter));
        }
        if (actionName.equals(ActionW.WINLEVEL.cmd())) {
            MouseActionAdapter win = this.getAction(ActionW.WINDOW);
            if (win != null) {
                win.setButtonMaskEx(win.getButtonMaskEx() | buttonMask);
                win.setMoveOnX(true);
                this.addMouseListener((MouseListener)win);
                this.addMouseMotionListener((MouseMotionListener)win);
            }
            adapter.setInverse(true);
        } else if (actionName.equals(ActionW.WINDOW.cmd())) {
            adapter.setMoveOnX(false);
        } else if (actionName.equals(ActionW.LEVEL.cmd())) {
            adapter.setInverse(true);
        }
        this.addMouseListener((MouseListener)adapter);
        this.addMouseMotionListener((MouseMotionListener)adapter);
    }

    private MouseActionAdapter getMouseAdapter(String action) {
        if (action.equals(ActionW.MEASURE.cmd())) {
            return this.mouseClickHandler;
        }
        if (action.equals(ActionW.PAN.cmd())) {
            return this.getAction(ActionW.PAN);
        }
        if (action.equals(ActionW.CONTEXTMENU.cmd())) {
            return this.contextMenuHandler;
        }
        if (action.equals(ActionW.WINDOW.cmd())) {
            return this.getAction(ActionW.WINDOW);
        }
        if (action.equals(ActionW.LEVEL.cmd())) {
            return this.getAction(ActionW.LEVEL);
        }
        if (action.equals(ActionW.WINLEVEL.cmd())) {
            return this.getAction(ActionW.LEVEL);
        }
        if (action.equals(ActionW.SCROLL_SERIES.cmd())) {
            return this.getAction(ActionW.SCROLL_SERIES);
        }
        if (action.equals(ActionW.ZOOM.cmd())) {
            return this.getAction(ActionW.ZOOM);
        }
        if (action.equals(ActionW.ROTATION.cmd())) {
            return this.getAction(ActionW.ROTATION);
        }
        return null;
    }

    private void resetMouseAdapter() {
        for (ActionState adapter : this.eventManager.getAllActionValues()) {
            if (!(adapter instanceof MouseActionAdapter)) continue;
            ((MouseActionAdapter)adapter).setButtonMaskEx(0);
        }
        this.contextMenuHandler.setButtonMaskEx(0);
        this.mouseClickHandler.setButtonMaskEx(0);
    }

    private MouseActionAdapter getAction(ActionW action) {
        ActionState a = this.eventManager.getAction(action);
        if (a instanceof MouseActionAdapter) {
            return (MouseActionAdapter)a;
        }
        return null;
    }

    public String getPixelInfo(Point p, RenderedImageLayer<DicomImageElement> imageLayer) {
        DicomImageElement dicom = (DicomImageElement)imageLayer.getSourceImage();
        StringBuffer message = new StringBuffer();
        if (dicom != null && imageLayer.getReadIterator() != null) {
            PlanarImage image = dicom.getImage();
            Point realPoint = new Point((int)Math.ceil((double)p.x / dicom.getRescaleX() - 0.5), (int)Math.ceil((double)p.y / dicom.getRescaleY() - 0.5));
            if (image != null && realPoint.x >= 0 && realPoint.y >= 0 && realPoint.x < image.getWidth() && realPoint.y < image.getHeight()) {
                try {
                    int[] c = new int[]{0, 0, 0};
                    imageLayer.getReadIterator().getPixel(realPoint.x, realPoint.y, c);
                    if (image.getSampleModel().getNumBands() == 1) {
                        float val = dicom.pixel2rescale((float)c[0]);
                        message.append((int)val);
                        if (dicom.getPixelValueUnit() != null) {
                            message.append(" " + dicom.getPixelValueUnit());
                        }
                    } else {
                        message.append("R=" + c[0] + " G=" + c[1] + " B=" + c[2]);
                    }
                    message.append(" - (" + p.x + "," + p.y + ")");
                }
                catch (ArrayIndexOutOfBoundsException ex) {}
            } else {
                message.append(Messages.getString("View2d.out_img"));
            }
        }
        return message.toString();
    }

    public void handleLayerChanged(ImageLayer layer) {
        this.repaint();
    }

    public void focusGained(FocusEvent e) {
        ImageViewerPlugin pane;
        if (!e.isTemporary() && (pane = this.eventManager.getSelectedView2dContainer()) != null && pane.isContainingView((DefaultView2d)this)) {
            pane.setSelectedImagePaneFromFocus((DefaultView2d)this);
        }
    }

    class ContextMenuHandler
    extends MouseActionAdapter {
        ContextMenuHandler() {
        }

        public void mousePressed(MouseEvent mouseevent) {
            int buttonMask = this.getButtonMaskEx();
            if ((mouseevent.getModifiersEx() & buttonMask) != 0 && View2d.this.getSourceImage() != null) {
                Graphic graph;
                ArrayList sel;
                AbstractLayer layer;
                ActionState rotateAction;
                ActionState stackAction;
                ActionState presetAction;
                ViewerToolBar toolBar;
                JPopupMenu popupMenu = new JPopupMenu();
                final EventManager event = EventManager.getInstance();
                JMenuItem item = new JMenuItem(Messages.getString("View2d.left_mouse"));
                Font font = item.getFont();
                item.setFont(new Font(font.getFamily(), 1, font.getSize()));
                item.setFocusable(false);
                popupMenu.add(item);
                popupMenu.setLabel("left");
                String action = event.getMouseActions().getLeft();
                ActionW[] actionsButtons = ViewerToolBar.actionsButtons;
                ButtonGroup groupButtons = new ButtonGroup();
                ImageViewerPlugin view = View2d.this.eventManager.getSelectedView2dContainer();
                if (view != null && (toolBar = view.getViewerToolBar()) != null) {
                    ActionListener leftButtonAction = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (e.getSource() instanceof JRadioButtonMenuItem) {
                                JRadioButtonMenuItem item = (JRadioButtonMenuItem)e.getSource();
                                toolBar.changeButtonState("left", item.getActionCommand());
                            }
                        }
                    };
                    for (int i = 0; i < actionsButtons.length; ++i) {
                        ActionW actionW = actionsButtons[i];
                        JRadioButtonMenuItem radio = new JRadioButtonMenuItem(actionW.getTitle(), actionW.getIcon(), actionW.cmd().equals(action));
                        radio.setActionCommand(actionW.cmd());
                        radio.setAccelerator(KeyStroke.getKeyStroke(actionW.getKeyCode(), actionW.getModifier()));
                        radio.addActionListener((ActionListener)toolBar);
                        radio.addActionListener(leftButtonAction);
                        popupMenu.add(radio);
                        groupButtons.add(radio);
                    }
                }
                popupMenu.add(new JSeparator());
                ActionState viewingAction = View2d.this.eventManager.getAction(ActionW.VIEWINGPROTOCOL);
                if (viewingAction instanceof ComboItemListener) {
                    popupMenu.add(((ComboItemListener)viewingAction).createUnregisteredRadioMenu(Messages.getString("View2dContainer.view_protocols")));
                }
                if ((presetAction = View2d.this.eventManager.getAction(ActionW.PRESET)) instanceof ComboItemListener) {
                    popupMenu.add(((ComboItemListener)presetAction).createUnregisteredRadioMenu(Messages.getString("View2dContainer.presets")));
                }
                if ((stackAction = View2d.this.eventManager.getAction(ActionW.SORTSTACK)) instanceof ComboItemListener) {
                    JMenu menu = ((ComboItemListener)stackAction).createUnregisteredRadioMenu(Messages.getString("View2dContainer.sort_stack"));
                    ActionState invstackAction = View2d.this.eventManager.getAction(ActionW.INVERSESTACK);
                    if (invstackAction instanceof ToggleButtonListener) {
                        menu.add(new JSeparator());
                        menu.add(((ToggleButtonListener)invstackAction).createUnregiteredJCheckBoxMenuItem(Messages.getString("View2dContainer.inv_stack")));
                    }
                    popupMenu.add(menu);
                }
                if ((rotateAction = View2d.this.eventManager.getAction(ActionW.ROTATION)) instanceof SliderChangeListener) {
                    popupMenu.add(new JSeparator());
                    JMenu menu = new JMenu(Messages.getString("View2dContainer.orientation"));
                    JMenuItem menuItem = new JMenuItem(Messages.getString("ResetTools.reset"));
                    final SliderChangeListener rotation = (SliderChangeListener)rotateAction;
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            rotation.setValue(0);
                        }
                    });
                    menu.add(menuItem);
                    menuItem = new JMenuItem(Messages.getString("View2dContainer.-90"));
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            rotation.setValue((rotation.getValue() - 90 + 360) % 360);
                        }
                    });
                    menu.add(menuItem);
                    menuItem = new JMenuItem(Messages.getString("View2dContainer.+90"));
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            rotation.setValue((rotation.getValue() + 90) % 360);
                        }
                    });
                    menu.add(menuItem);
                    menuItem = new JMenuItem(Messages.getString("View2dContainer.+180"));
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            rotation.setValue((rotation.getValue() + 180) % 360);
                        }
                    });
                    menu.add(menuItem);
                    ActionState flipAction = View2d.this.eventManager.getAction(ActionW.FLIP);
                    if (flipAction instanceof ToggleButtonListener) {
                        menu.add(new JSeparator());
                        menu.add(((ToggleButtonListener)flipAction).createUnregiteredJCheckBoxMenuItem(Messages.getString("View2dContainer.flip_h")));
                    }
                    popupMenu.add(menu);
                }
                if ((layer = View2d.this.getLayerModel().getLayer(Tools.MEASURE.getId())) != null && (sel = layer.getShowDrawing().getSelectedGraphics()).size() == 1 && (graph = (Graphic)sel.get(0)) instanceof LineGraphic) {
                    popupMenu.add(new JSeparator());
                    final JMenuItem calibMenu = new JMenuItem("Change Spatial Calibration");
                    calibMenu.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            CalibrationView calibrationDialog = new CalibrationView((LineGraphic)graph, (DefaultView2d)View2d.this);
                            String title = Messages.getString("View2d.clibration");
                            int res = JOptionPane.showConfirmDialog(calibMenu, calibrationDialog, title, 2);
                            if (res == 0) {
                                calibrationDialog.applyNewCalibration();
                            }
                        }
                    });
                    popupMenu.add(calibMenu);
                }
                popupMenu.add(new JSeparator());
                popupMenu.add(ResetTools.createUnregisteredJMenu());
                JMenuItem close = new JMenuItem(Messages.getString("View2d.close"));
                close.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        event.getSelectedView2dContainer();
                        View2d.this.setSeries(null, -1);
                    }
                });
                popupMenu.add(close);
                popupMenu.show(mouseevent.getComponent(), mouseevent.getX() - 5, mouseevent.getY() - 5);
            }
        }
    }

    private class SequenceHandler
    extends TransferHandler {
        public SequenceHandler() {
            super("series");
        }

        @Override
        public Transferable createTransferable(JComponent comp) {
            MediaSeries t;
            if (comp instanceof Thumbnail && (t = ((Thumbnail)comp).getSeries()) instanceof Series) {
                return t;
            }
            return null;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDrop()) {
                return false;
            }
            return support.isDataFlavorSupported(Series.sequenceDataFlavor) || support.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || support.isDataFlavorSupported(UriListFlavor.uriListFlavor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            Series seq;
            block21: {
                if (!this.canImport(support)) {
                    return false;
                }
                DataExplorerView dicomView = UIManager.getExplorerplugin((String)DicomExplorer.NAME);
                if (dicomView == null) {
                    return false;
                }
                DicomModel model = (DicomModel)dicomView.getDataExplorerModel();
                Transferable transferable = support.getTransferable();
                List files = null;
                if (support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    try {
                        files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return this.dropDicomFiles(files, model);
                }
                if (support.isDataFlavorSupported(UriListFlavor.uriListFlavor)) {
                    try {
                        String val = (String)transferable.getTransferData(UriListFlavor.uriListFlavor);
                        files = UriListFlavor.textURIListToFileList((String)val);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return this.dropDicomFiles(files, model);
                }
                try {
                    seq = (Series)transferable.getTransferData(Series.sequenceDataFlavor);
                    if (seq instanceof DicomSeries) {
                        MediaSeriesGroup p1 = model.getParent((MediaSeriesGroup)seq, DicomModel.patient);
                        MediaSeriesGroup p2 = null;
                        ViewerPlugin openPlugin = null;
                        List list = UIManager.VIEWER_PLUGINS;
                        synchronized (list) {
                            block9: for (ViewerPlugin p : UIManager.VIEWER_PLUGINS) {
                                if (!(p instanceof View2dContainer)) continue;
                                for (MediaSeries s : p.getOpenSeries()) {
                                    p2 = model.getParent((MediaSeriesGroup)s, DicomModel.patient);
                                    if (!p1.equals(p2)) continue;
                                    if (((View2dContainer)p).isContainingView(View2d.this)) break block9;
                                    openPlugin = p;
                                    break block9;
                                }
                            }
                        }
                        if (!p1.equals(p2)) {
                            SeriesViewerFactory plugin = UIManager.getViewerFactory((SeriesViewer)View2d.this.eventManager.getSelectedView2dContainer());
                            if (plugin != null && !(plugin instanceof MimeSystemAppFactory)) {
                                LoadSeries.openSequenceInPlugin((SeriesViewerFactory)plugin, (Series[])new Series[]{seq}, (DicomModel)model);
                            }
                            return false;
                        }
                        if (openPlugin != null) {
                            openPlugin.setSelectedAndGetFocus();
                            openPlugin.addSeries((MediaSeries)seq);
                            openPlugin.setSelected(true);
                            return false;
                        }
                        break block21;
                    }
                    if (seq instanceof DicomEncapDocSeries || seq instanceof DicomVideoSeries) {
                        LoadSeries.openSequenceInDefaultPlugin((Series[])new Series[]{seq}, (DicomModel)model);
                        return true;
                    }
                }
                catch (Exception e) {
                    return false;
                }
            }
            ImageViewerPlugin pane = EventManager.getInstance().getSelectedView2dContainer();
            if (SynchView.Mode.Tile.equals((Object)pane.getSynchView().getMode())) {
                pane.addSeries((MediaSeries)seq);
                return true;
            }
            View2d.this.setSeries((MediaSeries)seq);
            View2d.this.requestFocusInWindow();
            return true;
        }

        private boolean dropDicomFiles(List<File> files, DicomModel model) {
            if (files != null) {
                LoadLocalDicom dicom = new LoadLocalDicom(files.toArray(new File[files.size()]), true, (DataExplorerModel)model, false);
                DicomModel.loadingExecutor.execute((Runnable)dicom);
                return true;
            }
            return false;
        }
    }
}

