/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.noos.common.Question;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.support.CleanablePropertyChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyChangeEventSource
implements Cleaner {
    protected CleanablePropertyChangeSupport publicChangeSupport;
    protected CleanablePropertyChangeSupport plafChangeSupport;
    protected Question<Object, Boolean> firePublicEventQuestion;
    protected boolean publicEvent = true;

    protected PropertyChangeEventSource() {
    }

    public PropertyChangeEventSource(Question<Object, Boolean> firePublicEventQuestion) {
        this();
        this.firePublicEventQuestion = firePublicEventQuestion;
    }

    @Override
    public void cleanup() {
        if (this.publicChangeSupport != null) {
            this.publicChangeSupport.cleanup();
        }
        this.publicChangeSupport = null;
        if (this.plafChangeSupport != null) {
            this.plafChangeSupport.cleanup();
        }
        this.plafChangeSupport = null;
        this.firePublicEventQuestion = null;
    }

    protected CleanablePropertyChangeSupport initPropertyChangeSupport() {
        return new CleanablePropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.publicChangeSupport == null) {
            this.publicChangeSupport = this.initPropertyChangeSupport();
        }
        this.publicChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener, String ... excludeProperties) {
        if (listener == null) {
            return;
        }
        if (this.publicChangeSupport == null) {
            this.publicChangeSupport = this.initPropertyChangeSupport();
        }
        if (excludeProperties != null && excludeProperties.length > 0) {
            listener = new ExcludePropertyChangeListener(listener, excludeProperties);
        }
        this.publicChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.publicChangeSupport == null) {
            this.publicChangeSupport = this.initPropertyChangeSupport();
        }
        this.publicChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void addPlafPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.plafChangeSupport == null) {
            this.plafChangeSupport = this.initPropertyChangeSupport();
        }
        this.plafChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPlafPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.plafChangeSupport == null) {
            this.plafChangeSupport = this.initPropertyChangeSupport();
        }
        this.plafChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void addPlafPropertyChangeListener(PropertyChangeListener listener, String ... propertyNames) {
        for (String propertyName : propertyNames) {
            this.addPlafPropertyChangeListener(propertyName, listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.publicChangeSupport == null) {
            return;
        }
        this.publicChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null || this.publicChangeSupport == null) {
            return;
        }
        this.publicChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void removePlafPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.plafChangeSupport == null) {
            return;
        }
        this.plafChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePlafPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null || this.plafChangeSupport == null) {
            return;
        }
        this.plafChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void removePlafPropertyChangeListener(PropertyChangeListener listener, String ... propertyNames) {
        for (String propertyName : propertyNames) {
            this.removePlafPropertyChangeListener(propertyName, listener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.publicChangeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.publicChangeSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        if (this.publicChangeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.publicChangeSupport.getPropertyChangeListeners(propertyName);
    }

    public PropertyChangeListener[] getPlafPropertyChangeListeners() {
        if (this.plafChangeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.plafChangeSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPlafPropertyChangeListeners(String propertyName) {
        if (this.plafChangeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.plafChangeSupport.getPropertyChangeListeners(propertyName);
    }

    protected void firePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.plafChangeSupport != null) {
            this.plafChangeSupport.firePropertyChange(event);
        }
        if (this.canFirePublicEvent()) {
            this.publicChangeSupport.firePropertyChange(event);
        }
    }

    protected void firePropertyChangeEvent(String property, Object oldValue, Object newValue) {
        if (this.plafChangeSupport != null) {
            this.plafChangeSupport.firePropertyChange(property, oldValue, newValue);
        }
        if (this.canFirePublicEvent()) {
            this.publicChangeSupport.firePropertyChange(property, oldValue, newValue);
        }
    }

    protected void firePropertyChangeEvent(String property, Object oldValue, Object newValue, Object userObject) {
        if (this.plafChangeSupport != null) {
            this.plafChangeSupport.firePropertyChange(property, oldValue, newValue, userObject);
        }
        if (this.canFirePublicEvent()) {
            this.publicChangeSupport.firePropertyChange(property, oldValue, newValue, userObject);
        }
    }

    protected void firePlafPropertyChangeEvent(PropertyChangeEvent event) {
        if (this.plafChangeSupport != null) {
            this.plafChangeSupport.firePropertyChange(event);
        }
    }

    protected void firePlafPropertyChangeEvent(String property, Object oldValue, Object newValue) {
        if (this.plafChangeSupport != null) {
            this.plafChangeSupport.firePropertyChange(property, oldValue, newValue);
        }
    }

    protected void firePropertyChangeEvent(PropertyChangeEvent event, PropertyChangeEvent pblEvent) {
        if (this.plafChangeSupport != null && event != null) {
            this.plafChangeSupport.firePropertyChange(event);
        }
        if (this.canFirePublicEvent()) {
            this.publicChangeSupport.firePropertyChange(pblEvent);
        }
    }

    protected void firePropertyChangeEventPublicListenerOnly(String property, Object oldValue, Object newValue) {
        if (this.canFirePublicEvent()) {
            this.publicChangeSupport.firePropertyChange(property, oldValue, newValue);
        }
    }

    private final boolean canFirePublicEvent() {
        return this.publicEvent && this.publicChangeSupport != null && (this.firePublicEventQuestion == null || this.firePublicEventQuestion != null && this.firePublicEventQuestion.getAnswer(null) != false);
    }

    public class ExcludePropertyChangeListener
    implements PropertyChangeListener {
        protected PropertyChangeListener delegate;
        protected Set<String> excludePropertiesSet;

        public ExcludePropertyChangeListener(PropertyChangeListener delegate, String ... excludeProperties) {
            this.delegate = delegate;
            this.excludePropertiesSet = new HashSet<String>(Arrays.asList(excludeProperties));
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!this.excludePropertiesSet.contains(evt.getPropertyName())) {
                this.delegate.propertyChange(evt);
            }
        }
    }
}

