/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.support;

import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.support.UserPropertyChangeEvent;

public class CleanablePropertyChangeSupport
implements Serializable,
Cleaner {
    protected Hashtable<String, CleanablePropertyChangeSupport> children;
    protected Object source;
    protected List<PropertyChangeListener> listeners;

    public CleanablePropertyChangeSupport(Object sourceBean) {
        if (sourceBean == null) {
            throw new NullPointerException();
        }
        this.source = sourceBean;
    }

    public void cleanup() {
        for (PropertyChangeListener listener : this.getPropertyChangeListeners()) {
            this.removePropertyChangeListener(listener);
        }
        if (this.children != null) {
            for (String property : this.children.keySet()) {
                this.children.get(property).cleanup();
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (listener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
            this.addPropertyChangeListener(proxy.getPropertyName(), (PropertyChangeListener)proxy.getListener());
        } else {
            if (this.listeners == null) {
                this.listeners = new ArrayList<PropertyChangeListener>();
            }
            this.listeners.add(listener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        ArrayList<PropertyChangeListener> returnList = new ArrayList<PropertyChangeListener>();
        if (this.listeners != null) {
            returnList.addAll(this.listeners);
        }
        if (this.children != null) {
            for (String key : this.children.keySet()) {
                CleanablePropertyChangeSupport child = this.children.get(key);
                PropertyChangeListener[] childListeners = child.getPropertyChangeListeners();
                for (int index = childListeners.length - 1; index >= 0; --index) {
                    returnList.add(new PropertyChangeListenerProxy(key, childListeners[index]));
                }
            }
        }
        return returnList.toArray(new PropertyChangeListener[returnList.size()]);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (listener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
            this.removePropertyChangeListener(proxy.getPropertyName(), (PropertyChangeListener)proxy.getListener());
        } else {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(listener);
        }
    }

    public void removePropertyChangeListeners() {
        for (PropertyChangeListener listener : this.getPropertyChangeListeners()) {
            this.removePropertyChangeListener(listener);
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        CleanablePropertyChangeSupport child;
        if (listener == null || propertyName == null) {
            return;
        }
        if (this.children == null) {
            this.children = new Hashtable();
        }
        if ((child = this.children.get(propertyName)) == null) {
            child = new CleanablePropertyChangeSupport(this.source);
            this.children.put(propertyName, child);
        }
        child.addPropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        CleanablePropertyChangeSupport support;
        ArrayList<PropertyChangeListener> returnList = new ArrayList<PropertyChangeListener>();
        if (this.children != null && propertyName != null && (support = this.children.get(propertyName)) != null) {
            returnList.addAll(Arrays.asList(support.getPropertyChangeListeners()));
        }
        return returnList.toArray(new PropertyChangeListener[returnList.size()]);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null || propertyName == null || this.children == null) {
            return;
        }
        CleanablePropertyChangeSupport child = this.children.get(propertyName);
        if (child == null) {
            return;
        }
        child.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListeners(String propertyName) {
        CleanablePropertyChangeSupport child = this.children.get(propertyName);
        if (child == null) {
            return;
        }
        child.removePropertyChangeListeners();
    }

    public boolean hasListeners(String propertyName) {
        CleanablePropertyChangeSupport child;
        if (this.listeners != null && !this.listeners.isEmpty()) {
            return true;
        }
        if (this.children != null && propertyName != null && (child = this.children.get(propertyName)) != null && child.listeners != null) {
            return !child.listeners.isEmpty();
        }
        return false;
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.firePropertyChange(new PropertyChangeEvent(this.source, propertyName, oldValue, newValue));
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue, Object userObject) {
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.firePropertyChange(new UserPropertyChangeEvent(this.source, propertyName, oldValue, newValue, userObject));
    }

    public boolean firePropertyChange(PropertyChangeEvent evt) {
        CleanablePropertyChangeSupport child;
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        String propertyName = evt.getPropertyName();
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return false;
        }
        boolean fired = false;
        if (this.listeners != null) {
            Object[] listeners;
            for (Object listener : listeners = this.listeners.toArray()) {
                PropertyChangeListener target = (PropertyChangeListener)listener;
                if (!this.listeners.contains(target)) continue;
                target.propertyChange(evt);
                fired = true;
            }
        }
        if (this.children != null && propertyName != null && (child = this.children.get(propertyName)) != null && child.firePropertyChange(evt)) {
            fired = true;
        }
        return fired;
    }

    public void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        this.firePropertyChange(new IndexedPropertyChangeEvent(this.source, propertyName, oldValue, newValue, index));
    }
}

