/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.image;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.SampleModel;

public class PartialComponentSampleModel
extends SampleModel {
    protected final int subsampleX;
    protected final int subsampleY;
    int rowLen;
    int rowsWithBR;
    int rowsWithoutBR;
    int size;
    static final int[] sampleSize = new int[]{8, 8, 8};

    public PartialComponentSampleModel(int w, int h, int subsampleX, int subsampleY) {
        super(0, w, h, 3);
        this.subsampleX = subsampleX;
        this.subsampleY = subsampleY;
        this.rowLen = w * (subsampleX + 2) / subsampleX;
        this.rowsWithBR = h / subsampleY;
        this.rowsWithoutBR = h - this.rowsWithBR;
        this.size = w * this.rowsWithoutBR + this.rowLen * this.rowsWithBR;
    }

    public SampleModel createCompatibleSampleModel(int w, int h) {
        return new PartialComponentSampleModel(w, h, this.subsampleX, this.subsampleY);
    }

    public DataBuffer createDataBuffer() {
        return new DataBufferByte(this.size);
    }

    public SampleModel createSubsetSampleModel(int[] bands) {
        throw new UnsupportedOperationException();
    }

    public Object getDataElements(int x, int y, Object obj, DataBuffer data) {
        DataBufferByte dbb = (DataBufferByte)data;
        byte[] ret = obj instanceof byte[] && ((byte[])obj).length == 3 ? (byte[])obj : new byte[3];
        int yWithBR = y / this.subsampleY;
        int yWithoutBR = y - yWithBR;
        int yStart = yWithoutBR * this.getWidth() + this.rowLen * yWithBR;
        byte[] ba = dbb.getData();
        if (this.subsampleY == 1 || y % this.subsampleY == 0) {
            int xOffset = x % this.subsampleX;
            int xWithBR = x / this.subsampleX;
            int xStart = yStart + xWithBR * (2 + this.subsampleX);
            ret[0] = ba[xStart + xOffset];
            ret[1] = ba[xStart + this.subsampleX];
            ret[2] = ba[xStart + this.subsampleX + 1];
        } else {
            int yHavingBR = y - y % this.subsampleY;
            ret = (byte[])this.getDataElements(x, yHavingBR, ret, data);
            ret[0] = dbb.getData()[yStart + x];
        }
        return ret;
    }

    public int getNumDataElements() {
        return 3;
    }

    public int getSample(int x, int y, int b, DataBuffer data) {
        return ((byte[])this.getDataElements(x, y, null, data))[b];
    }

    public int[] getSampleSize() {
        return sampleSize;
    }

    public int getSampleSize(int band) {
        return sampleSize[band];
    }

    public void setDataElements(int x, int y, Object obj, DataBuffer data) {
        throw new UnsupportedOperationException();
    }

    public void setSample(int x, int y, int b, int s, DataBuffer data) {
        throw new UnsupportedOperationException();
    }
}

