/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.io;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.io.ContentHandlerAdapter;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXReader {
    private File file;
    private SAXParser parser;

    public SAXReader(File file) throws ParserConfigurationException, SAXException {
        SAXParserFactory f = SAXParserFactory.newInstance();
        this.parser = f.newSAXParser();
        this.file = file;
    }

    public void readDicomObject(DicomObject dcmObj) throws SAXException, IOException {
        this.parser.parse(this.file, (DefaultHandler)new ContentHandlerAdapter(dcmObj));
    }

    public DicomObject readDicomObject() throws SAXException, IOException {
        BasicDicomObject dcmObj = new BasicDicomObject();
        this.readDicomObject(dcmObj);
        return dcmObj;
    }
}

