/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.weasis.core.api.gui.InfoViewListPanel;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.api.util.FontTools;
import org.weasis.dicom.codec.DicomTag;
import org.weasis.dicom.codec.display.CornerInfoData;

public class InfoViewElementPanel
extends InfoViewListPanel {
    private CornerInfoData corner;
    private final InfoView[] infoView;

    public InfoViewElementPanel() {
        this.setBackground(Color.BLACK);
        this.infoView = new InfoView[7];
        for (int i = 0; i < this.infoView.length; ++i) {
            this.infoView[i] = new InfoView();
            this.add(this.infoView[i]);
        }
    }

    public CornerInfoData getCorner() {
        return this.corner;
    }

    public void setCorner(CornerInfoData corner) {
        this.corner = corner;
        if (corner != null) {
            TagW[] elements = corner.getInfos();
            for (int i = 0; i < this.infoView.length; ++i) {
                this.infoView[i].setInfoElement(elements[i]);
            }
        }
        this.repaint();
    }

    protected void setInfoElement(TagW tag, Point dropPoint) {
        int index;
        Component c = this.getComponentAt(dropPoint);
        if (c instanceof InfoView && (index = this.getInfoViewIndex((InfoView)c)) >= 0) {
            this.corner.getInfos()[index] = tag;
            this.infoView[index].setInfoElement(tag);
            this.infoView[index].repaint();
        }
    }

    private int getInfoViewIndex(InfoView info) {
        for (int i = 0; i < this.infoView.length; ++i) {
            if (!info.equals(this.infoView[i])) continue;
            return i;
        }
        return -1;
    }

    private class InfoElementHandler
    extends TransferHandler {
        public InfoElementHandler() {
            super("InfoElement");
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDrop()) {
                return false;
            }
            return support.isDataFlavorSupported(TagW.infoElementDataFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            Transferable transferable = support.getTransferable();
            try {
                DicomTag tag = (DicomTag)((Object)transferable.getTransferData(TagW.infoElementDataFlavor));
                InfoViewElementPanel.this.setInfoElement(tag, support.getDropLocation().getDropPoint());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
    }

    private static class InfoView
    extends JComponent {
        private TagW infoElement;

        public InfoView() {
            this.setBackground(Color.BLACK);
            this.setForeground(Color.WHITE);
        }

        public TagW getInfoElement() {
            return this.infoElement;
        }

        public void setInfoElement(TagW infoElement) {
            this.infoElement = infoElement;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            Rectangle rect = this.getBounds();
            if (this.infoElement != null) {
                FontMetrics frc = g2.getFontMetrics();
                float midfontHeight = FontTools.getAccurateFontHeight((Graphics)g2) * FontTools.getMidFontHeightFactor();
                String str = this.infoElement.getName();
                int stringWidth = frc.stringWidth(str);
                g2.drawString(str, (float)rect.width / 2.0f - (float)stringWidth / 2.0f, (float)rect.height / 2.0f + midfontHeight);
            }
            float[] dashes = new float[]{10.0f, 5.0f};
            g2.setPaint(Color.LIGHT_GRAY);
            g2.setStroke(new BasicStroke(2.0f, 2, 1, 10.0f, dashes, 0.0f));
            g2.drawRoundRect(10, 5, rect.width - 20, rect.height - 10, 10, 10);
        }
    }
}

