/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec.internal;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.imageio.spi.IIORegistry;
import org.dcm4che2.imageioimpl.plugins.rle.RLEImageReaderSpi;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.weasis.core.api.service.BundlePreferences;
import org.weasis.dicom.codec.pref.DicomPrefManager;

public class Activator
implements BundleActivator {
    private static final String LOGGER_KEY = "always.info.ItemParser";
    private static final String LOGGER_VAL = "org.dcm4che2.imageio.ItemParser";
    public static final BundlePreferences PREFERENCES = new BundlePreferences();
    private BundleContext bundleContext = null;

    public void start(BundleContext bundleContext) throws Exception {
        Configuration logConfiguration;
        ConfigurationAdmin confAdmin;
        this.bundleContext = bundleContext;
        PREFERENCES.init(bundleContext);
        IIORegistry registry = IIORegistry.getDefaultInstance();
        registry.registerServiceProvider(new RLEImageReaderSpi());
        ServiceReference configurationAdminReference = bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        if (configurationAdminReference != null && (confAdmin = (ConfigurationAdmin)bundleContext.getService(configurationAdminReference)) != null && (logConfiguration = this.getLogConfiguration(confAdmin)) == null) {
            logConfiguration = confAdmin.createFactoryConfiguration("org.apache.sling.commons.log.LogManager.factory.config", null);
            Hashtable<String, String> loggingProperties = new Hashtable<String, String>();
            ((Dictionary)loggingProperties).put("org.apache.sling.commons.log.level", "INFO");
            ((Dictionary)loggingProperties).put("org.apache.sling.commons.log.names", LOGGER_VAL);
            ((Dictionary)loggingProperties).put(LOGGER_KEY, LOGGER_VAL);
            logConfiguration.update(loggingProperties);
        }
    }

    private Configuration getLogConfiguration(ConfigurationAdmin confAdmin) throws IOException {
        Configuration logConfiguration = null;
        try {
            Configuration[] configs = confAdmin.listConfigurations("(always.info.ItemParser=org.dcm4che2.imageio.ItemParser)");
            if (configs != null && configs.length > 0) {
                logConfiguration = configs[0];
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return logConfiguration;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        DicomPrefManager.getInstance().savePreferences();
        PREFERENCES.close();
        this.bundleContext = null;
    }
}

