/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.gui.util;

import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.weasis.core.api.gui.util.ActionState;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.gui.util.JSliderW;
import org.weasis.core.api.gui.util.MouseActionAdapter;
import org.weasis.core.api.util.FontTools;

public abstract class SliderChangeListener
extends MouseActionAdapter
implements ChangeListener,
ActionState {
    protected final ActionW action;
    private final ArrayList<JSliderW> sliders;
    private final DefaultBoundedRangeModel model;
    private boolean enable;
    private boolean triggerAction = true;
    private boolean valueIsAdjusting = true;

    public SliderChangeListener(ActionW action, int min, int max, int value, boolean valueIsAdjusting, double mouseSensivity) {
        this(action, min, max, value, valueIsAdjusting);
        this.setMouseSensivity(mouseSensivity);
    }

    public SliderChangeListener(ActionW action, int min, int max, int value, boolean valueIsAdjusting) {
        this.action = action;
        this.valueIsAdjusting = valueIsAdjusting;
        this.enable = true;
        this.model = new DefaultBoundedRangeModel(value, 0, min, max);
        this.model.addChangeListener(this);
        this.sliders = new ArrayList();
    }

    public SliderChangeListener(ActionW action, int min, int max, int value) {
        this(action, min, max, value, true);
    }

    @Override
    public void enableAction(boolean enabled) {
        this.enable = enabled;
        for (JSliderW slider : this.sliders) {
            slider.setEnabled(enabled);
        }
    }

    public int getMin() {
        return this.model.getMinimum();
    }

    public void setMinMax(int min, int max) {
        this.setMinMaxValue(min, max, this.model.getValue());
    }

    public synchronized void setMinMaxValue(int min, int max, int value) {
        value = value > max ? max : (value < min ? min : value);
        this.model.setRangeProperties(value, this.model.getExtent(), min, max, this.model.getValueIsAdjusting());
        for (int i = 0; i < this.sliders.size(); ++i) {
            JSliderW s = this.sliders.get(i);
            this.updateSliderProoperties(s);
            SliderChangeListener.setSliderLabelValues(s, min, max);
        }
    }

    public synchronized void setMinMaxValueWithoutTriggerAction(int min, int max, int value) {
        value = value > max ? max : (value < min ? min : value);
        this.triggerAction = false;
        this.model.setRangeProperties(value, this.model.getExtent(), min, max, this.model.getValueIsAdjusting());
        this.triggerAction = true;
        for (int i = 0; i < this.sliders.size(); ++i) {
            JSliderW s = this.sliders.get(i);
            this.updateSliderProoperties(s);
            SliderChangeListener.setSliderLabelValues(s, min, max);
        }
    }

    public boolean isTriggerAction() {
        return this.triggerAction;
    }

    @Override
    public ActionW getActionW() {
        return this.action;
    }

    public void setValue(int value) {
        this.model.setValue(value);
    }

    public void setValueWithoutTriggerAction(int value) {
        boolean ajusting;
        boolean bl = this.valueIsAdjusting ? true : (ajusting = !this.model.getValueIsAdjusting());
        if (ajusting) {
            this.triggerAction = false;
            this.model.setValue(value);
            this.triggerAction = true;
        }
    }

    public boolean isValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public int getMax() {
        return this.model.getMaximum();
    }

    public int getValue() {
        return this.model.getValue();
    }

    public DefaultBoundedRangeModel getModel() {
        return this.model;
    }

    public String getValueToDisplay() {
        return this.getValue() + "";
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        boolean ajusting;
        boolean bl = this.valueIsAdjusting ? true : (ajusting = !this.model.getValueIsAdjusting());
        if (this.triggerAction && ajusting) {
            this.stateChanged(this.model);
        }
        for (int i = 0; i < this.sliders.size(); ++i) {
            this.updateSliderProoperties(this.sliders.get(i));
        }
    }

    public abstract void stateChanged(BoundedRangeModel var1);

    public String toString() {
        return this.action.getTitle();
    }

    public void registerSlider(JSliderW slider) {
        if (!this.sliders.contains(slider)) {
            this.sliders.add(slider);
            slider.setEnabled(this.enable);
            slider.setModel(this.model);
            this.updateSliderProoperties(slider);
        }
    }

    public void unregisterSlider(JSliderW slider) {
        this.sliders.remove(slider);
        slider.setModel(new DefaultBoundedRangeModel(0, 0, 0, 100));
    }

    public static void setSliderLabelValues(JSliderW slider, int min, int max) {
        int div = slider.getLabelDivision();
        if (div < 1) {
            return;
        }
        int spacing = (max - min) / (div - 1);
        if (spacing < 1) {
            spacing = 1;
        }
        if (!slider.getPaintLabels()) {
            return;
        }
        Hashtable<Integer, JLabel> table = new Hashtable<Integer, JLabel>();
        for (int i = 0; i < div; ++i) {
            Integer index = i * spacing + min;
            table.put(index, new JLabel("" + index));
        }
        slider.setLabelTable(table);
        FontTools.setFont10(slider);
        slider.setMajorTickSpacing(spacing);
    }

    public void updateSliderProoperties(JSliderW slider) {
        JPanel panel = (JPanel)slider.getParent();
        String result = this.action.getTitle() + ": " + this.getValueToDisplay();
        if (!slider.isDisplayOnlyValue() && panel != null && panel.getBorder() instanceof TitledBorder) {
            ((TitledBorder)panel.getBorder()).setTitle(result);
            panel.repaint();
        } else {
            slider.setToolTipText(result);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int buttonMask = this.getButtonMaskEx();
        if ((e.getModifiersEx() & buttonMask) != 0) {
            this.lastPosition = this.isMoveOnX() ? e.getX() : e.getY();
            this.dragAccumulator = this.getValue();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int buttonMask = this.getButtonMaskEx();
        int modifier = e.getModifiersEx();
        if ((modifier & buttonMask) != 0 && this.dragAccumulator != Double.MAX_VALUE) {
            int position = this.isMoveOnX() ? e.getX() : e.getY();
            int mask = 192;
            double acceleratorKey = (modifier & mask) == 0 ? 1.0 : ((modifier & mask) == mask ? 5.0 : 2.5);
            double val = (double)(position - this.lastPosition) * this.getMouseSensivity() * acceleratorKey;
            if (val == 0.0) {
                return;
            }
            this.lastPosition = position;
            this.dragAccumulator = this.isInverse() ? (this.dragAccumulator -= val) : (this.dragAccumulator += val);
            if (val < 0.0) {
                this.setValue((int)Math.ceil(this.dragAccumulator));
            } else {
                this.setValue((int)Math.floor(this.dragAccumulator));
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.setValue(this.getValue() + e.getWheelRotation() * e.getScrollAmount());
        super.mouseWheelMoved(e);
    }

    public JSliderW createSlider(int labelDivision, boolean displayOnlyValue) {
        JPanel palenSlider1 = new JPanel();
        palenSlider1.setLayout(new BoxLayout(palenSlider1, 1));
        palenSlider1.setBorder(new TitledBorder(this.action.getTitle()));
        JSliderW slider = new JSliderW(this.model.getMinimum(), this.model.getMaximum(), this.model.getValue());
        slider.setLabelDivision(labelDivision);
        slider.setDisplayOnlyValue(displayOnlyValue);
        slider.setPaintTicks(true);
        palenSlider1.add(slider);
        this.registerSlider(slider);
        if (labelDivision > 0) {
            slider.setPaintLabels(true);
            SliderChangeListener.setSliderLabelValues(slider, this.model.getMinimum(), this.model.getMaximum());
        }
        return slider;
    }
}

