/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image.util;

import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;

public class LayoutUtil {
    public static RenderingHints BORDER_COPY = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));

    public static ImageLayout getImageLayoutHint(RenderingHints renderinghints) {
        if (renderinghints == null) {
            return null;
        }
        return (ImageLayout)renderinghints.get(JAI.KEY_IMAGE_LAYOUT);
    }

    public static TileCache getTileCacheHint(RenderingHints renderinghints) {
        if (renderinghints == null) {
            return null;
        }
        return (TileCache)renderinghints.get(JAI.KEY_TILE_CACHE);
    }

    public static BorderExtender getBorderExtenderHint(RenderingHints renderinghints) {
        if (renderinghints == null) {
            return null;
        }
        return (BorderExtender)renderinghints.get(JAI.KEY_BORDER_EXTENDER);
    }

    public static RenderingHints createTiledLayoutHints() {
        ImageLayout layout = new ImageLayout();
        layout.setTileWidth(512);
        layout.setTileHeight(512);
        return new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
    }

    public static RenderingHints createTiledLayoutHints(RenderedImage source) {
        ImageLayout layout = new ImageLayout(source);
        layout.setTileWidth(512);
        layout.setTileHeight(512);
        return new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
    }

    private static RenderingHints createRenderedImage(ColorSpace cs, int[] bits) {
        ComponentColorModel colorModel = new ComponentColorModel(cs, bits, false, false, 1, 0);
        ImageLayout layout = new ImageLayout();
        layout.setColorModel((ColorModel)colorModel);
        layout.setSampleModel(((ColorModel)colorModel).createCompatibleSampleModel(512, 512));
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        return hints;
    }

    public static RenderingHints createGrayRenderedImage() {
        return LayoutUtil.createRenderedImage(ColorSpace.getInstance(1003), new int[]{8});
    }

    public static RenderingHints createColorRenderedImage() {
        return LayoutUtil.createRenderedImage(ColorSpace.getInstance(1000), new int[]{8, 8, 8});
    }

    public static RenderingHints createBinaryRenderedImage(RenderingHints oldhints) {
        ImageLayout layout = LayoutUtil.getImageLayoutHint(oldhints);
        if (layout == null) {
            layout = new ImageLayout();
        }
        layout.setColorModel((ColorModel)new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0));
        RenderingHints hints = new RenderingHints(JAI.KEY_TRANSFORM_ON_COLORMAP, Boolean.FALSE);
        oldhints.add(hints);
        oldhints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
        return hints;
    }

    public static RenderingHints createBinaryRenderedImage() {
        ImageLayout layout = new ImageLayout();
        layout.setSampleModel(LayoutUtil.createBinarySampelModel());
        layout.setColorModel(LayoutUtil.createBinaryIndexColorModel());
        RenderingHints hints = new RenderingHints(JAI.KEY_TRANSFORM_ON_COLORMAP, Boolean.FALSE);
        hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
        return hints;
    }

    public static SampleModel createBinarySampelModel(int tileWidth, int tileHeight) {
        return new MultiPixelPackedSampleModel(0, tileWidth, tileHeight, 1);
    }

    public static SampleModel createBinarySampelModel() {
        return LayoutUtil.createBinarySampelModel(512, 512);
    }

    public static ColorModel createBinaryIndexColorModel() {
        byte[] comp = new byte[]{0, -1};
        return new IndexColorModel(1, 2, comp, comp, comp);
    }
}

