/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.StringCharacterIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EscapeChars {
    private static final Pattern SCRIPT = Pattern.compile("<SCRIPT>", 2);
    private static final Pattern SCRIPT_END = Pattern.compile("</SCRIPT>", 2);

    public static String forHTML(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '&') {
                result.append("&amp;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\t') {
                EscapeChars.addCharEntity(9, result);
            } else if (character == '!') {
                EscapeChars.addCharEntity(33, result);
            } else if (character == '#') {
                EscapeChars.addCharEntity(35, result);
            } else if (character == '$') {
                EscapeChars.addCharEntity(36, result);
            } else if (character == '%') {
                EscapeChars.addCharEntity(37, result);
            } else if (character == '\'') {
                EscapeChars.addCharEntity(39, result);
            } else if (character == '(') {
                EscapeChars.addCharEntity(40, result);
            } else if (character == ')') {
                EscapeChars.addCharEntity(41, result);
            } else if (character == '*') {
                EscapeChars.addCharEntity(42, result);
            } else if (character == '+') {
                EscapeChars.addCharEntity(43, result);
            } else if (character == ',') {
                EscapeChars.addCharEntity(44, result);
            } else if (character == '-') {
                EscapeChars.addCharEntity(45, result);
            } else if (character == '.') {
                EscapeChars.addCharEntity(46, result);
            } else if (character == '/') {
                EscapeChars.addCharEntity(47, result);
            } else if (character == ':') {
                EscapeChars.addCharEntity(58, result);
            } else if (character == ';') {
                EscapeChars.addCharEntity(59, result);
            } else if (character == '=') {
                EscapeChars.addCharEntity(61, result);
            } else if (character == '?') {
                EscapeChars.addCharEntity(63, result);
            } else if (character == '@') {
                EscapeChars.addCharEntity(64, result);
            } else if (character == '[') {
                EscapeChars.addCharEntity(91, result);
            } else if (character == '\\') {
                EscapeChars.addCharEntity(92, result);
            } else if (character == ']') {
                EscapeChars.addCharEntity(93, result);
            } else if (character == '^') {
                EscapeChars.addCharEntity(94, result);
            } else if (character == '_') {
                EscapeChars.addCharEntity(95, result);
            } else if (character == '`') {
                EscapeChars.addCharEntity(96, result);
            } else if (character == '{') {
                EscapeChars.addCharEntity(123, result);
            } else if (character == '|') {
                EscapeChars.addCharEntity(124, result);
            } else if (character == '}') {
                EscapeChars.addCharEntity(125, result);
            } else if (character == '~') {
                EscapeChars.addCharEntity(126, result);
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String forHrefAmpersand(String aURL) {
        return aURL.replace("&", "&amp;");
    }

    public static String forURL(String aURLFragment) {
        String result = null;
        try {
            result = URLEncoder.encode(aURLFragment, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 not supported", ex);
        }
        return result;
    }

    public static String forXML(String aText) {
        if (aText == null) {
            return null;
        }
        if ("".equals(aText)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char c = iterator.current();
        while (c != '\uffff') {
            if (c == '<') {
                result.append("&lt;");
            } else if (c == '>') {
                result.append("&gt;");
            } else if (c == '\"') {
                result.append("&quot;");
            } else if (c == '\'') {
                result.append("&#039;");
            } else if (c == '&') {
                result.append("&amp;");
            } else if (c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff') {
                result.append(c);
            }
            c = iterator.next();
        }
        return result.toString();
    }

    public static String toDisableTags(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String forRegex(String aRegexFragment) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aRegexFragment);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '.') {
                result.append("\\.");
            } else if (character == '\\') {
                result.append("\\\\");
            } else if (character == '?') {
                result.append("\\?");
            } else if (character == '*') {
                result.append("\\*");
            } else if (character == '+') {
                result.append("\\+");
            } else if (character == '&') {
                result.append("\\&");
            } else if (character == ':') {
                result.append("\\:");
            } else if (character == '{') {
                result.append("\\{");
            } else if (character == '}') {
                result.append("\\}");
            } else if (character == '[') {
                result.append("\\[");
            } else if (character == ']') {
                result.append("\\]");
            } else if (character == '(') {
                result.append("\\(");
            } else if (character == ')') {
                result.append("\\)");
            } else if (character == '^') {
                result.append("\\^");
            } else if (character == '$') {
                result.append("\\$");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String forReplacementString(String aInput) {
        return Matcher.quoteReplacement(aInput);
    }

    public static String forScriptTagsOnly(String aText) {
        String result = null;
        Matcher matcher = SCRIPT.matcher(aText);
        result = matcher.replaceAll("&lt;SCRIPT>");
        matcher = SCRIPT_END.matcher(result);
        result = matcher.replaceAll("&lt;/SCRIPT>");
        return result;
    }

    private static void addCharEntity(Integer aIdx, StringBuilder aBuilder) {
        String padding = "";
        if (aIdx <= 9) {
            padding = "00";
        } else if (aIdx <= 99) {
            padding = "0";
        }
        String number = padding + aIdx.toString();
        aBuilder.append("&#" + number + ";");
    }
}

