/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.docking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowManagerDescriptor;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.ToolWindowTypeDescriptor;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowBar;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.weasis.core.api.explorer.DataExplorerView;
import org.weasis.core.api.gui.util.GuiExecutor;
import org.weasis.core.ui.editor.SeriesViewer;
import org.weasis.core.ui.editor.SeriesViewerFactory;
import org.weasis.core.ui.editor.image.ViewerPlugin;

public class UIManager {
    public static final MyDoggyToolWindowManager toolWindowManager = UIManager.builWinManager();
    public static final AtomicInteger dockableUIGenerator = new AtomicInteger(1);
    public static final List<ViewerPlugin> VIEWER_PLUGINS = Collections.synchronizedList(new ArrayList());
    public static final List<DataExplorerView> EXPLORER_PLUGINS = Collections.synchronizedList(new ArrayList());
    public static final List<SeriesViewerFactory> SERIES_VIEWER_FACTORIES = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataExplorerView getExplorerplugin(String name) {
        if (name != null) {
            List<DataExplorerView> list = EXPLORER_PLUGINS;
            synchronized (list) {
                for (DataExplorerView view : EXPLORER_PLUGINS) {
                    if (!name.equals(view.getUIName())) continue;
                    return view;
                }
            }
        }
        return null;
    }

    private static MyDoggyToolWindowManager builWinManager() {
        MyDoggyToolWindowManager result = null;
        FutureTask<MyDoggyToolWindowManager> future = new FutureTask<MyDoggyToolWindowManager>(new Callable<MyDoggyToolWindowManager>(){

            @Override
            public MyDoggyToolWindowManager call() throws Exception {
                MyDoggyToolWindowManager winManager = new MyDoggyToolWindowManager(Locale.getDefault(), MyDoggyToolWindowManager.class.getClassLoader());
                winManager.getResourceManager().setUserBundle(Locale.getDefault(), "/toolWindow", UIManager.class.getClassLoader());
                for (ToolWindowAnchor anchor : ToolWindowAnchor.values()) {
                    MyDoggyToolWindowBar bar = winManager.getBar(anchor);
                    bar.setDividerSize(7);
                }
                ToolWindowManagerDescriptor desc = winManager.getToolWindowManagerDescriptor();
                desc.setNumberingEnabled(false);
                for (ToolWindowType toolWinType : ToolWindowType.values()) {
                    if (toolWinType.equals((Object)ToolWindowType.EXTERN)) continue;
                    ToolWindowTypeDescriptor type = winManager.getTypeDescriptorTemplate(toolWinType);
                    type.setIdVisibleOnTitleBar(false);
                    type.setAnimating(false);
                }
                return winManager;
            }
        });
        GuiExecutor.instance().invokeAndWait(future);
        try {
            result = future.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SeriesViewerFactory getViewerFactory(SeriesViewer seriesViewer) {
        List<SeriesViewerFactory> list = SERIES_VIEWER_FACTORIES;
        synchronized (list) {
            List<SeriesViewerFactory> plugins = SERIES_VIEWER_FACTORIES;
            for (SeriesViewerFactory factory : plugins) {
                if (factory == null || !factory.isViewerCreatedByThisFactory(seriesViewer)) continue;
                return factory;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SeriesViewerFactory getViewerFactory(String mimeType) {
        List<SeriesViewerFactory> list = SERIES_VIEWER_FACTORIES;
        synchronized (list) {
            int level = Integer.MAX_VALUE;
            SeriesViewerFactory best = null;
            for (SeriesViewerFactory f : SERIES_VIEWER_FACTORIES) {
                if (f == null || !f.canReadMimeType(mimeType) || f.getLevel() >= level) continue;
                level = f.getLevel();
                best = f;
            }
            return best;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SeriesViewerFactory getViewerFactory(String[] mimeTypeList) {
        List<SeriesViewerFactory> list = SERIES_VIEWER_FACTORIES;
        synchronized (list) {
            List<SeriesViewerFactory> plugins = SERIES_VIEWER_FACTORIES;
            int level = Integer.MAX_VALUE;
            SeriesViewerFactory best = null;
            for (SeriesViewerFactory f : plugins) {
                if (f == null) continue;
                for (String mime : mimeTypeList) {
                    if (!f.canReadMimeType(mime) || f.getLevel() >= level) continue;
                    best = f;
                }
            }
            return best;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SeriesViewerFactory> getViewerFactoryList(String[] mimeTypeList) {
        ArrayList<SeriesViewerFactory> plugins = new ArrayList<SeriesViewerFactory>();
        List<SeriesViewerFactory> list = SERIES_VIEWER_FACTORIES;
        synchronized (list) {
            for (SeriesViewerFactory viewerFactory : SERIES_VIEWER_FACTORIES) {
                if (viewerFactory == null) continue;
                for (String mime : mimeTypeList) {
                    if (!viewerFactory.canReadMimeType(mime)) continue;
                    plugins.add(viewerFactory);
                }
            }
        }
        Collections.sort(plugins, new Comparator<SeriesViewerFactory>(){

            @Override
            public int compare(SeriesViewerFactory s1, SeriesViewerFactory s2) {
                return s1.getLevel() < s2.getLevel() ? -1 : (s1.getLevel() == s2.getLevel() ? 0 : 1);
            }
        });
        return plugins;
    }
}

