/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.editor.image;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.weasis.core.api.gui.util.DecFormater;
import org.weasis.core.api.gui.util.JMVUtils;
import org.weasis.core.api.image.util.Unit;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.api.media.data.MediaSeries;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.editor.image.DefaultView2d;
import org.weasis.core.ui.graphic.Graphic;
import org.weasis.core.ui.graphic.LineGraphic;

public class CalibrationView
extends JPanel {
    private final DefaultView2d view2d;
    private final LineGraphic line;
    private final JComboBox jComboBoxUnit = new JComboBox<Object>(Unit.getUnitExceptPixel().toArray());
    private final JPanel jPanelMode = new JPanel();
    private final JFormattedTextField jTextFieldLineWidth = new JFormattedTextField();
    private final JLabel jLabelKnownDist = new JLabel();
    private final BorderLayout borderLayout1 = new BorderLayout();
    private final GridBagLayout gridBagLayout2 = new GridBagLayout();
    private final JLabel lblApplyTo = new JLabel(Messages.getString("CalibrationView.apply"));
    private final JPanel panel = new JPanel();
    private final ButtonGroup ratioGroup = new ButtonGroup();
    private final JRadioButton radioButtonSeries = new JRadioButton(Messages.getString("CalibrationView.series"));
    private final JRadioButton radioButtonImage = new JRadioButton(Messages.getString("CalibrationView.current"));

    public CalibrationView(LineGraphic line, DefaultView2d view2d) {
        this.line = line;
        this.view2d = view2d;
        try {
            this.jbInit();
            this.initialize();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.gridBagLayout2.rowWeights = new double[]{1.0, 0.0};
        this.gridBagLayout2.columnWeights = new double[]{0.0, 1.0, 0.0, 0.0};
        this.jPanelMode.setLayout(this.gridBagLayout2);
        JMVUtils.setPreferredWidth((JComponent)this.jTextFieldLineWidth, (int)170);
        this.jTextFieldLineWidth.setFormatterFactory(DecFormater.setPreciseDoubleFormat((double)5.0E-6, (double)Double.MAX_VALUE));
        this.jTextFieldLineWidth.setValue(1.0);
        JMVUtils.addCheckAction((JFormattedTextField)this.jTextFieldLineWidth);
        this.jLabelKnownDist.setText(Messages.getString("CalibrationView.known"));
        this.setLayout(this.borderLayout1);
        this.add((Component)this.jPanelMode, "Center");
        this.jPanelMode.add((Component)this.jComboBoxUnit, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
        this.jPanelMode.add((Component)this.jLabelKnownDist, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 5), 0, 0));
        this.jPanelMode.add((Component)this.jTextFieldLineWidth, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 0, 5), 0, 0));
        FlowLayout flowLayout = (FlowLayout)this.panel.getLayout();
        flowLayout.setHgap(10);
        flowLayout.setAlignment(0);
        this.add((Component)this.panel, "South");
        this.panel.add(this.lblApplyTo);
        this.ratioGroup.add(this.radioButtonSeries);
        this.ratioGroup.add(this.radioButtonImage);
        this.radioButtonSeries.setSelected(true);
        this.panel.add(this.radioButtonSeries);
        this.panel.add(this.radioButtonImage);
    }

    private void initialize() {
        Object image = this.view2d.getImage();
        if (image != null) {
            Unit unit = image.getPixelSpacingUnit();
            if (!Unit.PIXEL.equals((Object)unit)) {
                this.jTextFieldLineWidth.setValue(this.line.getSegmentLength(image.getPixelSize(), image.getPixelSize()));
            } else {
                GridBagConstraints gbc_textPane = new GridBagConstraints();
                gbc_textPane.gridwidth = 4;
                gbc_textPane.insets = new Insets(0, 0, 5, 5);
                gbc_textPane.fill = 2;
                gbc_textPane.gridx = 0;
                gbc_textPane.gridy = 0;
                gbc_textPane.weightx = 1.0;
                gbc_textPane.weighty = 1.0;
                JScrollPane scroll = new JScrollPane(this.createArea(Messages.getString("CalibrationView.warn"), true, 0));
                scroll.setPreferredSize(new Dimension(300, 75));
                this.jPanelMode.add((Component)scroll, gbc_textPane);
                unit = Unit.MILLIMETER;
            }
            this.jComboBoxUnit.setSelectedItem(unit);
        }
    }

    private JTextArea createArea(String text, boolean lineWrap, int columns) {
        JTextArea area = new JTextArea(text);
        area.setBorder(new CompoundBorder(BorderFactory.createRaisedBevelBorder(), new EmptyBorder(3, 5, 3, 5)));
        area.setLineWrap(lineWrap);
        area.setWrapStyleWord(true);
        area.setEditable(false);
        area.setColumns(columns);
        return area;
    }

    public void applyNewCalibration() {
        Number inputCalibVal;
        Object image = this.view2d.getImage();
        if (image != null && (inputCalibVal = JMVUtils.getFormattedValue((JFormattedTextField)this.jTextFieldLineWidth)) != null) {
            double factor = image.getPixelSize();
            Unit unit = (Unit)this.jComboBoxUnit.getSelectedItem();
            Unit originalUnit = image.getPixelSpacingUnit();
            if (!Unit.PIXEL.equals((Object)unit)) {
                double newRatio;
                double unitRatio = 1.0;
                if (Unit.PIXEL.equals((Object)originalUnit)) {
                    originalUnit = unit;
                    image.setPixelSpacingUnit(originalUnit);
                } else {
                    unitRatio = originalUnit.getConversionRatio(unit.getConvFactor());
                }
                Double lineLength = this.line.getSegmentLength(1.0, 1.0);
                if (lineLength == null || lineLength < 1.0) {
                    lineLength = 1.0;
                }
                if (factor != (newRatio = inputCalibVal.doubleValue() * unitRatio / lineLength)) {
                    if (this.radioButtonSeries.isSelected()) {
                        MediaSeries seriesList = this.view2d.getSeries();
                        if (seriesList != null) {
                            for (Object media : seriesList.getMedias()) {
                                if (!(media instanceof ImageElement)) continue;
                                ImageElement img = (ImageElement)media;
                                img.setPixelSize(newRatio);
                                this.updateLabel(img, this.view2d);
                            }
                        }
                    } else {
                        image.setPixelSize(newRatio);
                        this.updateLabel((ImageElement)image, this.view2d);
                    }
                    this.view2d.repaint();
                }
            }
        }
    }

    private void updateLabel(ImageElement image, DefaultView2d view2d) {
        List list = (List)image.getTagValue(TagW.MeasurementGraphics);
        if (list != null) {
            for (Graphic graphic : list) {
                graphic.updateLabel(image, view2d);
            }
        }
    }
}

