/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.List;
import javax.media.jai.PlanarImage;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;

public abstract class AbstractDragGraphicArea
extends AbstractDragGraphic {
    public static final Measurement ImageMin = new Measurement("Min", false);
    public static final Measurement ImageMax = new Measurement("Max", false);
    public static final Measurement ImageMean = new Measurement("Mean", false);
    public static final Measurement ImageSTD = new Measurement("StDev", false);

    public AbstractDragGraphicArea(int handlePointTotalNumber) {
        this(handlePointTotalNumber, Color.YELLOW, 1.0f, true);
    }

    public AbstractDragGraphicArea(int handlePointTotalNumber, Color paintColor, float lineThickness, boolean labelVisible) {
        this(handlePointTotalNumber, paintColor, lineThickness, labelVisible, false);
    }

    public AbstractDragGraphicArea(int handlePointTotalNumber, Color paintColor, float lineThickness, boolean labelVisible, boolean filled) {
        this(null, handlePointTotalNumber, paintColor, lineThickness, labelVisible, filled);
    }

    public AbstractDragGraphicArea(List<Point2D> handlePointList, int handlePointTotalNumber, Color paintColor, float lineThickness, boolean labelVisible, boolean filled) {
        super(handlePointList, handlePointTotalNumber, paintColor, lineThickness, labelVisible, filled);
    }

    @Override
    public Area getArea(AffineTransform transform) {
        if (this.shape == null) {
            return new Area();
        }
        Area area = super.getArea(transform);
        area.add(new Area(this.shape));
        return area;
    }

    public List<MeasureItem> getImageStatistics(ImageElement imageElement, boolean releaseEvent) {
        if (imageElement != null && this.shape != null) {
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>(5);
            if (ImageMin.isComputed() || ImageMax.isComputed() || ImageMean.isComputed() || ImageSTD.isComputed()) {
                Double val;
                String unit;
                Double min = null;
                Double max = null;
                Double stdv = null;
                Double mean = null;
                if (releaseEvent) {
                    PlanarImage image = imageElement.getImage();
                    try {
                        int band;
                        ArrayList<Integer> pList = this.getValueFromArea(image);
                        if (pList != null && pList.size() > 0 && (band = image.getSampleModel().getNumBands()) == 1) {
                            double v;
                            Float slope = (Float)imageElement.getTagValue(TagW.RescaleSlope);
                            Float intercept = (Float)imageElement.getTagValue(TagW.RescaleIntercept);
                            min = Double.MAX_VALUE;
                            max = -1.7976931348623157E308;
                            double sum = 0.0;
                            for (Integer val2 : pList) {
                                v = val2.doubleValue();
                                if (v < min) {
                                    min = v;
                                }
                                if (v > max) {
                                    max = v;
                                }
                                sum += v;
                            }
                            mean = sum / (double)pList.size();
                            stdv = 0.0;
                            for (Integer val2 : pList) {
                                v = val2.doubleValue();
                                if (v < min) {
                                    min = v;
                                }
                                if (v > max) {
                                    max = v;
                                }
                                stdv = stdv + (v - mean) * (v - mean);
                            }
                            stdv = Math.sqrt(stdv / ((double)pList.size() - 1.0));
                            if (slope != null || intercept != null) {
                                slope = Float.valueOf(slope == null ? 1.0f : slope.floatValue());
                                intercept = Float.valueOf(intercept == null ? 0.0f : intercept.floatValue());
                                mean = mean * (double)slope.floatValue() + (double)intercept.floatValue();
                                stdv = stdv * (double)slope.floatValue() + (double)intercept.floatValue();
                                min = min * (double)slope.floatValue() + (double)intercept.floatValue();
                                max = max * (double)slope.floatValue() + (double)intercept.floatValue();
                            }
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        // empty catch block
                    }
                }
                String string = unit = imageElement.getPixelValueUnit() == null ? "" : imageElement.getPixelValueUnit();
                if (ImageMin.isComputed() && (releaseEvent || ImageMin.isGraphicLabel())) {
                    val = releaseEvent || ImageMin.isQuickComputing() ? min : null;
                    measVal.add(new MeasureItem(ImageMin, val, unit));
                }
                if (ImageMax.isComputed() && (releaseEvent || ImageMax.isGraphicLabel())) {
                    val = releaseEvent || ImageMax.isQuickComputing() ? max : null;
                    measVal.add(new MeasureItem(ImageMax, val, unit));
                }
                if (ImageSTD.isComputed() && (releaseEvent || ImageSTD.isGraphicLabel())) {
                    val = releaseEvent || ImageSTD.isQuickComputing() ? stdv : null;
                    measVal.add(new MeasureItem(ImageSTD, val, unit));
                }
                if (ImageMean.isComputed() && (releaseEvent || ImageMean.isGraphicLabel())) {
                    val = releaseEvent || ImageMean.isQuickComputing() ? mean : null;
                    measVal.add(new MeasureItem(ImageMean, val, unit));
                }
            }
            return measVal;
        }
        return null;
    }

    protected ArrayList<Integer> getValueFromArea(PlanarImage imageData) {
        RectIter it;
        if (imageData == null || this.shape == null) {
            return null;
        }
        Area area = new Area(this.shape);
        Rectangle bound = area.getBounds();
        bound = imageData.getBounds().intersection(bound);
        if (bound.width == 0 || bound.height == 0) {
            return null;
        }
        try {
            it = RectIterFactory.create((RenderedImage)imageData, (Rectangle)bound);
        }
        catch (Exception ex) {
            it = null;
        }
        ArrayList<Integer> list = null;
        if (it != null) {
            int band = imageData.getSampleModel().getNumBands();
            list = new ArrayList<Integer>();
            int[] c = new int[]{0, 0, 0};
            it.startBands();
            it.startLines();
            int y = bound.y;
            while (!it.finishedLines()) {
                it.startPixels();
                int x = bound.x;
                while (!it.finishedPixels()) {
                    if (this.shape.contains(x, y)) {
                        it.getPixel(c);
                        for (int i = 0; i < band; ++i) {
                            list.add(c[i]);
                        }
                    }
                    it.nextPixel();
                    ++x;
                }
                it.nextLine();
                ++y;
            }
        }
        return list;
    }
}

