/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.util;

import java.awt.Color;
import java.awt.Font;
import org.osgi.service.prefs.Preferences;
import org.weasis.core.api.service.BundlePreferences;

public class ViewSetting {
    public static final String PREFERENCE_NODE = "view2d.default";
    private int fontType;
    private int fontSize;
    private String fontName;
    private boolean drawOnlyOnce;
    private Color lineColor;
    private int lineWidth;

    public void applyPreferences(Preferences prefs) {
        if (prefs != null) {
            Preferences p = prefs.node(PREFERENCE_NODE);
            this.fontName = p.get("font.name", "Default");
            this.fontType = p.getInt("font.type", 0);
            this.fontSize = p.getInt("font.size", 10);
            this.drawOnlyOnce = p.getBoolean("draw.once", true);
            this.lineWidth = p.getInt("line.width", 1);
            int rgb = p.getInt("line.color", Color.YELLOW.getRGB());
            this.lineColor = new Color(rgb);
        }
    }

    public void savePreferences(Preferences prefs) {
        if (prefs != null) {
            Preferences p = prefs.node(PREFERENCE_NODE);
            BundlePreferences.putStringPreferences((Preferences)p, (String)"font.name", (String)this.fontName);
            BundlePreferences.putIntPreferences((Preferences)p, (String)"font.type", (int)this.fontType);
            BundlePreferences.putIntPreferences((Preferences)p, (String)"font.size", (int)this.fontSize);
            BundlePreferences.putBooleanPreferences((Preferences)p, (String)"draw.once", (boolean)this.drawOnlyOnce);
            BundlePreferences.putIntPreferences((Preferences)p, (String)"line.width", (int)this.lineWidth);
            BundlePreferences.putIntPreferences((Preferences)p, (String)"line.color", (int)this.lineColor.getRGB());
        }
    }

    public int getFontType() {
        return this.fontType;
    }

    public void setFontType(int fontType) {
        this.fontType = fontType;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public Font getFont() {
        return new Font(this.fontName, this.fontType, this.fontSize);
    }

    public void setDrawOnlyOnce(boolean drawOnlyOnce) {
        this.drawOnlyOnce = drawOnlyOnce;
    }

    public boolean isDrawOnlyOnce() {
        return this.drawOnlyOnce;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }
}

