/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class XorOpImage
extends PointOpImage {
    public XorOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, Map map, ImageLayout imageLayout) {
        super(renderedImage, renderedImage2, imageLayout, map, true);
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[1], rectangle, rasterFormatTagArray[1], this.getSource(1).getColorModel());
        RasterAccessor rasterAccessor3 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[2], this.getColorModel());
        if (rasterAccessor3.isBinary()) {
            byte[] byArray = rasterAccessor.getBinaryDataArray();
            byte[] byArray2 = rasterAccessor2.getBinaryDataArray();
            byte[] byArray3 = rasterAccessor3.getBinaryDataArray();
            int n = byArray3.length;
            for (int i = 0; i < n; ++i) {
                byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
            }
            rasterAccessor3.copyBinaryDataToRaster();
            return;
        }
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor3.getNumBands();
        int n6 = rasterAccessor3.getWidth();
        int n7 = rasterAccessor3.getHeight();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        switch (rasterAccessor3.getDataType()) {
            case 0: {
                this.byteLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getByteDataArrays(), n3, n4, nArray2, rasterAccessor2.getByteDataArrays(), n8, n9, nArray3, rasterAccessor3.getByteDataArrays());
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getShortDataArrays(), n3, n4, nArray2, rasterAccessor2.getShortDataArrays(), n8, n9, nArray3, rasterAccessor3.getShortDataArrays());
                break;
            }
            case 3: {
                this.intLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getIntDataArrays(), n3, n4, nArray2, rasterAccessor2.getIntDataArrays(), n8, n9, nArray3, rasterAccessor3.getIntDataArrays());
            }
        }
        rasterAccessor3.copyDataToRaster();
    }

    private void byteLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, byte[][] byArray, int n6, int n7, int[] nArray2, byte[][] byArray2, int n8, int n9, int[] nArray3, byte[][] byArray3) {
        for (int i = 0; i < n; ++i) {
            byte[] byArray4 = byArray[i];
            byte[] byArray5 = byArray2[i];
            byte[] byArray6 = byArray3[i];
            int n10 = nArray[i];
            int n11 = nArray2[i];
            int n12 = nArray3[i];
            for (int j = 0; j < n3; ++j) {
                int n13 = n10;
                int n14 = n11;
                int n15 = n12;
                n10 += n4;
                n11 += n6;
                n12 += n8;
                for (int k = 0; k < n2; ++k) {
                    byArray6[n15] = (byte)(byArray4[n13] ^ byArray5[n14]);
                    n13 += n5;
                    n14 += n7;
                    n15 += n9;
                }
            }
        }
    }

    private void shortLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, short[][] sArray, int n6, int n7, int[] nArray2, short[][] sArray2, int n8, int n9, int[] nArray3, short[][] sArray3) {
        for (int i = 0; i < n; ++i) {
            short[] sArray4 = sArray[i];
            short[] sArray5 = sArray2[i];
            short[] sArray6 = sArray3[i];
            int n10 = nArray[i];
            int n11 = nArray2[i];
            int n12 = nArray3[i];
            for (int j = 0; j < n3; ++j) {
                int n13 = n10;
                int n14 = n11;
                int n15 = n12;
                n10 += n4;
                n11 += n6;
                n12 += n8;
                for (int k = 0; k < n2; ++k) {
                    sArray6[n15] = (short)(sArray4[n13] ^ sArray5[n14]);
                    n13 += n5;
                    n14 += n7;
                    n15 += n9;
                }
            }
        }
    }

    private void intLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, int[][] nArray2, int n6, int n7, int[] nArray3, int[][] nArray4, int n8, int n9, int[] nArray5, int[][] nArray6) {
        for (int i = 0; i < n; ++i) {
            int[] nArray7 = nArray2[i];
            int[] nArray8 = nArray4[i];
            int[] nArray9 = nArray6[i];
            int n10 = nArray[i];
            int n11 = nArray3[i];
            int n12 = nArray5[i];
            for (int j = 0; j < n3; ++j) {
                int n13 = n10;
                int n14 = n11;
                int n15 = n12;
                n10 += n4;
                n11 += n6;
                n12 += n8;
                for (int k = 0; k < n2; ++k) {
                    nArray9[n15] = nArray7[n13] ^ nArray8[n14];
                    n13 += n5;
                    n14 += n7;
                    n15 += n9;
                }
            }
        }
    }
}

