/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.gui.util;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.weasis.core.api.gui.util.DropDownLabel;

public abstract class DropDownButton
extends JButton
implements PopupMenuListener,
ActionListener {
    private final String type;

    public DropDownButton(String type, Icon icon) {
        super(icon);
        this.type = type;
        this.init();
    }

    public DropDownButton(String type, String text) {
        super(new DropDownLabel(text));
        this.type = type;
        this.init();
    }

    private void init() {
        this.addActionListener(this);
    }

    @Override
    public void setLabel(String label) {
        Icon icon = this.getIcon();
        if (icon instanceof DropDownLabel) {
            DropDownLabel iconLabel = (DropDownLabel)icon;
            iconLabel.setLabel(label);
            Insets insets = this.getInsets();
            iconLabel.paintIcon(this, this.getGraphics(), insets.left, insets.top);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        JPopupMenu popup = this.getPopupMenu();
        popup.addPopupMenuListener(this);
        popup.show(this, 0, this.getHeight());
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.getModel().setRollover(true);
        this.getModel().setSelected(true);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.getModel().setRollover(false);
        this.getModel().setSelected(false);
        ((JPopupMenu)e.getSource()).removePopupMenuListener(this);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public String getType() {
        return this.type;
    }

    protected abstract JPopupMenu getPopupMenu();
}

