/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image.measure;

public class MeasurementsAdapter {
    private final double calibRatio;
    private final boolean upYAxis;
    private final int offsetX;
    private final int offsetY;
    private final int imageHeight;
    private final String unit;

    public MeasurementsAdapter(double calibRatio, int offsetX, int offsetY, boolean upYAxis, int imageHeight, String unit) {
        this.offsetY = offsetY;
        this.offsetX = offsetX;
        this.upYAxis = upYAxis;
        this.calibRatio = calibRatio;
        this.imageHeight = imageHeight - 1;
        this.unit = unit;
    }

    public double getCalibRatio() {
        return this.calibRatio;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public boolean isUpYAxis() {
        return this.upYAxis;
    }

    public String getUnit() {
        return this.unit;
    }

    public double getXUncalibratedValue(double xVal) {
        return xVal + (double)this.offsetX;
    }

    public double getYUncalibratedValue(double yVal) {
        if (this.upYAxis) {
            yVal = (double)this.imageHeight - yVal;
        }
        return yVal + (double)this.offsetY;
    }

    public double getXCalibratedValue(double xVal) {
        return this.calibRatio * (xVal + (double)this.offsetX);
    }

    public double getYCalibratedValue(double yVal) {
        if (this.upYAxis) {
            yVal = (double)this.imageHeight - yVal;
        }
        return this.calibRatio * (yVal + (double)this.offsetY);
    }
}

