/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image.op;

import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import org.weasis.core.api.image.op.RectifySignedShortDataOpImage;

public class RectifySignedShortDataDescriptor
extends OperationDescriptorImpl
implements RenderedImageFactory {
    private static final String[][] resources = new String[][]{{"GlobalName", "RectifySignedShortData"}, {"LocalName", "RectifySignedShortData"}, {"Vendor", ""}, {"Description", "Operation to read correctly signed images (9-15 bits) (Workaround for imageio codecs issue"}, {"DocURL", ""}, {"Version", "1.0"}, {"arg0Desc", "Number of signifative bits"}};
    private static final Class[] paramClasses = new Class[]{int[].class};
    private static final String[] paramNames = new String[]{"bits"};
    private static final Object[] paramDefaults = new Object[]{new int[]{0}};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};

    public RectifySignedShortDataDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    public boolean validateArguments(String modeName, ParameterBlock args, StringBuffer message) {
        if (!super.validateArguments(modeName, args, message)) {
            return false;
        }
        if (!modeName.equalsIgnoreCase("rendered")) {
            return true;
        }
        RenderedImage src = args.getRenderedSource(0);
        int dtype = src.getSampleModel().getDataType();
        if (dtype != 2) {
            return false;
        }
        int length = ((int[])args.getObjectParameter(0)).length;
        return length >= 1;
    }

    @Override
    public RenderedImage create(ParameterBlock args, RenderingHints renderHints) {
        ImageLayout layout = RIFUtil.getImageLayoutHint((RenderingHints)renderHints);
        return new RectifySignedShortDataOpImage(args.getRenderedSource(0), renderHints, layout, (int[])args.getObjectParameter(0));
    }

    public static RenderedOp create(RenderedImage source0, int[] constants, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("RectifySignedShortData", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("bits", (Object)constants);
        return JAI.create((String)"RectifySignedShortData", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(RenderableImage source0, int[] constants, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("RectifySignedShortData", "renderable");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("bits", (Object)constants);
        return JAI.createRenderable((String)"RectifySignedShortData", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

