/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.service;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.felix.prefs.BackingStoreManager;
import org.apache.felix.prefs.PreferencesDescription;
import org.apache.felix.prefs.PreferencesImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.gui.util.AbstractProperties;
import org.weasis.core.api.service.StreamBackingStoreImpl;
import org.weasis.core.api.util.FileUtil;

public class DataFileBackingStoreImpl
extends StreamBackingStoreImpl {
    private static final Logger logger = LoggerFactory.getLogger(DataFileBackingStoreImpl.class);
    private final BundleContext context;
    private final File prefRootDirectory;
    private final String user;

    public DataFileBackingStoreImpl(BundleContext context) {
        super(context);
        this.context = context;
        this.prefRootDirectory = new File(AbstractProperties.WEASIS_PATH + File.separator, "preferences");
        this.prefRootDirectory.mkdirs();
        this.user = System.getProperty("weasis.user", null);
    }

    @Override
    protected void checkAccess() throws BackingStoreException {
        if (this.prefRootDirectory == null || !this.prefRootDirectory.exists()) {
            throw new BackingStoreException("Saving of data files to the bundle context is currently not supported.");
        }
    }

    @Override
    protected OutputStream getOutputStream(PreferencesDescription desc) throws IOException {
        File file = this.getFile(desc);
        FileUtil.isWriteable(file);
        return new FileOutputStream(file);
    }

    public Long[] availableBundles() {
        return new Long[0];
    }

    protected PreferencesDescription getDescription(File file) {
        String fileName = file.getName();
        if (fileName.endsWith(".xml")) {
            String folder;
            String key = fileName.substring(0, fileName.length() - 4);
            String identifier = null;
            File parent = file.getParentFile();
            if (parent != null && !"preferences".equals(folder = file.getName())) {
                identifier = folder;
            }
            if (identifier == this.user) {
                Bundle[] bundles;
                for (Bundle bundle : bundles = this.context.getBundles()) {
                    if (!bundle.getSymbolicName().equals(key)) continue;
                    return new PreferencesDescription(Long.valueOf(bundle.getBundleId()), identifier);
                }
            }
        }
        return null;
    }

    public void remove(Long bundleId) throws BackingStoreException {
    }

    public PreferencesImpl[] loadAll(BackingStoreManager manager, Long bundleId) throws BackingStoreException {
        PreferencesImpl[] preferencesImplArray;
        this.checkAccess();
        PreferencesImpl pref = this.load(manager, new PreferencesDescription(bundleId, this.user));
        if (pref == null) {
            preferencesImplArray = new PreferencesImpl[]{};
        } else {
            PreferencesImpl[] preferencesImplArray2 = new PreferencesImpl[1];
            preferencesImplArray = preferencesImplArray2;
            preferencesImplArray2[0] = pref;
        }
        return preferencesImplArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PreferencesImpl load(BackingStoreManager manager, PreferencesDescription desc) throws BackingStoreException {
        this.checkAccess();
        File file = this.getFile(desc);
        if (file != null && file.exists()) {
            PreferencesImpl preferencesImpl;
            XMLStreamReader xmler = null;
            FileReader fileReader = null;
            try {
                PreferencesImpl root = new PreferencesImpl(desc, manager);
                XMLInputFactory xmlif = XMLInputFactory.newInstance();
                fileReader = new FileReader(file);
                xmler = xmlif.createXMLStreamReader(fileReader);
                while (xmler.hasNext()) {
                    int eventType = xmler.next();
                    switch (eventType) {
                        case 1: {
                            String key = xmler.getName().getLocalPart();
                            if (!"preferences".equals(key)) break;
                            block12: while (xmler.hasNext()) {
                                eventType = xmler.next();
                                switch (eventType) {
                                    case 1: {
                                        this.read(root, xmler, xmler.getName().getLocalPart());
                                        continue block12;
                                    }
                                }
                            }
                            break;
                        }
                    }
                }
                root.getChangeSet().clear();
                preferencesImpl = root;
            }
            catch (XMLStreamException e) {
                try {
                    logger.error("Preferences file is corrupted: ", (Object)file.getAbsolutePath());
                    throw new BackingStoreException("Unable to load preferences.", (Throwable)e);
                    catch (FileNotFoundException e2) {
                        throw new BackingStoreException("Unable to load preferences.", (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    FileUtil.safeClose(xmler);
                    FileUtil.safeClose(fileReader);
                    throw throwable;
                }
            }
            FileUtil.safeClose(xmler);
            FileUtil.safeClose(fileReader);
            return preferencesImpl;
        }
        return null;
    }

    protected File getFile(PreferencesDescription desc) {
        Bundle bundle = this.context.getBundle(desc.getBundleId().longValue());
        if (bundle == null) {
            return null;
        }
        if (desc.getIdentifier() != null) {
            return new File(this.prefRootDirectory + File.separator + desc.getIdentifier(), bundle.getSymbolicName() + ".xml");
        }
        return new File(this.prefRootDirectory, bundle.getSymbolicName() + ".xml");
    }
}

