/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.weasis.core.api.gui.util.AbstractProperties;
import org.weasis.core.api.media.data.MediaElement;
import org.weasis.core.api.media.data.MediaSeries;
import org.weasis.core.api.media.data.Series;
import org.weasis.core.api.media.data.TagW;
import org.weasis.dicom.codec.DicomMediaIO;
import org.weasis.dicom.codec.DicomSeries;
import org.weasis.dicom.codec.DicomVideoElement;
import org.weasis.dicom.codec.FileExtractor;
import org.weasis.dicom.codec.Messages;

public class DicomVideoSeries
extends Series<DicomVideoElement>
implements FileExtractor {
    private int width = 256;
    private int height = 256;
    private int frames = 0;

    public DicomVideoSeries(String subseriesInstanceUID) {
        super(TagW.SubseriesInstanceUID, (Object)subseriesInstanceUID, TagW.SubseriesInstanceUID);
    }

    public DicomVideoSeries(DicomSeries dicomSeries) {
        super(TagW.SubseriesInstanceUID, dicomSeries.getTagValue(TagW.SubseriesInstanceUID), TagW.SubseriesInstanceUID);
        Iterator iter = dicomSeries.getTagEntrySetIterator();
        while (iter.hasNext()) {
            Map.Entry e = (Map.Entry)iter.next();
            this.setTag((TagW)e.getKey(), e.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMedia(MediaElement media) {
        if (media instanceof DicomVideoElement && media.getMediaReader() instanceof DicomMediaIO) {
            DicomMediaIO dicomImageLoader = (DicomMediaIO)media.getMediaReader();
            this.frames = dicomImageLoader.getMediaElementNumber();
            byte[] mpeg = null;
            try {
                this.width = dicomImageLoader.getWidth(0);
                this.height = dicomImageLoader.getHeight(0);
                dicomImageLoader.readPixelData();
                mpeg = dicomImageLoader.getDicomObject().get(TagW.PixelData.getId()).getFragment(1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (mpeg != null) {
                OutputStream tempFileStream = null;
                try {
                    File videoFile = File.createTempFile("video_", ".mpg", AbstractProperties.APP_TEMP_DIR);
                    tempFileStream = new BufferedOutputStream(new FileOutputStream(videoFile));
                    tempFileStream.write(mpeg);
                    DicomVideoElement dicom = (DicomVideoElement)media;
                    dicom.setVideoFile(videoFile);
                    this.medias.add(dicom);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (tempFileStream != null) {
                        try {
                            tempFileStream.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getToolTips() {
        StringBuffer toolTips = new StringBuffer();
        toolTips.append("<html>");
        this.addToolTipsElement(toolTips, Messages.getString("DicomSeries.pat"), TagW.PatientName);
        this.addToolTipsElement(toolTips, Messages.getString("DicomSeries.mod"), TagW.Modality);
        this.addToolTipsElement(toolTips, Messages.getString("DicomSeries.series_nb"), TagW.SeriesNumber);
        this.addToolTipsElement(toolTips, Messages.getString("DicomSeries.study"), TagW.StudyDescription);
        this.addToolTipsElement(toolTips, Messages.getString("DicomSeries.series"), TagW.SeriesDescription);
        toolTips.append(Messages.getString("DicomSeries.date") + this.getDate() + "<br>");
        toolTips.append(Messages.getString("DicomVideo.video_l"));
        toolTips.append("</html>");
        return toolTips.toString();
    }

    public String toString() {
        return (String)this.getTagValue(TagW.SubseriesInstanceUID);
    }

    public String getDate() {
        Date seriesDate = (Date)this.getTagValue(TagW.SeriesDate);
        if (seriesDate != null) {
            return new SimpleDateFormat("dd/MM/yyyy").format(seriesDate);
        }
        return "";
    }

    public String getMimeType() {
        return "video/dicom";
    }

    @Override
    public File getExtractFile() {
        DicomVideoElement media = (DicomVideoElement)this.getMedia(MediaSeries.MEDIA_POSITION.FIRST);
        if (media != null) {
            return media.getVideoFile();
        }
        return null;
    }
}

