/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec.geometry;

import org.weasis.dicom.codec.geometry.GeometryOfSlice;

public abstract class GeometryOfVolume {
    protected GeometryOfSlice[] frames;
    protected boolean isVolume;

    public final GeometryOfSlice[] getGeometryOfSlices() {
        return this.frames;
    }

    public final double[] lookupImageCoordinate(int column, int row, int frame) {
        double[] location = null;
        if (this.frames != null && frame < this.frames.length && this.frames[frame] != null) {
            location = this.frames[frame].lookupImageCoordinate(column, row);
        }
        return location;
    }

    public final void lookupImageCoordinate(double[] location, int column, int row, int frame) {
        if (this.frames != null && frame < this.frames.length && this.frames[frame] != null) {
            this.frames[frame].lookupImageCoordinate(location, column, row);
        } else {
            location[0] = 0.0;
            location[1] = 0.0;
            location[2] = 0.0;
        }
    }

    public final double[] lookupImageCoordinate(double[] location) {
        double[] offsets = new double[3];
        this.lookupImageCoordinate(offsets, location);
        return offsets;
    }

    public final void lookupImageCoordinate(double[] offsets, double[] location) {
        double[] rowArray = this.frames[0].getRowArray();
        double[] columnArray = this.frames[0].getColumnArray();
        double[] normalArray = this.frames[0].getNormalArray();
        double[] tlhcArray = this.frames[0].getTLHCArray();
        double[] voxelSpacingArray = this.frames[0].getVoxelSpacingArray();
        double frame = (((location[0] - tlhcArray[0]) * columnArray[1] * voxelSpacingArray[0] - (location[1] - tlhcArray[1]) * columnArray[0] * voxelSpacingArray[0]) * (rowArray[2] * voxelSpacingArray[1] * columnArray[1] * voxelSpacingArray[0] - rowArray[1] * voxelSpacingArray[1] * columnArray[2] * voxelSpacingArray[0]) - ((location[2] - tlhcArray[2]) * columnArray[1] * voxelSpacingArray[0] - (location[1] - tlhcArray[1]) * columnArray[2] * voxelSpacingArray[0]) * (rowArray[0] * voxelSpacingArray[1] * columnArray[1] * voxelSpacingArray[0] - rowArray[1] * voxelSpacingArray[1] * columnArray[0] * voxelSpacingArray[0])) / ((normalArray[0] * voxelSpacingArray[2] * columnArray[1] * voxelSpacingArray[0] + normalArray[1] * voxelSpacingArray[2] * columnArray[0] * voxelSpacingArray[0]) * (rowArray[2] * voxelSpacingArray[1] * columnArray[1] * voxelSpacingArray[0] - rowArray[1] * voxelSpacingArray[1] * columnArray[2] * voxelSpacingArray[0]) - (normalArray[2] * voxelSpacingArray[2] * columnArray[1] * voxelSpacingArray[0] + normalArray[1] * voxelSpacingArray[2] * columnArray[2] * voxelSpacingArray[0]) * (rowArray[0] * voxelSpacingArray[1] * columnArray[1] * voxelSpacingArray[0] - rowArray[1] * voxelSpacingArray[1] * columnArray[0] * voxelSpacingArray[0]));
        double column = ((location[0] - tlhcArray[0] - frame * normalArray[0] * voxelSpacingArray[2]) * columnArray[1] * voxelSpacingArray[0] - (location[1] - tlhcArray[1] - frame * normalArray[1] * voxelSpacingArray[2]) * columnArray[0] * voxelSpacingArray[0]) / (rowArray[0] * voxelSpacingArray[1] * columnArray[1] * voxelSpacingArray[0] - rowArray[1] * voxelSpacingArray[1] * columnArray[0] * voxelSpacingArray[0]);
        double row = (location[1] - tlhcArray[1] - column * rowArray[1] * voxelSpacingArray[1] - frame * normalArray[1] * voxelSpacingArray[2]) / (columnArray[1] * voxelSpacingArray[0]);
        offsets[0] = column;
        offsets[1] = row;
        offsets[2] = frame;
    }

    public final int findClosestSliceInSamePlane(GeometryOfSlice otherSlice) {
        double otherDistance = otherSlice.getDistanceAlongNormalFromOrigin();
        int found = -1;
        double closest = 9.99999999E8;
        for (int i = 0; i < this.frames.length; ++i) {
            double distance = Math.abs(this.frames[i].getDistanceAlongNormalFromOrigin() - otherDistance);
            if (!(distance < closest)) continue;
            closest = distance;
            found = i;
        }
        return found;
    }

    public final double[] getDistanceAlongNormalFromOrigin() {
        double[] distances = new double[this.frames.length];
        for (int i = 0; i < this.frames.length; ++i) {
            distances[i] = this.frames[i].getDistanceAlongNormalFromOrigin();
        }
        return distances;
    }

    public final boolean isVolumeSampledRegularlyAlongFrameDimension() {
        return this.isVolume;
    }

    public final void checkAndSetVolumeSampledRegularlyAlongFrameDimension() {
        if (this.frames != null && this.frames.length > 1) {
            GeometryOfSlice lastGeometry = this.frames[0];
            GeometryOfSlice currentGeometry = this.frames[1];
            double lastDistanceAlongNormal = lastGeometry.getDistanceAlongNormalFromOrigin();
            if (GeometryOfSlice.areSlicesParallel(lastGeometry, currentGeometry)) {
                int f;
                double currentDistanceAlongNormal = currentGeometry.getDistanceAlongNormalFromOrigin();
                double wantIntervalAlongNormal = currentDistanceAlongNormal - lastDistanceAlongNormal;
                lastDistanceAlongNormal = currentDistanceAlongNormal;
                boolean success = true;
                for (f = 2; f < this.frames.length && success; ++f) {
                    currentGeometry = this.frames[f];
                    if (GeometryOfSlice.areSlicesParallel(lastGeometry, currentGeometry)) {
                        currentDistanceAlongNormal = currentGeometry.getDistanceAlongNormalFromOrigin();
                        double currentIntervalAlongNormal = currentDistanceAlongNormal - lastDistanceAlongNormal;
                        if (Math.abs(currentIntervalAlongNormal - wantIntervalAlongNormal) >= 0.001) {
                            success = false;
                        }
                        lastDistanceAlongNormal = currentDistanceAlongNormal;
                        continue;
                    }
                    success = false;
                }
                if (success) {
                    this.isVolume = true;
                    wantIntervalAlongNormal = Math.abs(wantIntervalAlongNormal);
                    for (f = 0; f < this.frames.length; ++f) {
                        this.frames[f].setVoxelSpacingBetweenSlices(wantIntervalAlongNormal);
                    }
                }
            }
        }
    }

    public final String toString() {
        StringBuffer str = new StringBuffer();
        for (int f = 0; f < this.frames.length; ++f) {
            str.append("[");
            str.append(f);
            str.append("] ");
            str.append(this.frames[f].toString());
            str.append("\n");
        }
        return str.toString();
    }

    public final String getRowOrientation(int frame) {
        return this.frames != null && frame < this.frames.length ? this.frames[frame].getRowOrientation() : "";
    }

    public final String getColumnOrientation(int frame) {
        return this.frames != null && frame < this.frames.length ? this.frames[frame].getColumnOrientation() : "";
    }
}

