/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec.wado;

import org.weasis.core.api.media.data.TagW;

public class WadoParameters {
    public static final String TAG_DOCUMENT_ROOT = "wado_query";
    public static final String TAG_WADO_URL = "wadoURL";
    public static final String TAG_WADO_ONLY_SOP_UID = "requireOnlySOPInstanceUID";
    public static final String TAG_WADO_ADDITIONNAL_PARAMETERS = "additionnalParameters";
    public static final String TAG_WADO_OVERRIDE_TAGS = "overrideDicomTagsList";
    public static final String TAG_WADO_WEB_LOGIN = "webLogin";
    private final String wadoURL;
    private final boolean requireOnlySOPInstanceUID;
    private final String additionnalParameters;
    private final int[] overrideDicomTagIDList;
    private final String webLogin;

    public WadoParameters(String wadoURL, boolean requireOnlySOPInstanceUID, String additionnalParameters, String overrideDicomTagsList, String webLogin) {
        if (wadoURL == null) {
            throw new IllegalArgumentException("wadoURL cannot be null");
        }
        this.wadoURL = wadoURL;
        this.webLogin = webLogin == null ? null : webLogin.trim();
        this.requireOnlySOPInstanceUID = requireOnlySOPInstanceUID;
        String string = this.additionnalParameters = additionnalParameters == null ? "" : additionnalParameters;
        if (overrideDicomTagsList != null && !"".equals(overrideDicomTagsList.trim())) {
            String[] val = overrideDicomTagsList.split(",");
            this.overrideDicomTagIDList = new int[val.length];
            for (int i = 0; i < val.length; ++i) {
                try {
                    this.overrideDicomTagIDList[i] = Integer.decode(val[i].trim());
                    continue;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.overrideDicomTagIDList = null;
        }
    }

    public String getWebLogin() {
        return this.webLogin;
    }

    public String getWadoURL() {
        return this.wadoURL;
    }

    public boolean isRequireOnlySOPInstanceUID() {
        return this.requireOnlySOPInstanceUID;
    }

    public String getAdditionnalParameters() {
        return this.additionnalParameters;
    }

    public int[] getOverrideDicomTagIDList() {
        return this.overrideDicomTagIDList;
    }

    public boolean isOverrideTag(TagW tagElement) {
        if (this.overrideDicomTagIDList != null) {
            int tagID = tagElement.getId();
            for (int overTag : this.overrideDicomTagIDList) {
                if (tagID != overTag) continue;
                return true;
            }
        }
        return false;
    }
}

