/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.editor.image;

import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.gui.util.GUIEntry;
import org.weasis.core.ui.Messages;

public class SynchView
implements GUIEntry {
    public static final SynchView NONE = new SynchView(Messages.getString("SynchView.none"), Mode.None, null, new HashMap<ActionW, Boolean>());
    public static final SynchView DEFAULT_TILE;
    public static final SynchView DEFAULT_STACK;
    private final HashMap<ActionW, Boolean> actions;
    private final Mode mode;
    private final String name;
    private Icon icon;

    public SynchView(String name, Mode mode, Icon icon, HashMap<ActionW, Boolean> actions) {
        if (name == null || actions == null) {
            throw new IllegalArgumentException("A parameter is null!");
        }
        this.name = name;
        this.actions = actions;
        this.mode = mode;
        this.icon = icon;
    }

    public HashMap<ActionW, Boolean> getActions() {
        return this.actions;
    }

    public boolean isActionEnable(ActionW action) {
        Boolean bool = this.actions.get(action);
        return bool != null && bool != false;
    }

    public String toString() {
        return this.name;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String getDescription() {
        return null;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getUIName() {
        return this.name;
    }

    static {
        HashMap<Object, Boolean> actions = new HashMap<ActionW, Boolean>();
        actions.put(ActionW.SCROLL_SERIES, true);
        actions.put(ActionW.PAN, true);
        actions.put(ActionW.ZOOM, true);
        actions.put(ActionW.ROTATION, true);
        actions.put(ActionW.FLIP, true);
        actions.put(ActionW.WINDOW, true);
        actions.put(ActionW.LEVEL, true);
        actions.put(ActionW.PRESET, true);
        actions.put(ActionW.LUT, true);
        actions.put(ActionW.INVERSELUT, true);
        actions.put(ActionW.FILTER, true);
        actions.put(ActionW.VIEWINGPROTOCOL, true);
        actions.put(ActionW.IMAGE_OVERLAY, true);
        DEFAULT_TILE = new SynchView(Messages.getString("SynchView.def_t"), Mode.Tile, new ImageIcon(SynchView.class.getResource("/icon/22x22/tile.png")), actions);
        actions = new HashMap();
        actions.put(ActionW.SCROLL_SERIES, true);
        actions.put(ActionW.PAN, true);
        actions.put(ActionW.ZOOM, true);
        actions.put(ActionW.ROTATION, true);
        actions.put(ActionW.FLIP, true);
        actions.put(ActionW.VIEWINGPROTOCOL, true);
        actions.put(ActionW.IMAGE_OVERLAY, true);
        DEFAULT_STACK = new SynchView(Messages.getString("SynchView.def_s"), Mode.Stack, new ImageIcon(SynchView.class.getResource("/icon/22x22/sequence.png")), actions);
    }

    public static enum Mode {
        None,
        Stack,
        Tile;

    }
}

