/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.Graphic;
import org.weasis.core.ui.graphic.GraphicLabel;
import org.weasis.core.ui.graphic.model.AbstractLayer;
import org.weasis.core.ui.graphic.model.LayerModel;
import org.weasis.core.ui.util.MouseEventDouble;

public class DragLayer
extends AbstractLayer {
    private static final long serialVersionUID = 8576601524359423997L;

    public DragLayer(LayerModel canvas1, int drawMode) {
        super(canvas1, drawMode);
    }

    @Override
    public void paint(Graphics2D g2d, AffineTransform transform, AffineTransform inverseTransform, Rectangle2D bounds) {
        if (this.graphics == null) {
            return;
        }
        for (Graphic graphic : this.graphics) {
            if (bounds != null) {
                Rectangle repaintBounds = graphic.getRepaintBounds(transform);
                if (repaintBounds != null && repaintBounds.intersects(bounds)) {
                    graphic.paint(g2d, transform);
                    continue;
                }
                GraphicLabel graphicLabel = graphic.getGraphicLabel();
                Rectangle2D labelBounds = graphicLabel != null ? graphicLabel.getBounds(transform) : null;
                if (labelBounds == null || !labelBounds.intersects(bounds)) continue;
                graphic.paintLabel(g2d, transform);
                continue;
            }
            graphic.paint(g2d, transform);
            graphic.paintLabel(g2d, transform);
        }
    }

    public List getGraphicsSurfaceInArea(Rectangle rect, AffineTransform transform) {
        ArrayList<Graphic> graphicList = new ArrayList<Graphic>();
        if (this.graphics != null && rect != null) {
            for (Graphic graphic : this.graphics) {
                Area selectionArea;
                Area selectionArea2;
                Rectangle selectionBounds = graphic.getBounds(transform);
                if (selectionBounds != null && selectionBounds.intersects(rect) && (selectionArea2 = graphic.getArea(transform)) != null && selectionArea2.intersects(rect)) {
                    graphicList.add(graphic);
                    continue;
                }
                GraphicLabel graphicLabel = graphic.getGraphicLabel();
                if (graphicLabel == null || (selectionArea = graphicLabel.getArea(transform)) == null || !selectionArea.intersects(rect)) continue;
                graphicList.add(graphic);
            }
        }
        return graphicList;
    }

    public List getGraphicsBoundsInArea(Rectangle rect) {
        ArrayList<Graphic> arraylist = new ArrayList<Graphic>();
        if (this.graphics != null) {
            for (int j = this.graphics.size() - 1; j >= 0; --j) {
                Graphic graphic = (Graphic)this.graphics.get(j);
                if (!graphic.getRepaintBounds(this.getAffineTransform()).intersects(rect)) continue;
                arraylist.add(graphic);
            }
        }
        return arraylist;
    }

    @Override
    public Graphic getGraphicContainPoint(MouseEventDouble mouseevent) {
        AbstractDragGraphic selectedGraphic = null;
        if (this.graphics != null) {
            Point2D pos = mouseevent.getImageCoordinates();
            for (int j = this.graphics.size() - 1; j >= 0; --j) {
                AbstractDragGraphic graphic = (AbstractDragGraphic)this.graphics.get(j);
                if (!graphic.getRepaintBounds(this.getAffineTransform()).contains(pos) || !graphic.getArea(mouseevent).contains(pos) && graphic.getHandlePointIndex(mouseevent) == -1) continue;
                if (selectedGraphic == null || !graphic.isSelected()) {
                    selectedGraphic = graphic;
                    continue;
                }
                if (graphic.isSelected()) break;
            }
        }
        return selectedGraphic;
    }
}

