/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic.model;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.weasis.core.api.gui.util.GeomUtil;
import org.weasis.core.ui.graphic.Graphic;
import org.weasis.core.ui.graphic.GraphicLabel;
import org.weasis.core.ui.graphic.model.GraphicList;
import org.weasis.core.ui.graphic.model.GraphicsPane;
import org.weasis.core.ui.graphic.model.Layer;
import org.weasis.core.ui.graphic.model.LayerModel;
import org.weasis.core.ui.util.MouseEventDouble;

public abstract class AbstractLayer
implements Comparable,
Serializable,
Layer {
    private static final long serialVersionUID = -6113490831569841167L;
    protected final PropertyChangeListener pcl;
    protected final transient ArrayList<LayerModel> canvas = new ArrayList();
    private boolean masked;
    private int level;
    private final int drawType;
    protected volatile GraphicList graphics;

    public AbstractLayer(LayerModel canvas1, int drawMode) {
        this.drawType = drawMode;
        this.canvas.add(canvas1);
        this.graphics = new GraphicList();
        this.pcl = new PropertyChangeHandler();
    }

    public void addGraphic(Graphic graphic) {
        if (this.graphics != null && !this.graphics.contains(graphic)) {
            this.graphics.add(graphic);
            graphic.addPropertyChangeListener(this.pcl);
            ArrayList<AbstractLayer> layers = this.graphics.getLayers();
            if (layers != null) {
                for (AbstractLayer layer : layers) {
                    graphic.addPropertyChangeListener(layer.pcl);
                    layer.repaint(graphic.getRepaintBounds(this.getAffineTransform()));
                }
            }
        }
    }

    public void toFront(Graphic graphic) {
        if (this.graphics != null) {
            this.graphics.remove(graphic);
            this.graphics.add(graphic);
            this.repaint(graphic.getRepaintBounds(this.getAffineTransform()));
        }
    }

    public synchronized void setGraphics(GraphicList graphics) {
        if (this.graphics != graphics) {
            if (this.graphics != null) {
                this.graphics.removeLayer(this);
                for (Graphic graphic : this.graphics) {
                    graphic.removePropertyChangeListener(this.pcl);
                }
                this.getShowDrawing().setSelectedGraphics(null);
            }
            if (graphics == null) {
                this.graphics = new GraphicList();
            } else {
                this.graphics = graphics;
                this.graphics.addLayer(this);
                for (Graphic graphic : this.graphics) {
                    graphic.addPropertyChangeListener(this.pcl);
                }
            }
        }
    }

    public void toBack(Graphic graphic) {
        if (this.graphics != null) {
            this.graphics.remove(graphic);
            this.graphics.add(0, graphic);
            this.repaint(graphic.getRepaintBounds(this.getAffineTransform()));
        }
    }

    public void setShowDrawing(LayerModel canvas1) {
        if (this.canvas != null && !this.canvas.contains(canvas1)) {
            this.canvas.add(canvas1);
        }
    }

    public LayerModel getShowDrawing() {
        return this.canvas.get(0);
    }

    @Override
    public void setVisible(boolean flag) {
        this.masked = !flag;
    }

    @Override
    public boolean isVisible() {
        return !this.masked;
    }

    @Override
    public void setLevel(int i) {
        this.level = i;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    protected AffineTransform getAffineTransform() {
        GraphicsPane graphicsPane;
        LayerModel layerModel = this.getShowDrawing();
        if (layerModel != null && (graphicsPane = layerModel.getGraphicsPane()) != null) {
            return graphicsPane.getAffineTransform();
        }
        return null;
    }

    public void removeGraphicAndRepaint(Graphic graphic) {
        if (this.graphics != null) {
            this.graphics.remove(graphic);
        }
        graphic.removePropertyChangeListener(this.pcl);
        this.repaint(graphic.getTransformedBounds(graphic.getShape(), this.getAffineTransform()));
        if (graphic.isSelected()) {
            this.getShowDrawing().getSelectedGraphics().remove(graphic);
        }
    }

    public void removeGraphic(Graphic graphic) {
        if (this.graphics != null) {
            this.graphics.remove(graphic);
        }
        graphic.removePropertyChangeListener(this.pcl);
        if (graphic.isSelected()) {
            this.getShowDrawing().getSelectedGraphics().remove(graphic);
        }
    }

    public List<Graphic> getGraphics() {
        return this.graphics;
    }

    public abstract List<Graphic> getGraphicsSurfaceInArea(Rectangle var1, AffineTransform var2);

    public abstract List<Graphic> getGraphicsBoundsInArea(Rectangle var1);

    public abstract Graphic getGraphicContainPoint(MouseEventDouble var1);

    public abstract void paint(Graphics2D var1, AffineTransform var2, AffineTransform var3, Rectangle2D var4);

    public int compareTo(Object obj) {
        int anotherVal;
        int thisVal = this.getLevel();
        return thisVal < (anotherVal = ((AbstractLayer)obj).getLevel()) ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public void repaint(Rectangle rectangle) {
        for (int i = 0; i < this.canvas.size(); ++i) {
            this.canvas.get(i).repaint(rectangle);
        }
    }

    public void repaint() {
        for (int i = 0; i < this.canvas.size(); ++i) {
            this.canvas.get(i).repaint();
        }
    }

    protected Rectangle rectangleUnion(Rectangle rectangle, Rectangle rectangle1) {
        if (rectangle == null) {
            return rectangle1;
        }
        return rectangle1 == null ? rectangle : rectangle.union(rectangle1);
    }

    protected void graphicBoundsChanged(Graphic graphic, Shape oldShape, Shape shape, AffineTransform transform) {
        if (graphic != null) {
            if (oldShape == null) {
                Rectangle rect;
                if (shape != null && (rect = graphic.getTransformedBounds(shape, transform)) != null) {
                    this.repaint(rect);
                }
            } else if (shape == null) {
                Rectangle rect = graphic.getTransformedBounds(oldShape, transform);
                if (rect != null) {
                    this.repaint(rect);
                }
            } else {
                Rectangle rect = this.rectangleUnion(graphic.getTransformedBounds(oldShape, transform), graphic.getTransformedBounds(shape, transform));
                if (rect != null) {
                    this.repaint(rect);
                }
            }
        }
    }

    protected void labelBoundsChanged(Graphic graphic, GraphicLabel oldLabel, GraphicLabel newLabel, AffineTransform transform) {
        if (graphic != null) {
            if (oldLabel == null) {
                if (newLabel != null) {
                    Rectangle rect = graphic.getTransformedBounds(newLabel, transform);
                    GeomUtil.growRectangle((Rectangle2D)rect, (double)2.0);
                    if (rect != null) {
                        this.repaint(((RectangularShape)rect).getBounds());
                    }
                }
            } else if (newLabel == null) {
                Rectangle rect = graphic.getTransformedBounds(oldLabel, transform);
                GeomUtil.growRectangle((Rectangle2D)rect, (double)2.0);
                if (rect != null) {
                    this.repaint(((RectangularShape)rect).getBounds());
                }
            } else {
                Rectangle newRect = graphic.getTransformedBounds(newLabel, transform);
                GeomUtil.growRectangle((Rectangle2D)newRect, (double)2.0);
                Rectangle oldRect = graphic.getTransformedBounds(oldLabel, transform);
                GeomUtil.growRectangle((Rectangle2D)oldRect, (double)2.0);
                Rectangle rect = this.rectangleUnion(((RectangularShape)oldRect).getBounds(), ((RectangularShape)newRect).getBounds());
                if (rect != null) {
                    this.repaint(rect);
                }
            }
        }
    }

    public int getDrawType() {
        return this.drawType;
    }

    public void deleteAllGraphic() {
        if (this.graphics != null) {
            if (this.graphics.getLayerSize() >= 0) {
                this.setGraphics(null);
            } else {
                for (int i = this.graphics.size() - 1; i >= 0; --i) {
                    this.removeGraphic((Graphic)this.graphics.get(i));
                }
            }
            this.repaint();
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = -9094820911680205527L;

        @Override
        public void propertyChange(PropertyChangeEvent propertychangeevent) {
            Object obj = propertychangeevent.getSource();
            String s = propertychangeevent.getPropertyName();
            if (obj instanceof Graphic) {
                Graphic graph = (Graphic)obj;
                if ("bounds".equals(s)) {
                    AbstractLayer.this.graphicBoundsChanged(graph, (Shape)propertychangeevent.getOldValue(), (Shape)propertychangeevent.getNewValue(), AbstractLayer.this.getAffineTransform());
                } else if ("graphicLabel".equals(s)) {
                    AbstractLayer.this.labelBoundsChanged(graph, (GraphicLabel)propertychangeevent.getOldValue(), (GraphicLabel)propertychangeevent.getNewValue(), AbstractLayer.this.getAffineTransform());
                } else if ("remove".equals(s)) {
                    AbstractLayer.this.removeGraphic(graph);
                } else if ("remove.repaint".equals(s)) {
                    AbstractLayer.this.removeGraphicAndRepaint(graph);
                } else if ("toFront".equals(s)) {
                    AbstractLayer.this.toFront(graph);
                } else if ("toBack".equals(s)) {
                    AbstractLayer.this.toBack(graph);
                }
            }
        }

        private PropertyChangeHandler() {
        }
    }
}

