/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import javax.media.jai.JaiI18N;
import javax.media.jai.LookupTableJAI;

public class ColorCube
extends LookupTableJAI {
    public static final ColorCube BYTE_496 = ColorCube.createColorCube(0, 38, new int[]{4, 9, 6});
    public static final ColorCube BYTE_855 = ColorCube.createColorCube(0, 54, new int[]{8, 5, 5});
    private int[] dimension;
    private int[] dimsLessOne;
    private int[] multipliers;
    private int adjustedOffset;
    private int dataType;
    private int numBands;

    public static ColorCube createColorCube(int n, int n2, int[] nArray) {
        ColorCube colorCube;
        switch (n) {
            case 0: {
                colorCube = ColorCube.createColorCubeByte(n2, nArray);
                break;
            }
            case 2: {
                colorCube = ColorCube.createColorCubeShort(n2, nArray);
                break;
            }
            case 1: {
                colorCube = ColorCube.createColorCubeUShort(n2, nArray);
                break;
            }
            case 3: {
                colorCube = ColorCube.createColorCubeInt(n2, nArray);
                break;
            }
            case 4: {
                colorCube = ColorCube.createColorCubeFloat(n2, nArray);
                break;
            }
            case 5: {
                colorCube = ColorCube.createColorCubeDouble(n2, nArray);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ColorCube0"));
            }
        }
        return colorCube;
    }

    public static ColorCube createColorCube(int n, int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return ColorCube.createColorCube(n, 0, nArray);
    }

    private static ColorCube createColorCubeByte(int n, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayByte(n, nArray), n);
        colorCube.initFields(n, nArray);
        return colorCube;
    }

    private static ColorCube createColorCubeShort(int n, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayShort(n, nArray), n, false);
        colorCube.initFields(n, nArray);
        return colorCube;
    }

    private static ColorCube createColorCubeUShort(int n, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayUShort(n, nArray), n, true);
        colorCube.initFields(n, nArray);
        return colorCube;
    }

    private static ColorCube createColorCubeInt(int n, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayInt(n, nArray), n);
        colorCube.initFields(n, nArray);
        return colorCube;
    }

    private static ColorCube createColorCubeFloat(int n, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayFloat(n, nArray), n);
        colorCube.initFields(n, nArray);
        return colorCube;
    }

    private static ColorCube createColorCubeDouble(int n, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayDouble(n, nArray), n);
        colorCube.initFields(n, nArray);
        return colorCube;
    }

    private static Object createDataArray(int n, int n2, int[] nArray) {
        int n3;
        Object object;
        double d;
        double d2;
        int n4;
        int n5 = nArray.length;
        if (n5 == 0) {
            throw new RuntimeException(JaiI18N.getString("ColorCube1"));
        }
        for (int i = 0; i < n5; ++i) {
            if (nArray[i] != 0) continue;
            throw new RuntimeException(JaiI18N.getString("ColorCube2"));
        }
        int[] nArray2 = new int[n5];
        for (int i = 0; i < n5; ++i) {
            nArray2[i] = Math.abs(nArray[i]);
        }
        double d3 = nArray2[0];
        for (n4 = 1; n4 < n5; ++n4) {
            d3 *= (double)nArray2[n4];
        }
        if (d3 > 2.147483647E9) {
            throw new RuntimeException(JaiI18N.getString("ColorCube3"));
        }
        n4 = (int)d3;
        switch (n) {
            case 0: {
                d2 = 0.0;
                d = 255.0;
                object = new byte[n5][n4];
                break;
            }
            case 2: {
                d2 = -32768.0;
                d = 32767.0;
                object = new short[n5][n4];
                break;
            }
            case 1: {
                d2 = 0.0;
                d = 65535.0;
                object = new short[n5][n4];
                break;
            }
            case 3: {
                d2 = -2.147483648E9;
                d = 2.147483647E9;
                object = new int[n5][n4];
                break;
            }
            case 4: {
                d2 = -3.4028234663852886E38;
                d = 3.4028234663852886E38;
                object = new float[n5][n4];
                break;
            }
            case 5: {
                d2 = -1.7976931348623157E308;
                d = Double.MAX_VALUE;
                object = new double[n5][n4];
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ColorCube7"));
            }
        }
        if ((double)(n4 + n2) > d) {
            throw new RuntimeException(JaiI18N.getString("ColorCube4"));
        }
        int[] nArray3 = new int[n5];
        nArray3[0] = 1;
        for (n3 = 1; n3 < n5; ++n3) {
            nArray3[n3] = nArray3[n3 - 1] * nArray2[n3 - 1];
        }
        block19: for (n3 = 0; n3 < n5; ++n3) {
            double d4;
            int n6 = nArray2[n3];
            double d5 = n6 == 1 ? 0.0 : (n == 4 || n == 5 ? 1.0 / (double)(n6 - 1) : (d - d2) / (double)(n6 - 1));
            if (nArray[n3] < 0) {
                d5 = -d5;
                d4 = d;
            } else {
                d4 = d2;
            }
            int n7 = nArray3[n3];
            switch (n) {
                case 0: {
                    Object object2 = object;
                    int n8 = 0;
                    while (n8 < n4) {
                        double d6 = d4;
                        for (int i = 0; i < n6; ++i) {
                            for (int j = 0; j < n7; ++j) {
                                object2[n3][n8] = (byte)((int)(d6 + 0.5) & 0xFF);
                                ++n8;
                            }
                            d6 += d5;
                        }
                    }
                    continue block19;
                }
                case 1: 
                case 2: {
                    short[][] sArray = object;
                    int n8 = 0;
                    while (n8 < n4) {
                        double d7 = d4;
                        for (int i = 0; i < n6; ++i) {
                            for (int j = 0; j < n7; ++j) {
                                sArray[n3][n8] = (short)(d7 + 0.5);
                                ++n8;
                            }
                            d7 += d5;
                        }
                    }
                    continue block19;
                }
                case 3: {
                    int n9;
                    int[][] nArray4 = object;
                    int n8 = 0;
                    while (n8 < n4) {
                        double d8 = d4;
                        for (int i = 0; i < n6; ++i) {
                            for (n9 = 0; n9 < n7; ++n9) {
                                nArray4[n3][n8] = (int)(d8 + 0.5);
                                ++n8;
                            }
                            d8 += d5;
                        }
                    }
                    continue block19;
                }
                case 4: {
                    int n10;
                    int n9;
                    float[][] fArray = object;
                    int n8 = 0;
                    while (n8 < n4) {
                        double d9 = d4;
                        for (n9 = 0; n9 < n6; ++n9) {
                            for (n10 = 0; n10 < n7; ++n10) {
                                fArray[n3][n8] = (float)d9;
                                ++n8;
                            }
                            d9 += d5;
                        }
                    }
                    continue block19;
                }
                case 5: {
                    int n10;
                    double[][] dArray = object;
                    int n8 = 0;
                    while (n8 < n4) {
                        double d10 = d4;
                        for (n10 = 0; n10 < n6; ++n10) {
                            for (int i = 0; i < n7; ++i) {
                                dArray[n3][n8] = d10;
                                ++n8;
                            }
                            d10 += d5;
                        }
                    }
                    continue block19;
                }
                default: {
                    throw new RuntimeException(JaiI18N.getString("ColorCube5"));
                }
            }
        }
        return object;
    }

    private static byte[][] createDataArrayByte(int n, int[] nArray) {
        return (byte[][])ColorCube.createDataArray(0, n, nArray);
    }

    private static short[][] createDataArrayShort(int n, int[] nArray) {
        return (short[][])ColorCube.createDataArray(2, n, nArray);
    }

    private static short[][] createDataArrayUShort(int n, int[] nArray) {
        return (short[][])ColorCube.createDataArray(1, n, nArray);
    }

    private static int[][] createDataArrayInt(int n, int[] nArray) {
        return (int[][])ColorCube.createDataArray(3, n, nArray);
    }

    private static float[][] createDataArrayFloat(int n, int[] nArray) {
        return (float[][])ColorCube.createDataArray(4, n, nArray);
    }

    private static double[][] createDataArrayDouble(int n, int[] nArray) {
        return (double[][])ColorCube.createDataArray(5, n, nArray);
    }

    protected ColorCube(byte[][] byArray, int n) {
        super(byArray, n);
    }

    protected ColorCube(short[][] sArray, int n, boolean bl) {
        super(sArray, n, bl);
    }

    protected ColorCube(int[][] nArray, int n) {
        super(nArray, n);
    }

    protected ColorCube(float[][] fArray, int n) {
        super(fArray, n);
    }

    protected ColorCube(double[][] dArray, int n) {
        super(dArray, n);
    }

    private void initFields(int n, int[] nArray) {
        int n2;
        this.dimension = nArray;
        this.multipliers = new int[nArray.length];
        this.dimsLessOne = new int[nArray.length];
        this.multipliers[0] = 1;
        for (n2 = 1; n2 < this.multipliers.length; ++n2) {
            this.multipliers[n2] = this.multipliers[n2 - 1] * Math.abs(nArray[n2 - 1]);
        }
        for (n2 = 0; n2 < this.multipliers.length; ++n2) {
            if (nArray[n2] < 0) {
                this.multipliers[n2] = -this.multipliers[n2];
            }
            this.dimsLessOne[n2] = Math.abs(nArray[n2]) - 1;
        }
        this.adjustedOffset = n;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] <= 1 || this.multipliers[n2] >= 0) continue;
            this.adjustedOffset += Math.abs(this.multipliers[n2]) * this.dimsLessOne[n2];
        }
        this.dataType = this.getDataType();
        this.numBands = this.getNumBands();
    }

    public int[] getDimension() {
        return this.dimension;
    }

    public int[] getDimsLessOne() {
        return this.dimsLessOne;
    }

    public int[] getMultipliers() {
        return this.multipliers;
    }

    public int getAdjustedOffset() {
        return this.adjustedOffset;
    }

    public int findNearestEntry(float[] fArray) {
        int n = -1;
        n = this.adjustedOffset;
        switch (this.dataType) {
            case 0: {
                for (int i = 0; i < this.numBands; ++i) {
                    int n2 = (int)(fArray[i] * (float)this.dimsLessOne[i]);
                    if ((n2 & 0xFF) > 127) {
                        n2 += 256;
                    }
                    n += (n2 >> 8) * this.multipliers[i];
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.numBands; ++i) {
                    int n3 = (int)(fArray[i] - -32768.0f) * this.dimsLessOne[i];
                    if ((n3 & 0xFFFF) > Short.MAX_VALUE) {
                        n3 += 65536;
                    }
                    n += (n3 >> 16) * this.multipliers[i];
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.numBands; ++i) {
                    int n4 = (int)(fArray[i] * (float)this.dimsLessOne[i]);
                    if ((n4 & 0xFFFF) > Short.MAX_VALUE) {
                        n4 += 65536;
                    }
                    n += (n4 >> 16) * this.multipliers[i];
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.numBands; ++i) {
                    long l = (long)((fArray[i] - -2.1474836E9f) * (float)this.dimsLessOne[i]);
                    if (l > Integer.MAX_VALUE) {
                        l += 0L;
                    }
                    n += (int)(l >> 32) * this.multipliers[i];
                }
                break;
            }
            case 4: {
                for (int i = 0; i < this.numBands; ++i) {
                    float f = fArray[i] * (float)this.dimsLessOne[i];
                    int n5 = (int)f;
                    if (f - (float)n5 >= 0.5f) {
                        ++n5;
                    }
                    n += n5 * this.multipliers[i];
                }
                break;
            }
            case 5: {
                for (int i = 0; i < this.numBands; ++i) {
                    double d = fArray[i] * (float)this.dimsLessOne[i];
                    int n6 = (int)d;
                    if (d - (double)n6 >= 0.5) {
                        ++n6;
                    }
                    n += n6 * this.multipliers[i];
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ColorCube6"));
            }
        }
        return n;
    }
}

