/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.content;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentManager;
import org.noos.xing.mydoggy.ContentManagerUI;
import org.noos.xing.mydoggy.ContentManagerUIListener;
import org.noos.xing.mydoggy.ContentUI;
import org.noos.xing.mydoggy.event.ContentManagerUIEvent;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.PropertyChangeEventSource;
import org.noos.xing.mydoggy.plaf.persistence.InternalPersistenceDelegateFilterAdapter;
import org.noos.xing.mydoggy.plaf.ui.ResourceManager;
import org.noos.xing.mydoggy.plaf.ui.cmp.ContentDialog;
import org.noos.xing.mydoggy.plaf.ui.cmp.ContentFrame;
import org.noos.xing.mydoggy.plaf.ui.content.PlafContent;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MyDoggyContentManagerUI<T extends ContentUI>
extends PropertyChangeEventSource
implements PropertyChangeListener {
    protected ContentManagerUI contentManagerUI;
    protected MyDoggyToolWindowManager toolWindowManager;
    protected ContentManager contentManager;
    protected ResourceManager resourceManager;
    protected Map<Content, T> contentUIMap;
    protected boolean closeable = true;
    protected boolean detachable = true;
    protected boolean minimizable = true;
    protected boolean maximizable = true;
    protected boolean installed;
    protected boolean uninstalling;
    protected boolean popupMenuEnabled = true;
    protected PropertyChangeSupport internalPropertyChangeSupport;
    protected EventListenerList contentManagerUIListeners = new EventListenerList();
    protected PropertyChangeListener contentUIListener;
    protected Content maximizedContent;
    protected Content previousLastSelected = null;
    protected Content lastSelected;
    protected boolean valueAdjusting;
    protected boolean contentValueAdjusting;

    public MyDoggyContentManagerUI() {
        this.contentUIMap = new Hashtable<Content, T>();
    }

    public void setCloseable(boolean closeable) {
        boolean old = this.closeable;
        this.closeable = closeable;
        for (ContentUI contentUI : this.contentUIMap.values()) {
            contentUI.setCloseable(closeable);
        }
        this.fireContentManagerUIProperty("closeable", old, closeable);
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setDetachable(boolean detachable) {
        boolean old = this.detachable;
        this.detachable = detachable;
        for (ContentUI contentUI : this.contentUIMap.values()) {
            contentUI.setDetachable(detachable);
        }
        this.fireContentManagerUIProperty("detachable", old, detachable);
    }

    public boolean isDetachable() {
        return this.detachable;
    }

    public void setMinimizable(boolean minimizable) {
        boolean old = this.minimizable;
        this.minimizable = minimizable;
        for (ContentUI contentUI : this.contentUIMap.values()) {
            contentUI.setMinimizable(minimizable);
        }
        this.fireContentManagerUIProperty("minimizable", old, minimizable);
    }

    public boolean isMinimizable() {
        return this.minimizable;
    }

    public void setMaximizable(boolean maximizable) {
        boolean old = this.maximizable;
        this.maximizable = maximizable;
        for (ContentUI contentUI : this.contentUIMap.values()) {
            contentUI.setMaximizable(maximizable);
        }
        this.fireContentManagerUIProperty("maximizable", old, maximizable);
    }

    public boolean isMaximizable() {
        return this.maximizable;
    }

    public boolean isPopupMenuEnabled() {
        return this.popupMenuEnabled;
    }

    public void setPopupMenuEnabled(boolean popupMenuEnabled) {
        if (this.popupMenuEnabled == popupMenuEnabled) {
            return;
        }
        boolean old = this.popupMenuEnabled;
        this.popupMenuEnabled = popupMenuEnabled;
        this.fireContentManagerUIProperty("popupMenuEnabled", old, popupMenuEnabled);
    }

    public T getContentUI(Content content) {
        return (T)((ContentUI)this.contentUIMap.get(content));
    }

    public void addContentManagerUIListener(ContentManagerUIListener listener) {
        this.contentManagerUIListeners.add(ContentManagerUIListener.class, listener);
    }

    public void removeContentManagerUIListener(ContentManagerUIListener listener) {
        this.contentManagerUIListeners.remove(ContentManagerUIListener.class, listener);
    }

    public ContentManagerUIListener[] getContentManagerUiListener() {
        return (ContentManagerUIListener[])this.contentManagerUIListeners.getListeners(ContentManagerUIListener.class);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.internalPropertyChangeSupport.firePropertyChange(evt);
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void addContent(PlafContent content, Object ... constraints) {
        if (this.maximizedContent != null) {
            this.maximizedContent.setMaximized(false);
            this.maximizedContent = null;
        }
        this.addUIForContent(content, constraints);
        content.addPlafPropertyChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContent(PlafContent content) {
        try {
            if (content.isDetached()) {
                this.propertyChange(new PropertyChangeEvent(content, "detached.dispose", true, false));
            } else if (content.isMinimized()) {
                this.toolWindowManager.getDockableDescriptor(content.getId()).setAvailable(false);
            } else {
                this.removeUIForContent(content);
            }
        }
        finally {
            content.getContentUI().removePropertyChangeListener(this.contentUIListener);
            content.removePlafPropertyChangeListener(this);
            this.toolWindowManager.removeDockableDescriptor(content.getId());
            this.contentUIMap.remove(content);
            if (this.lastSelected == content) {
                this.lastSelected = null;
            }
        }
    }

    public boolean isSelected(Content content) {
        return content == this.lastSelected;
    }

    protected abstract Object addUIForContent(Content var1, Object ... var2);

    protected abstract void removeUIForContent(Content var1);

    protected void setContentManagerUI(ContentManagerUI contentManagerUI) {
        this.contentManagerUI = contentManagerUI;
    }

    protected Content getMaximizedContent() {
        for (Content content : this.contentManager.getContents()) {
            if (!content.isMaximized()) continue;
            return content;
        }
        return null;
    }

    protected boolean isContentManagerEnabled() {
        return this.contentManager.isEnabled();
    }

    protected boolean isFocusAncestor(Component c) {
        return SwingUtil.isAncestor(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), c);
    }

    protected Component findAndRequestFocus(Component component) {
        Container container;
        if (component instanceof JDialog) {
            container = ((JDialog)component).getContentPane();
        } else if (component instanceof Container) {
            container = (Container)component;
        } else {
            return null;
        }
        Component focusRequester = SwingUtil.findFocusable(container);
        if (focusRequester == null) {
            focusRequester = container;
        }
        SwingUtil.requestFocus(focusRequester);
        return focusRequester;
    }

    protected boolean fireContentUIRemoving(ContentUI contentUI) {
        ContentManagerUIEvent event = new ContentManagerUIEvent(this.contentManagerUI, ContentManagerUIEvent.ActionId.CONTENTUI_REMOVING, contentUI);
        for (ContentManagerUIListener listener : (ContentManagerUIListener[])this.contentManagerUIListeners.getListeners(ContentManagerUIListener.class)) {
            if (listener.contentUIRemoving(event)) continue;
            return false;
        }
        return true;
    }

    protected void fireContentUIDetached(ContentUI contentUI) {
        ContentManagerUIEvent event = new ContentManagerUIEvent(this.contentManagerUI, ContentManagerUIEvent.ActionId.CONTENTUI_DETACHED, contentUI);
        for (ContentManagerUIListener listener : (ContentManagerUIListener[])this.contentManagerUIListeners.getListeners(ContentManagerUIListener.class)) {
            listener.contentUIDetached(event);
        }
    }

    protected void fireContentManagerUIProperty(String property, Object oldValue, Object newValue) {
        this.firePropertyChangeEvent(new PropertyChangeEvent(this.contentManagerUI, property, oldValue, newValue));
    }

    public class ContentManagerUIPersistenceDelegateFilter
    extends InternalPersistenceDelegateFilterAdapter {
        public boolean saveSelectedContent() {
            return false;
        }
    }

    public class ContentUIListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            ContentUI contentUI = (ContentUI)evt.getSource();
            if (contentUI.getContent().isDetached()) {
                if ("detachedBounds".equals(evt.getPropertyName())) {
                    Window window = SwingUtilities.windowForComponent(contentUI.getContent().getComponent());
                    window.setBounds((Rectangle)evt.getNewValue());
                } else if ("addToTaskBar".equals(evt.getPropertyName())) {
                    Content content = contentUI.getContent();
                    Window oldWindow = SwingUtilities.windowForComponent(contentUI.getContent().getComponent());
                    Frame parentFrame = MyDoggyContentManagerUI.this.toolWindowManager.getWindowAncestor() instanceof Frame ? (Frame)MyDoggyContentManagerUI.this.toolWindowManager.getWindowAncestor() : null;
                    Component focusOwner = oldWindow.getFocusOwner();
                    Window dialog = (Boolean)evt.getNewValue() != false ? new ContentFrame(content, contentUI, parentFrame, oldWindow.getBounds()) : new ContentDialog(content, contentUI, parentFrame, oldWindow.getBounds());
                    dialog.setBounds(oldWindow.getBounds());
                    dialog.addWindowFocusListener(new ContentDialogFocusListener(content));
                    dialog.toFront();
                    oldWindow.setVisible(false);
                    oldWindow.dispose();
                    dialog.setVisible(true);
                    if (focusOwner != null) {
                        SwingUtil.requestFocus(focusOwner);
                    }
                }
            }
        }
    }

    public class ContentDialogFocusListener
    implements WindowFocusListener {
        protected Content content;

        public ContentDialogFocusListener(Content content) {
            this.content = content;
        }

        public void windowGainedFocus(WindowEvent e) {
            if (!MyDoggyContentManagerUI.this.valueAdjusting && !MyDoggyContentManagerUI.this.contentValueAdjusting) {
                System.out.println(e.getComponent());
                Content newSelected = this.content;
                if (newSelected == MyDoggyContentManagerUI.this.lastSelected) {
                    return;
                }
                if (MyDoggyContentManagerUI.this.lastSelected != null) {
                    try {
                        MyDoggyContentManagerUI.this.lastSelected.setSelected(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                newSelected.setSelected(true);
                MyDoggyContentManagerUI.this.lastSelected = newSelected;
            }
        }

        public void windowLostFocus(WindowEvent e) {
        }
    }
}

