package org.phosphoresce.commons.csv;

import java.io.Serializable;

import org.phosphoresce.commons.util.StringUtil;

/**
 * CSVg[NGgێNXB<br>
 * NXێg[NlCSVlƂăGR[hꂽł͂Ȃ
 * ʏ̕(ufoo,"bar"vu"foo,""bar"""vƂĂ͈Ȃ)ŕێ܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/02/16	Kitagawa		VK쐬
 *-->
 */
public final class CSVToken implements Serializable {

	/** CSVg[N؂蕶 */
	public static final String SEPARATOR = ",";

	/** CSVg[NNH[g */
	public static final String QUOTE = "\"";

	/** CSVg[Ns */
	public static final String NEWLINE = "\n";

	/** g[NGgl */
	private String value = null;

	/**
	 * RXgN^<br>
	 */
	public CSVToken() {
		super();
		this.value = "";
	}

	/**
	 * RXgN^<br>
	 * @param value g[NGgl
	 */
	public CSVToken(String value) {
		super();
		this.value = value;
	}

	/**
	 * g[NGgl擾܂B<br>
	 * @return g[NGgl
	 */
	public String getValue() {
		return value;
	}

	/**
	 * g[NGglݒ肵܂B<br>
	 * @param value g[NGgl
	 */
	public void setValue(String value) {
		this.value = value == null ? "" : value;
	}

	/**
	 * CSVg[NlƂăGR[hꂽl擾܂B<br>
	 * @return CSVg[NlƂăGR[hꂽl
	 */
	public String getEncodedValue() {
		return encode(value);
	}

	/**
	 * w肳ꂽCSVg[NƂẴGgɕϊĒ񋟂܂B<br>
	 * @param value ϊΏە
	 * @return CSVg[NƂẴGg
	 */
	public static String encode(String value) {
		if (StringUtil.isEmpty(value)) {
			return "";
		} else {
			if (value.indexOf(QUOTE) >= 0 //
					|| value.indexOf(SEPARATOR) >= 0 //
					|| value.indexOf(NEWLINE) >= 0 //
			) {
				StringBuffer buffer = new StringBuffer();

				buffer.append(QUOTE);
				buffer.append(StringUtil.replace(value, QUOTE, QUOTE + QUOTE));
				buffer.append(QUOTE);

				return buffer.toString();
			} else {
				return value;
			}
		}
	}

	/**
	 * w肳ꂽCSVg[Nʏ̕ɕϊĒ񋟂܂B<br>
	 * @param value ϊΏە
	 * @return ϊꂽʏ핶
	 */
	public static String decode(String value) {
		String render = value;
		if (render.startsWith(QUOTE) && render.endsWith(QUOTE)) {
			render = render.substring(1, render.length() - 1);
		}
		render = StringUtil.replace(render, QUOTE + QUOTE, QUOTE);
		return render;
	}
}
