package org.phosphoresce.commons.util;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * ɑ΂鑀s\bh񋟂NX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2005/07/02	Kitagawa		VK쐬
 * 2006/05/10	Kitagawa		isAsciiAoCg֌W\bhC^tF[XɃGR[hp[^ǉ
 * 2006/07/10	Kitagawa		ʂStringCX^X
 * 2007/01/19	Kitagawa		pLz`ǉ
 * 2007/02/01	Kitagawa		renderHTMLǉ
 * 2007/02/24	Kitagawa		escapeFilenameǉ
 *-->
 */
public final class StringUtil {

	/** 󕶎 */
	public static final String EMPTY = "";

	/** wLT */
	private static final String[] hexStrings = { "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f" };

	/** pL */
	public static final char[] SIGNS = { '!', '"', '#', '$', '%', '&', '\'', '(', ')', '=', '~', '|', '`', '{', '+', '*', '}', '<', '>', '?', '_', '-', '^', '\\', '@', '[', ';',
			':', ']', ',', '.', '/' };

	/** sR[h(CR+LF) */
	public static final String NEWLINE_CODE_CRLF = new String(new byte[] { 0x0D, 0x0A });

	/** sR[h(CR) */
	public static final String NEWLINE_CODE_CR = new String(new byte[] { 0x0D });

	/** sR[h(LF) */
	public static final String NEWLINE_CODE_LF = new String(new byte[] { 0x0A });

	/** fBtHgJavaLN^Zbg */
	public static final String DEFAULT_JAVA_CHARSET = "MS932";

	/** fBtHgo̓t@CLN^Zbg */
	public static final String DEFAULT_OUTPUTFILE_CHARSET = "8859_1";

	/**
	 * RXgN^<br>
	 */
	private StringUtil() {
		//
	}

	/**
	 * 񂪋ł邩肵܂B<br>
	 * @param source Ώە
	 * @return 񂪋󕶎܂null̏ꍇtrueԋp
	 */
	public static boolean isEmpty(String source) {
		return source == null || EMPTY.equals(source);
	}

	/**
	 * w肳ꂽ񂪑SĔpō\Ă邩肵܂B<br>
	 * @param value Ώە
	 * @return SĔpō\ĂꍇAtrueԋp
	 */
	public static boolean isAscii(String value) {
		return value.length() == value.getBytes().length;
	}

	/**
	 * w肳ꂽ񂪐ƂĈ邩肵܂B<br>
	 * @param source Ώە
	 * @return ƂĈꍇtrueԋp
	 */
	public static boolean isDigit(String source) {
		try {
			Double.valueOf(source);
			return true;
		} catch (Exception e) {
			return false;
		}
	}

	/**
	 * w肳ꂽ񂪐݂̂ō\ꂽ񂩔肵܂B<br>
	 * @param source Ώە
	 * @return 񂪐݂̂ō\ꂽ̏ꍇtrueԋp
	 */
	public static boolean isNumeric(String source) {
		if (isEmpty(source)) {
			return true;
		} else {
			for (int i = 0; i <= source.length() - 1; i++) {
				char c = source.charAt(i);
				if (!(c >= '0' && c <= '9')) {
					return false;
				}
			}
		}
		return true;
	}

	/**
	 * w肳ꂽ񂪐݂̂ō\ꂽ񂩔肵܂B<br>
	 * @param source Ώە
	 * @param exclude z
	 * @return 񂪐݂̂ō\ꂽ̏ꍇtrueԋp
	 */
	public static boolean isNumeric(String source, char[] exclude) {
		if (isEmpty(source)) {
			return true;
		} else {
			for (int i = 0; i <= source.length() - 1; i++) {
				char c = source.charAt(i);
				if (!(c >= '0' && c <= '9')) {
					boolean skip = false;

					for (int j = 0; j <= exclude.length - 1; j++) {
						if (c == exclude[j]) {
							skip = true;
						}
					}

					if (!skip) {
						return false;
					}
				}
			}
		}
		return true;
	}

	/**
	 * w肳ꂽ񂪉p݂̂ō\ꂽ񂩔肵܂B<br>
	 * @param source Ώە
	 * @return 񂪉p݂̂ō\ꂽ̏ꍇtrueԋp
	 */
	public static boolean isAlphabet(String source) {
		if (isEmpty(source)) {
			return true;
		} else {
			for (int i = 0; i <= source.length() - 1; i++) {
				char c = source.charAt(i);
				if (!((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z'))) {
					return false;
				}
			}
		}
		return true;
	}

	/**
	 * w肳ꂽ񂪉p݂̂ō\ꂽ񂩔肵܂B<br>
	 * @param source Ώە
	 * @return 񂪉p݂̂ō\ꂽ̏ꍇtrueԋp
	 */
	public static boolean isAlphaNumeric(String source) {
		if (isEmpty(source)) {
			return true;
		} else {
			for (int i = 0; i <= source.length() - 1; i++) {
				char c = source.charAt(i);
				if (!((c >= '0' && c <= '9') || (c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z'))) {
					return false;
				}
			}
		}
		return true;
	}

	/**
	 * w肳ꂽ񂪉p݂̂ō\ꂽ񂩔肵܂B<br>
	 * @param source Ώە
	 * @param exclude z
	 * @return 񂪉p݂̂ō\ꂽ̏ꍇtrueԋp
	 */
	public static boolean isAlphaNumeric(String source, char[] exclude) {
		if (isEmpty(source)) {
			return true;
		} else {
			for (int i = 0; i <= source.length() - 1; i++) {
				char c = source.charAt(i);
				if (!((c >= '0' && c <= '9') || (c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z'))) {
					boolean skip = false;

					for (int j = 0; j <= exclude.length - 1; j++) {
						if (c == exclude[j]) {
							skip = true;
						}
					}

					if (!skip) {
						return false;
					}
				}
			}
		}
		return true;
	}

	/**
	 * w肳ꂽ̕擾܂B<br>
	 * WString#length()\bhbv̂null̏ꍇ0ԋp܂B<br>
	 * @param source 擾Ώە
	 * @return w肳ꂽ̕
	 */
	public static int length(String source) {
		return source == null ? 0 : source.length();
	}

	/**
	 * w肳ꂽ񂪎w肳ꂽoCg͈͓ɂ邩肵܂B<br>
	 * @param source Ώە
	 * @param byteLength `FbN͈͒(byte)
	 * @return 񂪎w肳ꂽoCg͈͓Ɏ܂Ăꍇtrueԋp
	 */
	public static boolean isInLenghtByte(String source, int byteLength) {
		if (isEmpty(source)) {
			return true;
		} else {
			return source.getBytes().length > byteLength ? false : true;
		}
	}

	/**
	 * w肳ꂽ񂪎w肳ꂽoCg͈͓ɂ邩肵܂B<br>
	 * @param source Ώە
	 * @param byteLength `FbN͈͒(byte)
	 * @param encode GR[h
	 * @return 񂪎w肳ꂽoCg͈͓Ɏ܂Ăꍇtrueԋp
	 */
	public static boolean isInLenghtByte(String source, int byteLength, String encode) {
		if (isEmpty(source)) {
			return true;
		} else {
			try {
				return source.getBytes(encode).length > byteLength ? false : true;
			} catch (UnsupportedEncodingException e) {
				throw new RuntimeException("sȃGR[hw肳܂", e);
			}
		}
	}

	/**
	 * w肳ꂽ񂪎w肳ꂽ()ɂ邩肵܂B<br>
	 * @param source Ώە
	 * @param length `FbN͈͒()
	 * @return 񂪎w肳ꂽ()Ɏ܂Ăꍇtrueԋp
	 */
	public static boolean isInLength(String source, int length) {
		if (isEmpty(source)) {
			return true;
		} else {
			return source.length() > length ? false : true;
		}
	}

	/**
	 * w肳ꂽp肵܂B<br>
	 * @param c Ώە
	 * @return p̏ꍇtrueԋp
	 */
	public static boolean isAscii(char c) {
		return isInLenghtByte(String.valueOf(c), 1);
	}

	/**
	 * w肳ꂽw肳ꂽŒoĎ擾܂B<br>
	 * @param source oΏە
	 * @param length o
	 * @return w肳ꂽw肳ꂽŒo
	 */
	public static String left(String source, int length) {
		if (length <= 0) {
			return "";
		}

		if (isEmpty(source) || source.length() <= length) {
			return source;
		}

		return source.substring(0, length);
	}

	/**
	 * w肳ꂽw肳ꂽoCgŒoĎ擾܂B<br>
	 * @param source oΏە
	 * @param length ooCg
	 * @return w肳ꂽw肳ꂽŒo
	 */
	public static String leftb(String source, int length) {
		if (length <= 0) {
			return "";
		}

		if (isEmpty(source) || isInLenghtByte(source, length)) {
			return source;
		}

		return substrb(source, length);
	}

	/**
	 * w肳ꂽw肳ꂽoCgŒoĎ擾܂B<br>
	 * @param source oΏە
	 * @param length ooCg
	 * @param encode GR[h
	 * @return w肳ꂽw肳ꂽŒo
	 */
	public static String leftb(String source, int length, String encode) {
		if (length <= 0) {
			return "";
		}

		if (isEmpty(source) || isInLenghtByte(source, length, encode)) {
			return source;
		}

		return substrb(source, length, encode);
	}

	/**
	 * w肳ꂽEw肳ꂽŒoĎ擾܂B<br>
	 * @param source oΏە
	 * @param length o
	 * @return w肳ꂽEw肳ꂽŒo
	 */
	public static String right(String source, int length) {
		if (length <= 0) {
			return "";
		}

		if (isEmpty(source) || source.length() <= length) {
			return source;
		}

		return source.substring(source.length() - length);
	}

	/**
	 * w肳ꂽEw肳ꂽoCgŒoĎ擾܂B<br>
	 * @param source oΏە
	 * @param length ooCg
	 * @return w肳ꂽEw肳ꂽŒo
	 */
	public static String rightb(String source, int length) {
		if (length <= 0) {
			return "";
		}

		if (isEmpty(source) || isInLenghtByte(source, length)) {
			return source;
		}

		return substrb(source, length);
	}

	/**
	 * w肳ꂽEw肳ꂽoCgŒoĎ擾܂B<br>
	 * @param source oΏە
	 * @param length ooCg
	 * @param encode GR[h
	 * @return w肳ꂽEw肳ꂽŒo
	 */
	public static String rightb(String source, int length, String encode) {
		if (length <= 0) {
			return "";
		}

		if (isEmpty(source) || isInLenghtByte(source, length, encode)) {
			return source;
		}

		return substrb(source, length, encode);
	}

	/**
	 * w肳ꂽw肳ꂽCfbNX̊JnAI͈̔͂ŒoĎ擾܂B<br>
	 * @param source oΏە
	 * @param start oJnCfbNX
	 * @param end oICfbNX 
	 * @return w肳ꂽw肳ꂽCfbNX̊JnAI͈̔͂Œo
	 */
	public static String mid(String source, int start, int end) {
		if (end - start < 0) {
			return "";
		}

		if (isEmpty(source)) {
			return source;
		}

		if (source.length() - 1 <= start) {
			return EMPTY;
		} else {
			String buffer = right(source, source.length() - start);
			return left(buffer, end - start + 1);
		}
	}

	/**
	 * w肳ꂽw肳ꂽoCgCfbNX̊JnAI͈̔͂ŒoĎ擾܂B<br>
	 * @param source oΏە
	 * @param start oJnoCgCfbNX
	 * @param end oIoCgCfbNX 
	 * @return w肳ꂽw肳ꂽCfbNX̊JnAI͈̔͂Œo
	 */
	public static String midb(String source, int start, int end) {
		if (end - start < 0) {
			return "";
		}

		if (isEmpty(source)) {
			return source;
		}

		if (lenb(source) - 1 <= start) {
			return EMPTY;
		} else {
			String buffer = rightb(source, lenb(source) - start);
			return leftb(buffer, end - start + 1);
		}
	}

	/**
	 * w肳ꂽw肳ꂽoCgCfbNX̊JnAI͈̔͂ŒoĎ擾܂B<br>
	 * @param source oΏە
	 * @param start oJnoCgCfbNX
	 * @param end oIoCgCfbNX 
	 * @param encode GR[h
	 * @return w肳ꂽw肳ꂽCfbNX̊JnAI͈̔͂Œo
	 */
	public static String midb(String source, int start, int end, String encode) {
		if (end - start < 0) {
			return "";
		}

		if (isEmpty(source)) {
			return source;
		}

		if (lenb(source, encode) - 1 <= start) {
			return EMPTY;
		} else {
			String buffer = rightb(source, lenb(source, encode) - start, encode);
			return leftb(buffer, end - start + 1, encode);
		}
	}

	/**
	 * w肳ꂽ̕擾܂B<br>
	 * String#length()Ɠl̏ƂȂ邪NullPointerException̍lB<br>
	 * @param source 蕶
	 * @return 
	 */
	public static int len(String source) {
		return isEmpty(source) ? 0 : source.length();
	}

	/**
	 * w肳ꂽ̃oCg擾܂B<br>
	 * @param source 蕶
	 * @return oCg
	 */
	public static int lenb(String source) {
		return isEmpty(source) ? 0 : source.getBytes().length;
	}

	/**
	 * w肳ꂽ̃oCg擾܂B<br>
	 * @param source 蕶
	 * @param encode GR[h
	 * @return oCg
	 */
	public static int lenb(String source, String encode) {
		try {
			return isEmpty(source) ? 0 : source.getBytes(encode).length;
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException("sȃGR[hw肳܂", e);
		}
	}

	/**
	 * w肳ꂽ̒usǍʂ擾܂B<br>
	 * @param source ̑Ώۂ̕
	 * @param before uO̕
	 * @param after u̕
	 * @return u̕
	 */
	public static String replace(String source, String before, String after) {
		if (isEmpty(source) || source.indexOf(before) == -1) {
			return source;
		}

		StringBuffer buffer = new StringBuffer();

		int index = source.indexOf(before);
		buffer.append(source.substring(0, index) + after);

		if (index + before.length() < source.length()) {
			String rest = source.substring(index + before.length(), source.length());
			buffer.append(replace(rest, before, after));
		}

		return buffer.toString();
	}

	/**
	 * w肳ꂽSċtɕׂȂĒ񋟂܂B<br>
	 * @param source בւΏۂ̕
	 * @return w肳ꂽSċtɕׂȂ
	 */
	public static String reverse(String source) {
		return new StringBuffer(source).reverse().toString();
	}

	/**
	 * w肳ꂽɊ܂܂w蕶̐擾܂B<br>
	 * @param source Ώە
	 * @param ch 
	 * @return Ɋ܂܂w蕶̐
	 */
	public static int countChar(String source, char ch) {
		if (isEmpty(source)) {
			return 0;
		}

		int counter = 0;
		for (int i = 0; i <= source.length() - 1; i++) {
			if (source.charAt(i) == ch) {
				counter++;
			}
		}

		return counter;
	}

	/**
	 * w肳ꂽLN^ZbgLȃLN^Zbg񂩔肵܂B<br>
	 * @param encode LN^Zbg`
	 * @return LȃLN^Zbg̏ꍇtrueԋp
	 */
	public static boolean isValidityEncode(String encode) {
		String value = "foo";

		try {
			value.getBytes(encode);
		} catch (UnsupportedEncodingException e) {
			return false;
		}

		return true;
	}

	/**
	 * w肵oCgŕJbgĒ񋟂܂B<br>
	 * w肳ꂽGR[hsꍇ͕ҏWɕԋp܂B<br>
	 * @param value JbgΏە
	 * @param lenb oCg
	 * @param encode GR[h
	 * @return JbgҏWs
	 */
	public static String substrb(String value, int lenb, String encode) {
		if (lenb <= 0) {
			return "";
		}

		try {
			while (value.getBytes(encode).length > lenb) {
				value = value.substring(0, value.length() - 1);
			}
			while (value.getBytes(encode).length < lenb) {
				value = value + " ";
			}
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException("sȃGR[hw肳܂", e);
		}

		return value;
	}

	/**
	 * w肵oCgŕJbgĒ񋟂܂B<br>
	 * w肳ꂽGR[hsꍇ͕ҏWɕԋp܂B<br>
	 * @param value JbgΏە
	 * @param lenb oCg
	 * @return JbgҏWs
	 */
	public static String substrb(String value, int lenb) {
		if (lenb <= 0) {
			return "";
		}

		while (value.getBytes().length > lenb) {
			value = value.substring(0, value.length() - 1);
		}
		while (value.getBytes().length < lenb) {
			value = value + " ";
		}

		return value;
	}

	/**
	 * w肳ꂽoCgɂȂ܂ŗ^ꂽɕ⊮B<br>
	 * w肳ꂽoCg^ꂽ񂪒ꍇ͂̂܂ܕԋp܂B<br>
	 * @param value ⊮Ώە
	 * @param lenb oCg
	 * @param encode GR[h
	 * @param c ⊮
	 * @param isHeadSupplement 擪ɕ⊮ꍇtruew
	 * @return ⊮ꂽ
	 */
	public static String supplementByteWithChar(String value, int lenb, String encode, char c, boolean isHeadSupplement) {
		if (lenb <= 0) {
			return "";
		}

		StringBuffer buffer = new StringBuffer(value);

		try {
			while (buffer.toString().getBytes(encode).length < lenb) {
				if (isHeadSupplement) {
					buffer.insert(0, c);
				} else {
					buffer.append(c);
				}
			}
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException("sȃGR[hw肳܂", e);
		}

		return substrb(buffer.toString(), lenb, encode);
	}

	/**
	 * w肳ꂽoCgɂȂ܂ŗ^ꂽɕ⊮B<br>
	 * w肳ꂽoCg^ꂽ񂪒ꍇ͂̂܂ܕԋp܂B<br>
	 * @param value ⊮Ώە
	 * @param lenb oCg
	 * @param c ⊮
	 * @param isHeadSupplement 擪ɕ⊮ꍇtruew
	 * @return ⊮ꂽ
	 */
	public static String supplementByteWithChar(String value, int lenb, char c, boolean isHeadSupplement) {
		if (lenb <= 0) {
			return "";
		}

		StringBuffer buffer = new StringBuffer(value);

		while (buffer.toString().getBytes().length < lenb) {
			if (isHeadSupplement) {
				buffer.insert(0, c);
			} else {
				buffer.append(c);
			}
		}

		return substrb(buffer.toString(), lenb);
	}

	/**
	 * w肳ꂽoCgɂȂ܂ŗ^ꂽ̐擪ɃXy[X⊮B<br>
	 * w肳ꂽoCg^ꂽ񂪒ꍇ͂̂܂ܕԋp܂B<br>
	 * @param value ⊮Ώە
	 * @param lenb oCg
	 * @param encode GR[h
	 * @return ⊮ꂽ
	 */
	public static String supplementByteWithSpaceHead(String value, int lenb, String encode) {
		return supplementByteWithChar(value, lenb, encode, ' ', true);
	}

	/**
	 * w肳ꂽoCgɂȂ܂ŗ^ꂽ̐擪ɃXy[X⊮B<br>
	 * w肳ꂽoCg^ꂽ񂪒ꍇ͂̂܂ܕԋp܂B<br>
	 * @param value ⊮Ώە
	 * @param lenb oCg
	 * @return ⊮ꂽ
	 */
	public static String supplementByteWithSpaceHead(String value, int lenb) {
		return supplementByteWithChar(value, lenb, ' ', true);
	}

	/**
	 * w肳ꂽoCgɂȂ܂ŗ^ꂽ̍ŌɃXy[X⊮B<br>
	 * w肳ꂽoCg^ꂽ񂪒ꍇ͂̂܂ܕԋp܂B<br>
	 * @param value ⊮Ώە
	 * @param lenb oCg
	 * @param encode GR[h
	 * @return ⊮ꂽ
	 */
	public static String supplementByteWithSpaceFoot(String value, int lenb, String encode) {
		return supplementByteWithChar(value, lenb, encode, ' ', false);
	}

	/**
	 * w肳ꂽoCgɂȂ܂ŗ^ꂽ̍ŌɃXy[X⊮B<br>
	 * w肳ꂽoCg^ꂽ񂪒ꍇ͂̂܂ܕԋp܂B<br>
	 * @param value ⊮Ώە
	 * @param lenb oCg
	 * @return ⊮ꂽ
	 */
	public static String supplementByteWithSpaceFoot(String value, int lenb) {
		return supplementByteWithChar(value, lenb, ' ', false);
	}

	/**
	 * w肳ꂽoCgɂȂ܂ŗ^ꂽ̐擪0⊮B<br>
	 * w肳ꂽoCg^ꂽ񂪒ꍇ͂̂܂ܕԋp܂B<br>
	 * @param value ⊮Ώە
	 * @param lenb oCg
	 * @param encode GR[h
	 * @return ⊮ꂽ
	 */
	public static String supplementByteWithZeroHead(String value, int lenb, String encode) {
		return supplementByteWithChar(value, lenb, encode, '0', true);
	}

	/**
	 * w肳ꂽoCgɂȂ܂ŗ^ꂽ̐擪0⊮B<br>
	 * w肳ꂽoCg^ꂽ񂪒ꍇ͂̂܂ܕԋp܂B<br>
	 * @param value ⊮Ώە
	 * @param lenb oCg
	 * @return ⊮ꂽ
	 */
	public static String supplementByteWithZeroHead(String value, int lenb) {
		return supplementByteWithChar(value, lenb, '0', true);
	}

	/**
	 * w肳ꂽoCgɂȂ܂ŗ^ꂽ̍Ō0⊮B<br>
	 * w肳ꂽoCg^ꂽ񂪒ꍇ͂̂܂ܕԋp܂B<br>
	 * @param value ⊮Ώە
	 * @param lenb oCg
	 * @param encode GR[h
	 * @return ⊮ꂽ
	 */
	public static String supplementByteWithZeroFoot(String value, int lenb, String encode) {
		return supplementByteWithChar(value, lenb, encode, '0', false);
	}

	/**
	 * w肳ꂽoCgɂȂ܂ŗ^ꂽ̍Ō0⊮B<br>
	 * w肳ꂽoCg^ꂽ񂪒ꍇ͂̂܂ܕԋp܂B<br>
	 * @param value ⊮Ώە
	 * @param lenb oCg
	 * @return ⊮ꂽ
	 */
	public static String supplementByteWithZeroFoot(String value, int lenb) {
		return supplementByteWithChar(value, lenb, '0', false);
	}

	/**
	 * w肳ꂽ(MS932z)w肳ꂽLN^ZbgɃGR[h܂B<br>
	 * @param value ϊΏە
	 * @param charset LN^Zbg
	 * @return LN^GR[hꂽ
	 */
	public static String encode(String value, String charset) {
		if (value == null) {
			return null;
		} else {
			try {
				return new String(value.getBytes(DEFAULT_JAVA_CHARSET), charset);
			} catch (UnsupportedEncodingException e) {
				throw new RuntimeException("sȃGR[hw肳܂", e);
			}
		}
	}

	/**
	 * w肳ꂽIuWFNgStringIuWFNgƂĎ擾܂B<br>
	 * IuWFNgnull̏ꍇ͋󕶎ƂĎ擾܂B<br>
	 * @param value IuWFNg
	 * @return StringIuWFNg
	 */
	public static String valueOf(Object value) {
		if (value == null) {
			return "";
		} else {
			return String.valueOf(value);
		}
	}

	/**
	 * w肳ꂽv~eBuϐStringIuWFNgƂĎ擾܂B<br>
	 * 璷IȎł͂邪StringUtils#valueOf(Object value)Ɠꐫ
	 * ׂɓNXɐ݂B<br>
	 * @param value v~eBuϐ
	 * @return StringIuWFNg
	 */
	public static String valueOf(boolean value) {
		return String.valueOf(value);
	}

	/**
	 * w肳ꂽv~eBuϐStringIuWFNgƂĎ擾܂B<br>
	 * 璷IȎł͂邪StringUtils#valueOf(Object value)Ɠꐫ
	 * ׂɓNXɐ݂B<br>
	 * @param value v~eBuϐ
	 * @return StringIuWFNg
	 */
	public static String valueOf(char value) {
		return String.valueOf(value);
	}

	/**
	 * w肳ꂽv~eBuϐStringIuWFNgƂĎ擾܂B<br>
	 * 璷IȎł͂邪StringUtils#valueOf(Object value)Ɠꐫ
	 * ׂɓNXɐ݂B<br>
	 * @param value v~eBuϐ
	 * @return StringIuWFNg
	 */
	public static String valueOf(char[] value) {
		return String.valueOf(value);
	}

	/**
	 * w肳ꂽv~eBuϐStringIuWFNgƂĎ擾܂B<br>
	 * 璷IȎł͂邪StringUtils#valueOf(Object value)Ɠꐫ
	 * ׂɓNXɐ݂B<br>
	 * @param value v~eBuϐ
	 * @return StringIuWFNg
	 */
	public static String valueOf(char[] value, int offset, int count) {
		return String.valueOf(value, offset, count);
	}

	/**
	 * w肳ꂽv~eBuϐStringIuWFNgƂĎ擾܂B<br>
	 * 璷IȎł͂邪StringUtils#valueOf(Object value)Ɠꐫ
	 * ׂɓNXɐ݂B<br>
	 * @param value v~eBuϐ
	 * @return StringIuWFNg
	 */
	public static String valueOf(double value) {
		return String.valueOf(value);
	}

	/**
	 * w肳ꂽv~eBuϐStringIuWFNgƂĎ擾܂B<br>
	 * 璷IȎł͂邪StringUtils#valueOf(Object value)Ɠꐫ
	 * ׂɓNXɐ݂B<br>
	 * @param value v~eBuϐ
	 * @return StringIuWFNg
	 */
	public static String valueOf(float value) {
		return String.valueOf(value);
	}

	/**
	 * w肳ꂽv~eBuϐStringIuWFNgƂĎ擾܂B<br>
	 * 璷IȎł͂邪StringUtils#valueOf(Object value)Ɠꐫ
	 * ׂɓNXɐ݂B<br>
	 * @param value v~eBuϐ
	 * @return StringIuWFNg
	 */
	public static String valueOf(int value) {
		return String.valueOf(value);
	}

	/**
	 * w肳ꂽv~eBuϐStringIuWFNgƂĎ擾܂B<br>
	 * 璷IȎł͂邪StringUtils#valueOf(Object value)Ɠꐫ
	 * ׂɓNXɐ݂B<br>
	 * @param value v~eBuϐ
	 * @return StringIuWFNg
	 */
	public static String valueOf(long value) {
		return String.valueOf(value);
	}

	/**
	 * w肳ꂽlLong^ɕϊ܂B<br>
	 * l̏ꍇnullIuWFNgԋp܂B<br>
	 * @param value l
	 * @return LongIuWFNg
	 */
	public static Long parseLong(String value) {
		return isEmpty(value) ? null : Long.valueOf(value);
	}

	/**
	 * w肳ꂽlInteger^ɕϊ܂B<br>
	 * l̏ꍇnullIuWFNgԋp܂B<br>
	 * @param value l
	 * @return IntegerIuWFNg
	 */
	public static Integer parseInteger(String value) {
		return isEmpty(value) ? null : Integer.valueOf(value);
	}

	/**
	 * w肳ꂽlBigDecimal^ɕϊ܂B<br>
	 * l̏ꍇnullIuWFNgԋp܂B<br>
	 * @param value l
	 * @return BigDecimalIuWFNg
	 */
	public static BigDecimal parseBigDecimal(String value) {
		return isEmpty(value) ? null : BigDecimal.valueOf(Long.parseLong(value));
	}

	/**
	 * w肳ꂽlintɕϊ܂B<br>
	 * l̏ꍇ0ԋp܂B<br>
	 * @param value l
	 * @return intl
	 */
	public static int parsePrimitiveInt(String value) {
		return isEmpty(value) ? 0 : Integer.parseInt(value);
	}

	/**
	 * w肳ꂽllongɕϊ܂B<br>
	 * l̏ꍇ0ԋp܂B<br>
	 * @param value l
	 * @return longl
	 */
	public static long parsePrimitiveLong(String value) {
		return isEmpty(value) ? 0 : Long.parseLong(value);
	}

	/**
	 * w肳ꂽlw茅܂Ő擪0⊮Ƃĕԋp܂B<br>
	 * @param value l
	 * @param length ⊮
	 * @return ⊮
	 */
	public static String formatZeroFix(int value, int length) {
		if ((value < 0) || (length < 0)) {
			throw new RuntimeException("l܂͕␳ɕw肳܂");
		}

		StringBuffer buffer = new StringBuffer(length);
		String number = String.valueOf(value);
		for (int i = 0; i < length - number.length(); i++) {
			buffer.append("0");
		}
		buffer.append(number);

		return buffer.toString();
	}

	/**
	 * w肳ꂽlw茅܂Ő擪0⊮Ƃĕԋp܂B<br>
	 * @param value l
	 * @param length ⊮
	 * @return ⊮
	 */
	public static String formatZeroFix(long value, int length) {
		if ((value < 0) || (length < 0)) {
			throw new RuntimeException("l܂͕␳ɕw肳܂");
		}

		StringBuffer buffer = new StringBuffer(length);
		String number = String.valueOf(value);
		for (int i = 0; i < length - number.length(); i++) {
			buffer.append("0");
		}
		buffer.append(number);

		return buffer.toString();
	}

	/**
	 * w肳ꂽlongl𐔒lJ}`ɏϊ܂B<br>
	 * @param value longl
	 * @return ###,###,###`
	 */
	public static String formatComma(long value) {
		return formatComma(new BigDecimal("" + value));
	}

	/**
	 * w肳ꂽintl𐔒lJ}`ɏϊ܂B<br>
	 * @param value intl
	 * @return ###,###,###`
	 */
	public static String formatComma(int value) {
		return formatComma(new BigDecimal("" + value));
	}

	/**
	 * w肳ꂽBigDecimalIuWFNg𐔒lJ}`ɏϊ܂B<br>
	 * @param value BigDecimalIuWFNg
	 * @return ###,###,###`
	 */
	public static String formatComma(BigDecimal value) {
		if (value == null) {
			return "";
		} else {
			StringBuffer render = new StringBuffer();
			String buffer = value.toString();
			for (int i = 0; i <= buffer.length() - 1; i++) {
				render.insert(0, buffer.charAt(buffer.length() - 1 - i));
				if ((i + 1) % 3 == 0) {
					render.insert(0, ',');
				}
			}

			if (render.charAt(0) == ',') {
				render.delete(0, 1);
			}

			return render.toString();
		}
	}

	/**
	 * w肳ꂽBigDecimalIuWFNgz`ɏϊ܂B<br>
	 * @param value BigDecimalIuWFNg
	 * @return \###,###,###`
	 */
	public static String formatCurrency(BigDecimal value) {
		if (value == null) {
			return "";
		} else {
			StringBuffer render = new StringBuffer();
			String buffer = value.toString();
			for (int i = 0; i <= buffer.length() - 1; i++) {
				render.insert(0, buffer.charAt(buffer.length() - 1 - i));
				if ((i + 1) % 3 == 0) {
					render.insert(0, ',');
				}
			}

			if (render.charAt(0) == ',') {
				render.delete(0, 1);
			}

			render.insert(0, '\\');

			return render.toString();
		}
	}

	/**
	 * \###,###,###`BigDecimalIuWFNgƂĎ擾܂B<br>
	 * 󕶎̏ꍇ́Anullԋp܂B܂Asȕ̏ꍇ͗O܂B<br>
	 * @param value \###,###,###`
	 * @return BigDecimalIuWFNg
	 */
	public static BigDecimal parseCurrency(String value) {
		if (isEmpty(value)) {
			return null;
		} else {
			String buffer = value;
			buffer = replace(buffer, ",", "");
			buffer = replace(buffer, "\\", "");

			return new BigDecimal(buffer);
		}
	}

	/**
	 * w肳ꂽDoubleIuWFNgw肳ꂽ_ȉŃp[Zg\LƂĎ擾܂B<br>
	 * @param value DoubleIuWFNg
	 * @param point _ȉ
	 * @return 00.00%\L
	 */
	public static String formatPercent(Double value, int point) {
		if (value == null) {
			return "";
		} else {
			String buffer = valueOf(value.doubleValue() * 100);

			buffer = buffer.indexOf("0") > 0 ? buffer + "00" : buffer + ".00";

			return point == 0 ? buffer.substring(0, buffer.indexOf(".")) : buffer.substring(0, buffer.indexOf(".") + point + 1) + "%";
		}
	}

	/**
	 * w肳ꂽ*ԋp܂B<br>
	 * @param value ϊΏە
	 * @return w肳ꂽ*
	 */
	public static String formatPassword(String value) {
		if (isEmpty(value)) {
			return "";
		} else {
			StringBuffer result = new StringBuffer();
			for (int i = 0; i <= value.getBytes().length - 1; i++) {
				result.append("*");
			}
			return result.toString();
		}
	}

	/**
	 * w肳ꂽt@CƂĎgpł镶ɏC܂B<br>
	 * t@CƂĎgps\ȕ͎w肳ꂽŒu܂B<br>
	 * @param value CΏە
	 * @param replace gpsu镶
	 * @return t@CƂĎgp\ȕ
	 */
	public static String escapeFilename(String value, String replace) {
		if (isEmpty(value)) {
			return "";
		} else {
			value = replace(value, "\\", replace);
			value = replace(value, "/", replace);
			value = replace(value, ":", replace);
			value = replace(value, "*", replace);
			value = replace(value, "?", replace);
			value = replace(value, "\"", replace);
			value = replace(value, "<", replace);
			value = replace(value, ">", replace);
			value = replace(value, "|", replace);
			return value;
		}
	}

	/**
	 * w肳ꂽɑ΂Ďw肳ꂽOɕtĒ񋟂܂B<br>
	 * @param source Ώە
	 * @param deco 
	 * @return Oɕt
	 */
	public static String bundleDecorate(String source, String deco) {
		return new StringBuffer(source).append(deco).insert(0, deco).toString();
	}

	/**
	 * w肳ꂽ{#}ɑ΂ăp[^StringIuWFNgz񏇂ɕ}Ē񋟂܂B<br>
	 * p[^StringIuWFNgnull̏ꍇ͋󕶎}܂B<br>
	 * FStringUtils.binder("Test Binding is {0}", new String[]{"success"})  Test Binding is success<br>
	 * @param source oChΏۃx[X
	 * @param params oChp[^StringIuWFNgz
	 * @return oChҏW㕶
	 */
	public static String binder(String source, String[] params) {
		if (params == null || params.length == 0 || source == null || source.length() == 0) {
			return source;
		}

		String render = source;

		for (int i = 0; i <= params.length - 1; i++) {
			render = replace(render, "{" + i + "}", params[i] == null ? "" : params[i]);
		}

		return render;
	}

	/**
	 * w肳ꂽbyte16iŒ񋟂܂B<br>
	 * @param b 16iҏWΏbyte
	 * @return 16iҏWbyte
	 */
	public static String toHexString(byte b) {
		int lbs = b & 0xf;
		int sbs = (b & 0xf0) >> 4;
		return hexStrings[sbs] + hexStrings[lbs];
	}

	/**
	 * w肳ꂽbytez16iŒ񋟂܂B<br>
	 * @param b 16iҏWΏbytez
	 * @return 16iҏWbytez
	 */
	public static String toHexString(byte[] b) {
		String result = "";
		for (int i = 0; i < b.length; i++) {
			result += toHexString(b[i]);
		}
		return result;
	}

	/**
	 * w肳ꂽMD5nbVR[h񋟂܂B<br>
	 * @param value MD5nbVR[hZoΏە
	 * @return w肳ꂽ̃nbVR[h
	 */
	public static String renderMD5Hash(String value) {
		MessageDigest md = null;

		try {
			md = MessageDigest.getInstance("MD5");
		} catch (NoSuchAlgorithmException e) {
			// ASY݂ȂƂ͗L蓾Ȃ̂ŗO̓X[Ȃ
			e.printStackTrace();
		}

		md.update(value == null ? "".getBytes() : value.getBytes());

		return toHexString(md.digest());
	}

	/**
	 * w肳ꂽʏ핶HTML`ɍ킹ƂĒ񋟂܂B<br>
	 * @param value ϊΏە
	 * @return HTML`ɍ킹
	 */
	public static String renderHTML(String value) {
		String buffer = value;
		buffer = StringUtil.replace(buffer, "\n", "<br>");
		buffer = StringUtil.replace(buffer, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
		buffer = StringUtil.replace(buffer, " ", "&nbsp;");
		return buffer;
	}
}
