package org.phosphoresce.commons.mail;

import javax.mail.Folder;
import javax.mail.Session;
import javax.mail.Store;

import org.phosphoresce.commons.mail.exception.MailTransactionException;

/**
 * [gUNVNXB<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/02/24	Kitagawa		VK쐬
 *-->
 */
public abstract class MailTransaction implements MailDeclareInterface {

	/** ݒIuWFNg */
	private MailConfiguration configuration = null;

	/** gUNVJntO */
	private boolean opened = false;

	/** ǂݎptO */
	private boolean readonly = true;

	/** JavaMailZbVIuWFNg */
	private Session session = null;

	/** JavaMailXgAIuWFNg */
	private Store store = null;

	/** JavaMailtH_IuWFNg */
	private Folder folder = null;

	/**
	 * RXgN^<br>
	 */
	private MailTransaction() {
		super();
	}

	/**
	 * RXgN^<br>
	 * @param configuration ݒIuWFNg
	 */
	protected MailTransaction(MailConfiguration configuration) {
		super();
		this.configuration = configuration;
	}

	/**
	 * gUNV̊Jnws܂B<br>
	 * @throws MailTransactionException ɃgUNV̊JnsȂꍇɔ
	 */
	public final void begin(boolean readonly) throws MailTransactionException {
		try {
			this.readonly = readonly;
			session = configuration.getSession();
			if (!configuration.isSender()) {
				store = session.getStore(configuration.getProtocol());
				store.connect(configuration.getServer(), configuration.getPort(), configuration.getUser(), configuration.getPassword());
				folder = store.getFolder(PRIMARY_FOLDER);
				folder.open(readonly ? Folder.READ_ONLY : Folder.READ_WRITE);
			}
			opened = true;
		} catch (Exception e) {
			throw new MailTransactionException("[gUNV̊JnɎs܂", e);
		}
	}

	/**
	 * gUNV̏Iws܂B<br>
	 * @throws MailTransactionException ɃgUNV̏IsȂꍇɔ
	 */
	public final void close() throws MailTransactionException {
		try {
			if (!configuration.isSender()) {
				folder.close(!readonly);
				store.close();
			}
			folder = null;
			store = null;
			session = null;
			opened = false;
		} catch (Exception e) {
			throw new MailTransactionException("[gUNṼN[YɎs܂", e);
		}
	}

	/**
	 * gUNVJnς݂ł邩肵܂B<br>
	 * @return gUNVJnς݂łꍇAtrueԋp
	 */
	public final boolean isOpened() {
		return this.opened;
	}

	/**
	 * ݒIuWFNg擾܂B<br>
	 * @return ݒIuWFNg
	 */
	final MailConfiguration getConfiguration() {
		return this.configuration;
	}

	/**
	 * JavaMailtH_IuWFNg擾܂B<br>
	 * @return JavaMailtH_IuWFNg
	 */
	final Folder getFolder() {
		return this.folder;
	}

	/**
	 * JavaMailZbVIuWFNg擾܂B<br>
	 * @return JavaMailZbVIuWFNg
	 */
	final Session getSession() {
		return this.session;
	}

	/**
	 * JavaMailXgAIuWFNg擾܂B<br>
	 * @return JavaMailXgAIuWFNg
	 */
	final Store getStore() {
		return this.store;
	}
}
