package org.phosphoresce.commons.mail.mail;

import java.io.Serializable;

import javax.mail.Address;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;

import org.phosphoresce.commons.mail.MailDeclareInterface;
import org.phosphoresce.commons.mail.exception.MailAddressException;
import org.phosphoresce.commons.mail.exception.MailMessageException;
import org.phosphoresce.commons.util.StringUtil;

/**
 * [샆[eBeBNXB<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/02/24	Kitagawa		VK쐬
 * 2007/03/06	Kitagawa		[AhX񐶐C^tF[Xǉ
 *-->
 */
public final class MailUtil implements Serializable, MailDeclareInterface {

	/**
	 * RXgN^<br>
	 */
	private MailUtil() {
		super();
	}

	/**
	 * w肳ꂽAhX𕶎ƂĎ擾܂B<br>
	 * @param addresses AhX
	 * @return ɃfR[hꂽAhX
	 * @throws MailAddressException ɃAhXϊsȂꍇɔ
	 */
	public static String createMailAddressValue(Address[] addresses) throws MailAddressException {
		try {
			String value = InternetAddress.toString(addresses);
			value = StringUtil.replace(value, "\"", "");
			value = value == null ? "" : MimeUtility.decodeText(value);
			value = StringUtil.replace(value, "\r", "");
			value = StringUtil.replace(value, "\t", "");
			value = StringUtil.replace(value, "\n", "");
			return value;
		} catch (Exception e) {
			throw new MailAddressException("AhX̎擾ɗ\ʗO܂", e);
		}
	}

	/**
	 * w肳ꂽAhX𕶎ƂĎ擾܂B<br>
	 * @param addresse AhX
	 * @return ɃfR[hꂽAhX
	 * @throws MailAddressException ɃAhXϊsȂꍇɔ
	 */
	public static String createMailAddressValue(Address addresse) throws MailAddressException {
		try {
			return createMailAddressValue(new Address[] { addresse });
		} catch (Exception e) {
			throw new MailAddressException("AhX̎擾ɗ\ʗO܂", e);
		}
	}

	/**
	 * w肳ꂽAhXInternetAddress`̑ÓȕƂĒ񋟂܂B<br>
	 * @param mailaddress [AhX
	 * @param name [
	 * @return InternetAddress`̑Óȕ
	 * @throws MailAddressException ɃAhXϊsȂꍇɔ
	 */
	public static String createMailAddressValue(String mailaddress, String name) throws MailAddressException {
		return createMailAddressValue(createMailAddress(mailaddress, name));
	}

	/**
	 * w肳ꂽAhXInternetAddress`̑ÓȕƂĒ񋟂܂B<br>
	 * @param mailaddress [AhX
	 * @param name [
	 * @param charset LN^[Zbg
	 * @return InternetAddress`̑Óȕ
	 * @throws MailAddressException ɃAhXϊsȂꍇɔ
	 */
	public static String createMailAddressValue(String mailaddress, String name, String charset) throws MailAddressException {
		return createMailAddressValue(createMailAddress(mailaddress, name, charset));
	}

	/**
	 * w肳ꂽAhXInternetAddress`̑ÓȕƂĒ񋟂܂B<br>
	 * @param mailaddress [AhX
	 * @return InternetAddress`̑Óȕ
	 * @throws MailAddressException ɃAhXϊsȂꍇɔ
	 */
	public static String createMailAddressValue(String mailaddress) throws MailAddressException {
		return createMailAddressValue(createMailAddress(mailaddress));
	}

	/**
	 * w肳ꂽ[AhX̃AhXIuWFNg𐶐܂B<br>
	 * @param mailaddress [AhX
	 * @param name O([AhXGCAX)
	 * @param charset LN^[Zbg
	 * @return [AhX̃AhXIuWFNg
	 * @throws MailAddressException Ƀ[AhXIuWFNg𐶐łȂꍇɔ
	 */
	public static Address createMailAddress(String mailaddress, String name, String charset) throws MailAddressException {
		try {
			return new InternetAddress(mailaddress, name, charset);
		} catch (Exception e) {
			throw new MailAddressException("Ƀ[AhXIuWFNg𐶐邱Ƃo܂ł", e);
		}
	}

	/**
	 * w肳ꂽ[AhX̃AhXIuWFNg𐶐܂B<br>
	 * @param mailaddress [AhX
	 * @param name O([AhXGCAX)
	 * @return [AhX̃AhXIuWFNg
	 * @throws MailAddressException Ƀ[AhXIuWFNg𐶐łȂꍇɔ
	 */
	public static Address createMailAddress(String mailaddress, String name) throws MailAddressException {
		return createMailAddress(mailaddress, name, DEFAULT_MIME_CHARSET);
	}

	/**
	 * w肳ꂽ[AhX̃AhXIuWFNg𐶐܂B<br>
	 * @param mailaddress [AhX
	 * @return [AhX̃AhXIuWFNg
	 * @throws MailAddressException Ƀ[AhXIuWFNg𐶐łȂꍇɔ
	 */
	public static Address createMailAddress(String mailaddress) throws MailAddressException {
		return createMailAddress(mailaddress, null, DEFAULT_MIME_CHARSET);
	}

	/**
	 * w肳ꂽPartIuWFNg񋟂Content-Typẽp[^擾܂B<br>
	 * @param part PartIuWFNg
	 * @param parameter 擾p[^L[
	 * @return w肳ꂽL[Content-Typep[^
	 * @throws MailMessageException Content-Type񂩂p[^擾łȂꍇɔ 
	 */
	public static String getContentType(Part part, String parameter) throws MailMessageException {
		try {
			ContentType contentType = new ContentType(MailSafeAccesserUtil.getContentType(part));

			StringBuffer buffer = new StringBuffer();

			// tbgȒ`̌
			if (contentType.getParameter(parameter) != null) {
				buffer.append(StringUtil.replace(contentType.getParameter(parameter), "\"", ""));
			}

			// z`Ă邪PLq̌
			if (contentType.getParameter(parameter + "*") != null) {
				buffer.append(StringUtil.replace(contentType.getParameter(parameter + "*"), "\"", ""));
			}

			// z`Ă邪PLq̌
			if (contentType.getParameter(parameter + "**") != null) {
				buffer.append(StringUtil.replace(contentType.getParameter(parameter + "**"), "\"", ""));
			}

			// z`ĂLq̌
			for (int i = 0; i <= Integer.MAX_VALUE; i++) {
				String name = contentType.getParameter(parameter + "*" + i + "*");
				if (name != null) {
					buffer.append(name);
				} else {
					break;
				}
			}

			return MimeUtility.decodeText(buffer.toString());
		} catch (Exception e) {
			return "";
		}
	}

	/**
	 * w肳ꂽPartIuWFNg񋟂Content-TypeɃp[^݂邩肵܂B<br>
	 * @param part PartIuWFNg
	 * @param parameter 擾p[^L[
	 * @return w肳ꂽPartIuWFNg񋟂Content-TypeɃp[^݂ꍇAtrueԋp
	 * @throws MailMessageException Content-Type񂩂p[^擾łȂꍇɔ
	 */
	public static boolean hasContentType(Part part, String parameter) throws MailMessageException {
		return !StringUtil.isEmpty(getContentType(part, parameter));
	}

	/**
	 * w肳ꂽPartIuWFNg̃LN^[Zbg擾܂B<br>
	 * @param part PartIuWFNg
	 * @return LN^[Zbg
	 * @throws MailMessageException Content-Type񂩂LN^[Zbg擾łȂꍇɔ
	 */
	public static String getCharset(Part part) throws MailMessageException {
		return getContentType(part, "charset");
	}
}
