/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.logging.appender;

import java.util.HashMap;
import java.util.Map;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.phosphoresce.commons.eswing.ETextPane;
import org.phosphoresce.commons.eswing.event.LineLimitationDocumentListener;
import org.phosphoresce.commons.logging.config.LoggingColorSet;

public class TextPaneAppender
extends AppenderSkeleton {
    public static int DEFAULT_MAX_ROW = 100;
    private static Map instaces = null;
    private ETextPane loggingTarget = null;
    private LoggingColorSet colorSet = null;
    private int limitRow = DEFAULT_MAX_ROW;

    public TextPaneAppender(int limitRow, LoggingColorSet colorSet) {
        this.limitRow = limitRow;
        this.colorSet = colorSet;
        this.loggingTarget = this.createNewLoggingTarget();
    }

    public TextPaneAppender(int row) {
        this(row, null);
    }

    public TextPaneAppender() {
        this(DEFAULT_MAX_ROW, null);
    }

    public int getLimitRow() {
        return this.limitRow;
    }

    public void setLimitRow(int limitRow) {
        this.limitRow = limitRow;
    }

    public LoggingColorSet getColorSet() {
        return this.colorSet;
    }

    public void setColorSet(LoggingColorSet colorSet) {
        this.colorSet = colorSet;
    }

    public static TextPaneAppender getAppender(String name) {
        if (instaces == null) {
            return null;
        }
        return (TextPaneAppender)((Object)instaces.get(name));
    }

    private ETextPane createNewLoggingTarget() {
        ETextPane target = new ETextPane();
        target.setEditable(false);
        target.getDocument().addDocumentListener((DocumentListener)new LineLimitationDocumentListener(this.limitRow));
        return target;
    }

    private AttributeSet createLoggingColorAttribute(Level level) {
        SimpleAttributeSet attribute = null;
        if (this.colorSet != null && level != null) {
            if (Level.FATAL.equals((Object)level)) {
                attribute = new SimpleAttributeSet();
                StyleConstants.setForeground(attribute, this.colorSet.getFatalColor());
            } else if (Level.ERROR.equals((Object)level)) {
                attribute = new SimpleAttributeSet();
                StyleConstants.setForeground(attribute, this.colorSet.getErrorColor());
            } else if (Level.WARN.equals((Object)level)) {
                attribute = new SimpleAttributeSet();
                StyleConstants.setForeground(attribute, this.colorSet.getWarnColor());
            } else if (Level.INFO.equals((Object)level)) {
                attribute = new SimpleAttributeSet();
                StyleConstants.setForeground(attribute, this.colorSet.getInfoColor());
            } else if (Level.DEBUG.equals((Object)level)) {
                attribute = new SimpleAttributeSet();
                StyleConstants.setForeground(attribute, this.colorSet.getDebugColor());
            }
        }
        return attribute;
    }

    public ETextPane getLoggingTarget() {
        return this.loggingTarget;
    }

    public void activateOptions() {
        if (instaces == null) {
            instaces = new HashMap();
        }
        if (instaces.get(this.name) == null) {
            instaces.put(this.name, this);
        }
    }

    protected void append(LoggingEvent event) {
        try {
            String[] stackTraces;
            Document document = this.loggingTarget.getDocument();
            String value = this.layout != null ? this.layout.format(event) : event.toString();
            document.insertString(document.getLength(), value, this.createLoggingColorAttribute(event.getLevel()));
            if (this.layout.ignoresThrowable() && (stackTraces = event.getThrowableStrRep()) != null) {
                int len = stackTraces.length;
                for (int i = 0; i < len; ++i) {
                    document.insertString(document.getLength(), stackTraces[i], this.createLoggingColorAttribute(event.getLevel()));
                    document.insertString(document.getLength(), Layout.LINE_SEP, this.createLoggingColorAttribute(event.getLevel()));
                }
            }
            this.loggingTarget.setCaretPosition(document.getLength());
        }
        catch (BadLocationException e) {
            LogLog.error((String)"failed to append log.", (Throwable)e);
        }
    }

    public void close() {
        if (instaces != null) {
            instaces.remove(this.getName());
        }
    }

    public boolean requiresLayout() {
        return false;
    }
}

