/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.eswing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JTable;
import org.phosphoresce.commons.eswing.core.ESwingConfig;
import org.phosphoresce.commons.eswing.table.ETableCellStepColoredRenderer;

public class ETableCellHoverColoredRenderer
extends ETableCellStepColoredRenderer
implements MouseMotionListener {
    private boolean hoverColoring = true;
    private int pointedRow = -1;
    private int pointedCol = -1;

    public ETableCellHoverColoredRenderer(JTable table, boolean hoverColoring) {
        super(table);
        this.hoverColoring = hoverColoring;
        table.addMouseMotionListener(this);
    }

    public ETableCellHoverColoredRenderer(JTable table) {
        this(table, true);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Color background = super.getBackground();
        Color foreground = super.getForeground();
        if (this.hoverColoring) {
            if (!hasFocus && !isSelected) {
                if (this.hoverColoring) {
                    if (this.pointedRow == row) {
                        background = ESwingConfig.getTableHoverCellBackgroundColor();
                        foreground = ESwingConfig.getTableHoverCellForegroungColor();
                    }
                } else if (this.pointedRow == row && this.pointedCol == column) {
                    background = ESwingConfig.getTableHoverCellBackgroundColor();
                    foreground = ESwingConfig.getTableHoverCellForegroungColor();
                }
            }
            this.setBackground(background);
            this.setForeground(foreground);
        }
        return this;
    }

    public void mouseMoved(MouseEvent e) {
        Point point = e.getPoint();
        int nrow = this.getParentTable().rowAtPoint(point);
        int ncol = this.getParentTable().columnAtPoint(point);
        if (nrow < 0 || ncol < 0) {
            this.pointedRow = -1;
            this.pointedCol = -1;
        } else {
            this.pointedRow = nrow;
            this.pointedCol = ncol;
        }
        this.getParentTable().repaint();
    }

    public void mouseDragged(MouseEvent e) {
    }

    public boolean isHoverColoring() {
        return this.hoverColoring;
    }

    public void setHoverColoring(boolean hoverColoring) {
        this.hoverColoring = hoverColoring;
    }
}

