package org.phosphoresce.commons.logging.appender;

import java.util.HashMap;
import java.util.Map;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.phosphoresce.commons.eswing.ETextPane;
import org.phosphoresce.commons.eswing.event.LineLimitationDocumentListener;
import org.phosphoresce.commons.logging.config.LoggingColorSet;

/**
 * eLXgyCMOAy_NX<br>
 * <br>
 * NXLog4J̃MOɂăeLXgyCIuWFNgɏo͂C^tF[X񋟂܂B<br>
 * MOAy_CX^XLog4JAy_ŃAvP[VsɉiIɃ}bv`ŕێ܂B<br>
 * Log4JȊÕIuWFNg̎QƂl݌vłÃCX^Xjׂɂ́A
 * [U[Ӑ}IɃAy_ŔjwsKv܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/26	Kitagawa		VK쐬
 *-->
 */
public class TextPaneAppender extends AppenderSkeleton {

	/** fBtHgős */
	public static int DEFAULT_MAX_ROW = 100;

	/** CX^X}bv */
	private static Map instaces = null;

	/** MOΏۃIuWFNg */
	private ETextPane loggingTarget = null;

	/** MOJ[Zbg */
	private LoggingColorSet colorSet = null;

	/** s */
	private int limitRow = DEFAULT_MAX_ROW;

	// Constructor

	/**
	 * RXgN^<br>
	 * @param limitRow s
	 * @param colorSet MOJ[Zbg
	 */
	public TextPaneAppender(int limitRow, LoggingColorSet colorSet) {
		super();
		this.limitRow = limitRow;
		this.colorSet = colorSet;
		this.loggingTarget = createNewLoggingTarget();
	}

	/**
	 * RXgN^<br>
	 * @param row s
	 */
	public TextPaneAppender(int row) {
		this(row, null);
	}

	/**
	 * RXgN^<br>
	 */
	public TextPaneAppender() {
		this(DEFAULT_MAX_ROW, null);
	}

	// Feild Accessor

	/**
	 * s擾܂B<br>
	 * @return s
	 */
	public int getLimitRow() {
		return limitRow;
	}

	/**
	 * sݒ肵܂B<br>
	 * @param limitRow s
	 */
	public void setLimitRow(int limitRow) {
		this.limitRow = limitRow;
	}

	/**
	 * MOJ[Zbg擾܂B<br>
	 * @return MOJ[Zbg
	 */
	public LoggingColorSet getColorSet() {
		return colorSet;
	}

	/**
	 * MOJ[Zbgݒ肵܂B<br>
	 * @param colorSet MOJ[Zbg
	 */
	public void setColorSet(LoggingColorSet colorSet) {
		this.colorSet = colorSet;
	}

	// Static Method

	/**
	 * w肳ꂽÕMOΏۃIuWFNg擾܂B<br>
	 * @param name MOΏۃIuWFNg
	 * @return MOΏۃIuWFNg
	 */
	public static TextPaneAppender getAppender(String name) {
		if (instaces == null) {
			return null;
		}
		return (TextPaneAppender) instaces.get(name);
	}

	// Instance Method

	/**
	 * VMOΏۃIuWFNg𐶐܂B<br>
	 * @return VMOΏۃIuWFNg
	 */
	private ETextPane createNewLoggingTarget() {
		ETextPane target = new ETextPane();
		target.setEditable(false);
		target.getDocument().addDocumentListener(new LineLimitationDocumentListener(limitRow));
		return target;
	}

	/**
	 * w肳ꂽOxAttributeSetIuWFNg𐶐܂B<br>
	 * @param level Ox
	 * @return AttributeSetIuWFNg
	 */
	private AttributeSet createLoggingColorAttribute(Level level) {
		SimpleAttributeSet attribute = null;
		if (colorSet != null && level != null) {
			if (Level.FATAL.equals(level)) {
				attribute = new SimpleAttributeSet();
				StyleConstants.setForeground(attribute, colorSet.getFatalColor());
			} else if (Level.ERROR.equals(level)) {
				attribute = new SimpleAttributeSet();
				StyleConstants.setForeground(attribute, colorSet.getErrorColor());
			} else if (Level.WARN.equals(level)) {
				attribute = new SimpleAttributeSet();
				StyleConstants.setForeground(attribute, colorSet.getWarnColor());
			} else if (Level.INFO.equals(level)) {
				attribute = new SimpleAttributeSet();
				StyleConstants.setForeground(attribute, colorSet.getInfoColor());
			} else if (Level.DEBUG.equals(level)) {
				attribute = new SimpleAttributeSet();
				StyleConstants.setForeground(attribute, colorSet.getDebugColor());
			}
		}
		return attribute;
	}

	/**
	 * MOΏۃIuWFNg擾܂B<br>
	 * @return MOΏۃIuWFNg
	 */
	public ETextPane getLoggingTarget() {
		return loggingTarget;
	}

	// Appender Interface Method

	/**
	 * MOAy_IvVLɂ܂B<br>
	 * @see org.apache.log4j.AppenderSkeleton#activateOptions()
	 */
	public void activateOptions() {
		if (instaces == null) {
			instaces = new HashMap();
		}
		if (instaces.get(name) == null) {
			instaces.put(name, this);
		}
	}

	/**
	 * MOCxgAyh܂B<br>
	 * @param event MOCxgIuWFNg
	 * @see org.apache.log4j.AppenderSkeleton#append(org.apache.log4j.spi.LoggingEvent)
	 */
	protected void append(LoggingEvent event) {
		try {
			Document document = loggingTarget.getDocument();
			String value = layout != null ? layout.format(event) : event.toString();
			document.insertString(document.getLength(), value, createLoggingColorAttribute(event.getLevel()));
			if (layout.ignoresThrowable()) {
				String stackTraces[] = event.getThrowableStrRep();
				if (stackTraces != null) {
					int len = stackTraces.length;
					for (int i = 0; i < len; i++) {
						document.insertString(document.getLength(), stackTraces[i], createLoggingColorAttribute(event.getLevel()));
						document.insertString(document.getLength(), Layout.LINE_SEP, createLoggingColorAttribute(event.getLevel()));
					}
				}
			}
			loggingTarget.setCaretPosition(document.getLength());
		} catch (BadLocationException e) {
			LogLog.error("failed to append log.", e);
		}
	}

	/**
	 * Ay_IuWFNgN[Y܂B<br>
	 * @see org.apache.log4j.Appender#close()
	 */
	public void close() {
		if (instaces != null) {
			instaces.remove(getName());
		}
	}

	/**
	 * CAEgReiIuWFNgK{ł邩肵܂B<br>
	 * @return Ay_NXł̓CAEgRei͕K{ł͂ȂׁAfalseԋp
	 * @see org.apache.log4j.Appender#requiresLayout()
	 */
	public boolean requiresLayout() {
		return false;
	}
}
