/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.gui.panel.dbinformation;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.DatabaseSpecification;
import org.phosphoresce.commons.eswing.EFieldSet;
import org.phosphoresce.commons.eswing.EScrollPane;
import org.phosphoresce.commons.eswing.ETable;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;

public class DatabaseSpecificationFieldSet
extends EFieldSet
implements RefreshableComponent {
    private Log log = LogFactory.getLog(this.getClass());
    private static DatabaseSpecificationFieldSet instance = null;
    private EScrollPane databaseSpecificationTableScrollPane = null;
    private ETable databaseSpecificationTable = null;

    private DatabaseSpecificationFieldSet() {
        this.initialize();
    }

    public static DatabaseSpecificationFieldSet instance() {
        if (instance == null) {
            instance = new DatabaseSpecificationFieldSet();
        }
        return instance;
    }

    public void refresh() throws Throwable {
        DatabaseSpecification specification = new DatabaseSpecification(DatabaseBrowserSession.instance().getCommonDatabaseSession());
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn((Object)"name", new String[]{"MaxConnections", "MaxRowSize", "MaxStatements", "MaxStatementLength", "MaxUserNameLength", "MaxCatalogNameLength", "MaxSchemaNameLength", "MaxTableNameLength", "MaxColumnNameLength", "MaxCursorNameLength", "MaxProcedureNameLength", "MaxIndexLength", "MaxTablesInSelect", "MaxBinaryLiteralLength", "MaxCharLiteralLength", "MaxColumnsInGroupBy", "MaxColumnsInIndex", "MaxColumnsInOrderBy", "MaxColumnsInSelect", "MaxColumnsInTable", "DefaultTransactionIsolationName", "ResultSetHoldabilityName", "SQLStateTypeName"});
        model.addColumn((Object)"value", new String[]{String.valueOf(specification.getMaxConnections()), String.valueOf(specification.getMaxRowSize()), String.valueOf(specification.getMaxStatements()), String.valueOf(specification.getMaxStatementLength()), String.valueOf(specification.getMaxUserNameLength()), String.valueOf(specification.getMaxCatalogNameLength()), String.valueOf(specification.getMaxSchemaNameLength()), String.valueOf(specification.getMaxTableNameLength()), String.valueOf(specification.getMaxColumnNameLength()), String.valueOf(specification.getMaxCursorNameLength()), String.valueOf(specification.getMaxProcedureNameLength()), String.valueOf(specification.getMaxIndexLength()), String.valueOf(specification.getMaxTablesInSelect()), String.valueOf(specification.getMaxBinaryLiteralLength()), String.valueOf(specification.getMaxCharLiteralLength()), String.valueOf(specification.getMaxColumnsInGroupBy()), String.valueOf(specification.getMaxColumnsInIndex()), String.valueOf(specification.getMaxColumnsInOrderBy()), String.valueOf(specification.getMaxColumnsInSelect()), String.valueOf(specification.getMaxColumnsInTable()), specification.getDefaultTransactionIsolationName(), specification.getResultSetHoldabilityName(), specification.getSQLStateTypeName()});
        this.getDatabaseSpecificationTable().setModel((TableModel)model);
        this.getDatabaseSpecificationTable().getColumnModel().getColumn(0).setMaxWidth(200);
        this.getDatabaseSpecificationTable().getColumnModel().getColumn(0).setMinWidth(200);
        this.getDatabaseSpecificationTable().setEnabled(false);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(500, 200));
        this.setPreferredSize(new Dimension(500, 200));
        this.setMaximumSize(new Dimension(500, 200));
        this.setMinimumSize(new Dimension(500, 200));
        this.setText("Database Specification");
        this.add((Component)this.getDatabaseSpecificationTableScrollPane(), gridBagConstraints1);
    }

    private EScrollPane getDatabaseSpecificationTableScrollPane() {
        if (this.databaseSpecificationTableScrollPane == null) {
            this.databaseSpecificationTableScrollPane = new EScrollPane();
            this.databaseSpecificationTableScrollPane.setViewportView((Component)this.getDatabaseSpecificationTable());
        }
        return this.databaseSpecificationTableScrollPane;
    }

    private ETable getDatabaseSpecificationTable() {
        if (this.databaseSpecificationTable == null) {
            this.databaseSpecificationTable = new ETable();
        }
        return this.databaseSpecificationTable;
    }
}

